/*
 * Decompiled with CFR 0.152.
 */
package net.frozenblock.lib.shadow.xjs.data.serialization.util;

public abstract class BufferedStack {
    protected Object[] stack = new Object[10];
    protected int index;

    public static <T1, T2> OfTwo<T1, T2> ofTwo() {
        return new OfTwo();
    }

    public boolean isEmpty() {
        return this.index == 0;
    }

    protected void grow() {
        Object[] newStack = new Object[this.stack.length + 10];
        System.arraycopy(this.stack, 0, newStack, 0, this.index);
        this.stack = newStack;
    }

    public static class OfTwo<T1, T2>
    extends BufferedStack {
        public void push(T1 t1, T2 t2) {
            if (this.index >= this.stack.length) {
                this.grow();
            }
            this.stack[this.index] = t1;
            this.stack[this.index + 1] = t2;
            this.index += 2;
        }

        public void pop() {
            this.index -= 2;
        }

        public T1 getFirst() {
            return (T1)this.stack[this.index];
        }

        public T2 getSecond() {
            return (T2)this.stack[this.index + 1];
        }

        public int getIndex() {
            return this.index != 0 ? this.index / 2 : 0;
        }
    }
}

