/*
 * Decompiled with CFR 0.152.
 */
package net.frozenblock.lib.shadow.xjs.data.serialization.token;

import java.io.Closeable;
import java.io.IOException;
import net.frozenblock.lib.shadow.xjs.data.StringType;
import net.frozenblock.lib.shadow.xjs.data.serialization.token.NumberToken;
import net.frozenblock.lib.shadow.xjs.data.serialization.token.ParsedToken;
import net.frozenblock.lib.shadow.xjs.data.serialization.token.StringToken;
import net.frozenblock.lib.shadow.xjs.data.serialization.token.SymbolToken;
import net.frozenblock.lib.shadow.xjs.data.serialization.token.Token;
import net.frozenblock.lib.shadow.xjs.data.serialization.token.TokenStream;
import net.frozenblock.lib.shadow.xjs.data.serialization.token.TokenType;
import net.frozenblock.lib.shadow.xjs.data.serialization.util.PositionTrackingReader;
import org.jetbrains.annotations.Nullable;

public abstract class Tokenizer
implements Closeable {
    protected final PositionTrackingReader reader;
    protected final boolean containerized;
    protected int index;
    protected int line;
    protected int column;

    public Tokenizer(PositionTrackingReader reader, boolean containerized) {
        this.reader = reader;
        this.containerized = containerized;
    }

    public TokenStream stream() {
        return new TokenStream(this, TokenType.OPEN);
    }

    public PositionTrackingReader getReader() {
        return this.reader;
    }

    @Nullable
    public final Token next() throws IOException {
        if (this.containerized) {
            return this.containerize(this.single());
        }
        return this.single();
    }

    protected Token containerize(Token t) {
        TokenType type = this.getOpenerType(t);
        if (type != null) {
            return new TokenStream(this, t, type);
        }
        return t;
    }

    @Nullable
    protected TokenType getOpenerType(Token t) {
        if (t == null) {
            return null;
        }
        if (t.isSymbol('(')) {
            return TokenType.PARENTHESES;
        }
        if (t.isSymbol('{')) {
            return TokenType.BRACES;
        }
        if (t.isSymbol('[')) {
            return TokenType.BRACKETS;
        }
        return null;
    }

    @Nullable
    protected abstract Token single() throws IOException;

    protected void startReading() {
        PositionTrackingReader reader = this.reader;
        this.index = reader.index;
        this.line = reader.line;
        this.column = reader.column;
    }

    protected Token quote(char quote) throws IOException {
        String parsed = this.reader.readQuoted(quote);
        if (parsed.isEmpty() && quote == '\'' && this.reader.readIf('\'')) {
            String multi = this.reader.readMulti(false);
            return this.newStringToken(multi, StringType.MULTI);
        }
        StringType type = quote == '\'' ? StringType.SINGLE : StringType.DOUBLE;
        return this.newStringToken(parsed, type);
    }

    protected Token comment(char c) throws IOException {
        PositionTrackingReader reader = this.reader;
        if (c == '#') {
            return reader.readHashComment();
        }
        reader.read();
        int next = reader.current;
        if (next == 47) {
            return reader.readLineComment();
        }
        if (next == 42) {
            return reader.readBlockComment();
        }
        return this.newSymbolToken(c);
    }

    protected Token word() throws IOException {
        PositionTrackingReader reader = this.reader;
        int i = this.index;
        reader.startCapture();
        do {
            char c;
            if (!this.isLegalWordCharacter(c = (char)reader.current)) {
                if (reader.index - i != 0) break;
                reader.read();
                reader.invalidateCapture();
                return this.newSymbolToken(c);
            }
            reader.read();
        } while (!reader.isEndOfText());
        return this.newWordToken(reader.endCapture());
    }

    protected boolean isLegalWordCharacter(char c) {
        return c == '_' || Character.isLetterOrDigit(c);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected Token number() throws IOException {
        PositionTrackingReader reader = this.reader;
        reader.startCapture();
        if (reader.current == 48) {
            reader.read();
            if (Character.isDigit(reader.current)) {
                reader.invalidateCapture();
                return this.word();
            }
            if (reader.current != 46) return this.newNumberToken(reader.endCapture(), 0.0);
            reader.read();
            if (!reader.isDigit()) {
                return this.newNumberToken(reader.endCapture(), 0.0);
            }
        } else if (reader.current == 45 || reader.current == 46 || reader.current == 43) {
            char c = (char)reader.current;
            reader.read();
            if (!reader.isDigit()) {
                if (reader.readInfinity()) {
                    return this.newNumberToken(reader.endCapture(), Double.NEGATIVE_INFINITY);
                }
                reader.invalidateCapture();
                return this.newSymbolToken(c);
            }
        }
        reader.readAllDigits();
        if (reader.readIf('.')) {
            if (!reader.isDigit()) {
                return this.parseNumber(reader.endCapture());
            }
            reader.readAllDigits();
        }
        if (!reader.readIf('e') && !reader.readIf('E')) return this.parseNumber(reader.endCapture());
        if (!reader.readIf('+')) {
            reader.readIf('-');
        }
        if (!reader.readDigit()) {
            return this.newWordToken(reader.endCapture());
        }
        reader.readAllDigits();
        return this.parseNumber(reader.endCapture());
    }

    protected Token newLine() throws IOException {
        this.reader.read();
        return new SymbolToken(this.index, this.reader.index, this.line, this.column, TokenType.BREAK, '\n');
    }

    protected Token newStringToken(String parsed, StringType type) {
        return new StringToken(this.index, this.reader.index, this.line, this.reader.line, this.column, type, parsed);
    }

    protected Token parseNumber(String capture) {
        return this.newNumberToken(capture, Double.parseDouble(capture));
    }

    protected Token newNumberToken(String capture, double number) {
        return new NumberToken(this.index, this.reader.index, this.line, this.column, number, capture);
    }

    protected Token newWordToken(String capture) {
        return new ParsedToken(this.index, this.reader.index, this.line, this.column, TokenType.WORD, capture);
    }

    protected Token newSymbolToken(char symbol) {
        return new SymbolToken(this.index, this.reader.index, this.line, this.column, symbol);
    }

    @Override
    public void close() throws IOException {
        this.reader.close();
    }

    protected void updateSpan(Token t, int s, int e, int l, int o) {
        t.setStart(s);
        t.setEnd(e);
        t.setLine(l);
        t.setOffset(o);
    }

    protected void updateSpan(Token t, int s, int e, int l, int ll, int o) {
        this.updateSpan(t, s, e, l, o);
        t.setLastLine(ll);
    }

    public static interface ReaderConstructor {
        public Tokenizer construct(PositionTrackingReader var1, boolean var2) throws IOException;
    }
}

