/*
 * Decompiled with CFR 0.152.
 */
package net.frozenblock.lib.shadow.xjs.data.serialization.token;

import java.io.IOException;
import net.frozenblock.lib.shadow.xjs.data.serialization.token.Token;
import net.frozenblock.lib.shadow.xjs.data.serialization.token.Tokenizer;
import net.frozenblock.lib.shadow.xjs.data.serialization.util.PositionTrackingReader;
import org.jetbrains.annotations.Nullable;

public class DjsTokenizer
extends Tokenizer {
    public DjsTokenizer(PositionTrackingReader reader) {
        this(reader, false);
    }

    public DjsTokenizer(PositionTrackingReader reader, boolean containerized) {
        super(reader, containerized);
    }

    @Override
    @Nullable
    protected Token single() throws IOException {
        this.reader.skipLineWhitespace();
        if (this.reader.isEndOfText()) {
            return null;
        }
        char c = (char)this.reader.current;
        this.startReading();
        return switch (c) {
            case '+', '-', '.', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9' -> this.number();
            case '#', '/' -> this.comment(c);
            case '\"', '\'' -> this.quote(c);
            case '\n' -> this.newLine();
            default -> this.word();
        };
    }
}

