/*
 * Decompiled with CFR 0.152.
 */
package net.frozenblock.lib.shadow.xjs.data;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Array;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.UnaryOperator;
import java.util.stream.DoubleStream;
import java.util.stream.LongStream;
import java.util.stream.Stream;
import net.frozenblock.lib.shadow.xjs.data.JsonArray;
import net.frozenblock.lib.shadow.xjs.data.JsonLiteral;
import net.frozenblock.lib.shadow.xjs.data.JsonNumber;
import net.frozenblock.lib.shadow.xjs.data.JsonObject;
import net.frozenblock.lib.shadow.xjs.data.JsonReference;
import net.frozenblock.lib.shadow.xjs.data.JsonString;
import net.frozenblock.lib.shadow.xjs.data.JsonValue;
import net.frozenblock.lib.shadow.xjs.data.serialization.JsonContext;
import net.frozenblock.lib.shadow.xjs.data.transform.JsonCollectors;
import org.jetbrains.annotations.Nullable;

public final class Json {
    private Json() {
    }

    public static JsonNumber value(long value) {
        return new JsonNumber(value);
    }

    public static JsonNumber value(double value) {
        return new JsonNumber(value);
    }

    public static JsonLiteral value(boolean value) {
        return value ? JsonLiteral.jsonTrue() : JsonLiteral.jsonFalse();
    }

    public static JsonValue value(@Nullable String value) {
        return value != null ? new JsonString(value) : JsonLiteral.jsonNull();
    }

    public static JsonValue nonnull(@Nullable JsonValue value) {
        return value != null ? value : JsonLiteral.jsonNull();
    }

    public static JsonArray array() {
        return new JsonArray();
    }

    public static JsonArray array(Collection<?> collection) {
        return collection.stream().collect(JsonCollectors.any());
    }

    public static JsonArray array(long ... values) {
        return LongStream.of(values).mapToObj(Json::value).collect(JsonCollectors.value());
    }

    public static JsonArray array(double ... values) {
        return DoubleStream.of(values).mapToObj(Json::value).collect(JsonCollectors.value());
    }

    public static JsonArray array(String ... values) {
        return Stream.of(values).map(Json::value).collect(JsonCollectors.value());
    }

    public static JsonObject object() {
        return new JsonObject();
    }

    public static JsonObject object(Map<?, ?> map) {
        return map.entrySet().stream().collect(JsonCollectors.toObject());
    }

    public static JsonValue any(@Nullable Object unknown) {
        if (unknown == null) {
            return JsonLiteral.jsonNull();
        }
        if (unknown instanceof JsonValue) {
            return (JsonValue)unknown;
        }
        if (unknown instanceof JsonReference) {
            return ((JsonReference)unknown).get();
        }
        if (unknown instanceof Number) {
            return Json.value(((Number)unknown).doubleValue());
        }
        if (unknown instanceof Boolean) {
            return Json.value((Boolean)unknown);
        }
        if (unknown instanceof String) {
            return Json.value((String)unknown);
        }
        if (unknown instanceof Enum) {
            return Json.value(((Enum)unknown).name());
        }
        if (unknown instanceof Collection) {
            return Json.array((Collection)unknown);
        }
        if (unknown instanceof Map) {
            return Json.object((Map)unknown);
        }
        if (unknown.getClass().isArray()) {
            return Json.arrayPointer(unknown);
        }
        throw new UnsupportedOperationException("Unsupported type: " + String.valueOf(unknown.getClass()));
    }

    public static JsonArray any(Object ... unknowns) {
        return Stream.of(unknowns).collect(JsonCollectors.any());
    }

    private static JsonArray arrayPointer(Object unknown) {
        JsonArray array = new JsonArray();
        int length = Array.getLength(unknown);
        for (int i = 0; i < length; ++i) {
            array.add(Json.any(Array.get(unknown, i)));
        }
        return array;
    }

    public static JsonValue parse(Path file) throws IOException {
        return JsonContext.autoParse(file);
    }

    public static JsonValue parse(String djs) {
        return JsonContext.getDefaultParser().parse(djs);
    }

    public static JsonValue parse(String format, String djs) {
        return JsonContext.getDefaultParser().parse(djs);
    }

    public static JsonValue parse(InputStream djs) throws IOException {
        return JsonContext.getDefaultParser().parse(djs);
    }

    public static void view(Path file, Consumer<JsonValue> f) throws IOException {
        Json.update(file, value -> {
            f.accept((JsonValue)value);
            return value;
        });
    }

    public static void update(Path file, UnaryOperator<JsonValue> f) throws IOException {
        ((JsonValue)f.apply(Json.parse(file))).write(file);
    }

    public static <V extends JsonValue> V copy(V value, int options) {
        return (V)value.copy(options);
    }
}

