/*
 * Decompiled with CFR 0.152.
 */
package net.frozenblock.lib.shadow.xjs.compat.serialization.parser;

import net.frozenblock.lib.shadow.xjs.compat.serialization.token.JsoncTokenizer;
import net.frozenblock.lib.shadow.xjs.data.JsonArray;
import net.frozenblock.lib.shadow.xjs.data.JsonObject;
import net.frozenblock.lib.shadow.xjs.data.JsonValue;
import net.frozenblock.lib.shadow.xjs.data.comments.CommentType;
import net.frozenblock.lib.shadow.xjs.data.serialization.parser.DjsParser;
import net.frozenblock.lib.shadow.xjs.data.serialization.token.TokenStream;
import net.frozenblock.lib.shadow.xjs.data.serialization.token.TokenType;
import net.frozenblock.lib.shadow.xjs.data.serialization.util.PositionTrackingReader;
import org.jetbrains.annotations.NotNull;

public class JsoncParser
extends DjsParser {
    public JsoncParser(PositionTrackingReader reader) {
        this(new JsoncTokenizer(reader, false).stream());
    }

    protected JsoncParser(TokenStream root) {
        super(root);
    }

    @Override
    @NotNull
    public JsonValue parse() {
        if (this.root.type() == TokenType.OPEN) {
            this.read();
        }
        return this.readClosedRoot();
    }

    @Override
    protected JsonObject readObject() {
        JsonObject object = new JsonObject();
        if (!this.open('{', '}')) {
            return this.close(object, '}');
        }
        do {
            this.readWhitespace(false);
            if (!this.isEndOfContainer('}')) continue;
            throw this.expected("key (trailing delimiter?)");
        } while (this.readNextMember(object));
        this.readWhitespace(false);
        return this.close(object, '}');
    }

    @Override
    protected JsonArray readArray() {
        JsonArray array = new JsonArray();
        if (!this.open('[', ']')) {
            return this.close(array, ']');
        }
        do {
            this.readWhitespace(false);
            if (!this.isEndOfContainer(']')) continue;
            throw this.expected("value (trailing delimiter?)");
        } while (this.readNextElement(array));
        this.readWhitespace(false);
        return this.close(array, ']');
    }

    @Override
    protected boolean readDelimiter() {
        this.readLineWhitespace();
        boolean delimiter = this.readIf(',');
        this.readLineWhitespace();
        this.readNl();
        this.setComment(CommentType.EOL);
        return delimiter;
    }
}

