/*
 * Decompiled with CFR 0.152.
 */
package net.frozenblock.lib.cape.client.impl;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientEntityEvents;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientLifecycleEvents;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayConnectionEvents;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.frozenblock.lib.cape.api.CapeUtil;
import net.frozenblock.lib.cape.client.impl.AvatarCapeInterface;
import net.frozenblock.lib.cape.impl.Cape;
import net.frozenblock.lib.cape.impl.networking.CapeCustomizePacket;
import net.frozenblock.lib.config.frozenlib_config.FrozenLibConfig;
import net.minecraft.class_12079;
import net.minecraft.class_1297;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_638;
import net.minecraft.class_8710;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Environment(value=EnvType.CLIENT)
public class ClientCapeData {
    private static final Map<UUID, Cape> CAPES_IN_WORLD = new HashMap<UUID, Cape>();

    public static Optional<class_2960> getCapeTexture(UUID uuid) {
        return Optional.ofNullable(CAPES_IN_WORLD.get(uuid)).map(Cape::texture);
    }

    public static void setCapeForUUID(UUID uuid, class_2960 capeId) {
        CapeUtil.getCape(capeId).ifPresentOrElse(cape -> ClientCapeData.setPlayerCape(uuid, Optional.of(cape)), () -> ClientCapeData.removeCapeForUUID(uuid));
    }

    public static void removeCapeForUUID(UUID uuid) {
        ClientCapeData.setPlayerCape(uuid, Optional.empty());
    }

    private static void setPlayerCape(UUID uuid, @NotNull Optional<Cape> optionalCape) {
        optionalCape.ifPresentOrElse(cape -> CAPES_IN_WORLD.put(uuid, (Cape)cape), () -> CAPES_IN_WORLD.remove(uuid));
        class_638 level = class_310.method_1551().field_1687;
        if (level == null) {
            return;
        }
        ClientCapeData.setCape((class_1297)level.method_18470(uuid), optionalCape.map(Cape::texture).orElse(null));
    }

    private static void setCape(@Nullable class_1297 entity, final @Nullable class_2960 capeTexture) {
        if (!(entity instanceof AvatarCapeInterface)) {
            return;
        }
        AvatarCapeInterface capeInterface = (AvatarCapeInterface)entity;
        if (capeTexture == null) {
            capeInterface.frozenLib$setCape(null);
            return;
        }
        capeInterface.frozenLib$setCape(new class_12079.class_12081(){

            @NotNull
            public class_2960 comp_3627() {
                return capeTexture;
            }

            @NotNull
            public class_2960 comp_3626() {
                return capeTexture;
            }
        });
    }

    public static void init() {
        ClientLifecycleEvents.CLIENT_STOPPING.register(client -> CAPES_IN_WORLD.clear());
        ClientPlayConnectionEvents.DISCONNECT.register((clientPacketListener, minecraft) -> CAPES_IN_WORLD.clear());
        ClientPlayConnectionEvents.JOIN.register((clientPacketListener, packetSender, minecraft) -> ClientPlayNetworking.send((class_8710)CapeCustomizePacket.createPacket(minecraft.method_1548().method_44717(), class_2960.method_60654((String)FrozenLibConfig.get().cape))));
        ClientEntityEvents.ENTITY_LOAD.register((entity, clientLevel) -> ClientCapeData.getCapeTexture(entity.method_5667()).ifPresent(capeTexture -> ClientCapeData.setCape(entity, capeTexture)));
    }
}

