/*
 * Decompiled with CFR 0.152.
 */
package net.frozenblock.lib.block.sound.impl;

import com.google.gson.JsonObject;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.BooleanSupplier;
import net.fabricmc.fabric.api.resource.SimpleResourceReloadListener;
import net.frozenblock.lib.FrozenLibConstants;
import net.frozenblock.lib.block.sound.api.SoundTypeCodecs;
import net.frozenblock.lib.block.sound.impl.overwrite.AbstractBlockSoundTypeOverwrite;
import net.frozenblock.lib.block.sound.impl.overwrite.BlockStateBlockSoundTypeOverwrite;
import net.frozenblock.lib.block.sound.impl.overwrite.HolderSetBlockSoundTypeOverwrite;
import net.minecraft.class_2248;
import net.minecraft.class_2498;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3298;
import net.minecraft.class_3300;
import net.minecraft.class_3518;
import net.minecraft.class_6862;
import net.minecraft.class_6880;
import net.minecraft.class_6885;
import net.minecraft.class_7876;
import net.minecraft.class_7923;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApiStatus.Internal
public class BlockSoundTypeManager
implements SimpleResourceReloadListener<SoundTypeLoader> {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"Block Sound Type Overwrite Manager");
    private static final String DIRECTORY = "block_sound_overwrites";
    public static final BlockSoundTypeManager INSTANCE = new BlockSoundTypeManager();
    private final List<AbstractBlockSoundTypeOverwrite<?>> builtInOverwrites = new ArrayList();
    private final List<AbstractBlockSoundTypeOverwrite<?>> overwrites = new ArrayList();

    public void addBuiltInOverwrite(@NotNull class_2680 blockState, class_2498 soundType, BooleanSupplier condition) {
        this.builtInOverwrites.add(new BlockStateBlockSoundTypeOverwrite(blockState, soundType, condition));
    }

    public void addBuiltInOverwrite(@NotNull class_2248 block, class_2498 soundType, BooleanSupplier condition) {
        this.builtInOverwrites.add(new HolderSetBlockSoundTypeOverwrite((class_6885<class_2248>)class_6885.method_40246((class_6880[])new class_6880[]{block.method_40142()}), soundType, condition));
    }

    public void addBuiltInOverwrite(class_2248[] blocks, class_2498 soundType, BooleanSupplier condition) {
        List<class_2248> blockList = Arrays.stream(blocks).toList();
        if (!blockList.isEmpty()) {
            this.builtInOverwrites.add(new HolderSetBlockSoundTypeOverwrite((class_6885<class_2248>)class_6885.method_40244(class_2248::method_40142, Arrays.stream(blocks).toList()), soundType, condition));
        }
    }

    public void addBuiltInOverwrite(class_6862<class_2248> tagKey, class_2498 soundType, BooleanSupplier condition) {
        this.builtInOverwrites.add(new HolderSetBlockSoundTypeOverwrite((class_6885<class_2248>)new class_6885.class_6888((class_7876)class_7923.field_41175, tagKey), soundType, condition));
    }

    public void addBuiltInOverwrite(class_2960 resourceLocation, class_2498 soundType, BooleanSupplier condition) {
        Optional optionalBlock = class_7923.field_41175.method_17966(resourceLocation);
        optionalBlock.ifPresent(block -> this.builtInOverwrites.add(new HolderSetBlockSoundTypeOverwrite((class_6885<class_2248>)class_6885.method_40246((class_6880[])new class_6880[]{block.method_40142()}), soundType, condition)));
    }

    public void addFinalizedOverwrite(AbstractBlockSoundTypeOverwrite<?> overwrite) {
        this.overwrites.add(overwrite);
    }

    public Optional<class_2498> getSoundType(@NotNull class_2680 state) {
        for (AbstractBlockSoundTypeOverwrite<?> overwrite : this.overwrites) {
            if (!overwrite.getSoundCondition().getAsBoolean() || !overwrite.matches(state)) continue;
            return Optional.of(overwrite.getSoundType());
        }
        return Optional.empty();
    }

    @NotNull
    public static class_2960 getGeneratedPath(@NotNull class_2960 blockId) {
        return class_2960.method_60655((String)blockId.method_12836(), (String)("block_sound_overwrites/" + blockId.method_12832() + ".json"));
    }

    public CompletableFuture<SoundTypeLoader> load(class_3300 manager, Executor executor) {
        return CompletableFuture.supplyAsync(() -> new SoundTypeLoader(manager), executor);
    }

    public CompletableFuture<Void> apply(@NotNull SoundTypeLoader prepared, class_3300 manager, Executor executor) {
        this.overwrites.clear();
        prepared.getOverwrites().forEach(this::addFinalizedOverwrite);
        this.builtInOverwrites.forEach(this::addFinalizedOverwrite);
        return CompletableFuture.runAsync(() -> {});
    }

    @NotNull
    public class_2960 getFabricId() {
        return FrozenLibConstants.id("block_sound_type_overwrites");
    }

    public static class SoundTypeLoader {
        private final class_3300 manager;
        private final List<AbstractBlockSoundTypeOverwrite<?>> parsedOverwrites = new ArrayList();

        public SoundTypeLoader(class_3300 manager) {
            this.manager = manager;
            this.loadSoundOverwrites();
        }

        private void loadSoundOverwrites() {
            Map resources = this.manager.method_14488(BlockSoundTypeManager.DIRECTORY, id -> id.method_12832().endsWith(".json"));
            Set entrySet = resources.entrySet();
            for (Map.Entry entry : entrySet) {
                this.addOverwrite((class_2960)entry.getKey(), (class_3298)entry.getValue());
            }
        }

        private void addOverwrite(class_2960 location, @NotNull class_3298 resource) {
            BufferedReader reader;
            try {
                reader = resource.method_43039();
            }
            catch (IOException e) {
                LOGGER.error("Unable to open BufferedReader for file: `{}`", (Object)location);
                return;
            }
            JsonObject json = class_3518.method_15255((Reader)reader);
            DataResult dataResult = SoundTypeCodecs.HOLDER_SET_BLOCK_SOUND_TYPE_OVERWRITE_CODEC.decode((DynamicOps)JsonOps.INSTANCE, (Object)json);
            dataResult.resultOrPartial(string -> LOGGER.error("Failed to parse sound override for file: '{}'", (Object)location)).ifPresent(overwrite -> this.parsedOverwrites.add((AbstractBlockSoundTypeOverwrite)overwrite.getFirst()));
        }

        public List<AbstractBlockSoundTypeOverwrite<?>> getOverwrites() {
            return this.parsedOverwrites;
        }
    }
}

