/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.voicechat.debug;

import de.maxhenkel.voicechat.debug.VoicechatUncaughtExceptionHandler;
import de.maxhenkel.voicechat.gui.GroupType;
import de.maxhenkel.voicechat.intercompatibility.ClientCompatibilityManager;
import de.maxhenkel.voicechat.intercompatibility.CommonCompatibilityManager;
import de.maxhenkel.voicechat.voice.client.AudioChannel;
import de.maxhenkel.voicechat.voice.client.ClientGroupManager;
import de.maxhenkel.voicechat.voice.client.ClientManager;
import de.maxhenkel.voicechat.voice.client.ClientPlayerStateManager;
import de.maxhenkel.voicechat.voice.client.ClientVoicechat;
import de.maxhenkel.voicechat.voice.client.KeyEvents;
import de.maxhenkel.voicechat.voice.client.speaker.ALSpeaker;
import de.maxhenkel.voicechat.voice.client.speaker.Speaker;
import de.maxhenkel.voicechat.voice.common.ClientGroup;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.class_310;
import net.minecraft.class_332;
import org.joml.Matrix3x2fStack;

public class DebugOverlay {
    private static final class_310 mc = class_310.method_1551();
    private final Map<UUID, AudioChannelInfo> audioChannelInfoMap;
    private boolean active;
    @Nullable
    private TimerThread timer;
    private List<String> rightText = new ArrayList<String>();
    public static final int MAX_AUDIO_CHANNELS = 4;
    private static final int LEFT_PADDING = 5;

    public DebugOverlay() {
        this.audioChannelInfoMap = new LinkedHashMap<UUID, AudioChannelInfo>();
        ClientCompatibilityManager.INSTANCE.onRenderHUD(this::render);
    }

    public void toggle() {
        boolean bl = this.active = !this.active;
        if (this.active) {
            this.audioChannelInfoMap.clear();
            this.timer = new TimerThread();
        } else {
            if (this.timer != null) {
                this.timer.close();
            }
            this.audioChannelInfoMap.clear();
        }
    }

    private void render(class_332 gui, float tickDelta) {
        if (!this.active) {
            return;
        }
        this.rightText.clear();
        this.rightText.add(String.format("%s %s debug overlay", CommonCompatibilityManager.INSTANCE.getModName(), CommonCompatibilityManager.INSTANCE.getModVersion()));
        this.rightText.add(String.format("Press ALT + %s to toggle", ClientCompatibilityManager.INSTANCE.getBoundKeyOf(KeyEvents.KEY_VOICE_CHAT).method_27445().getString()));
        this.rightText.add(null);
        ClientVoicechat client = ClientManager.getClient();
        if (client == null) {
            this.rightText.add("Voice chat not running");
            this.drawRight(gui, this.rightText);
            return;
        }
        this.rightText.add(String.format("UUID: %s", ClientManager.getPlayerStateManager().getOwnID()));
        this.rightText.add(null);
        this.addStateStrings(this.rightText);
        this.rightText.add(null);
        this.addAudioChannelStrings(this.rightText);
        this.drawRight(gui, this.rightText);
    }

    private void addAudioChannelStrings(List<String> strings) {
        strings.add(String.format("Audio Channels: %s", this.audioChannelInfoMap.size()));
        ArrayList<Map.Entry<UUID, AudioChannelInfo>> entries = new ArrayList<Map.Entry<UUID, AudioChannelInfo>>(this.audioChannelInfoMap.entrySet());
        for (int i = 0; i < entries.size() && i < 4; ++i) {
            Map.Entry<UUID, AudioChannelInfo> entry = entries.get(i);
            AudioChannelInfo audioChannel = entry.getValue();
            if (audioChannel.audioBufferCount < 0) {
                strings.add(String.format("ID: %s Packets: %s Reordering: %S Lost: %s Queue: STOPPED", entry.getKey().toString().substring(24), audioChannel.bufferedPackets, audioChannel.packetReorderingBuffer, audioChannel.lostPackets));
                continue;
            }
            strings.add(String.format("ID: %s Packets: %s Reordering: %S Lost: %s Queue: %s/%s", entry.getKey().toString().substring(24), audioChannel.bufferedPackets, audioChannel.packetReorderingBuffer, audioChannel.lostPackets, audioChannel.audioBufferCount, audioChannel.audioBufferSize));
        }
        if (entries.size() > 4) {
            strings.add(String.format("%s more channels", entries.size() - 4));
        }
    }

    private void addStateStrings(List<String> strings) {
        ClientGroupManager groupManager = ClientManager.getGroupManager();
        Collection<ClientGroup> groups = groupManager.getGroups();
        ClientPlayerStateManager stateManager = ClientManager.getPlayerStateManager();
        ClientGroup group = stateManager.getGroup();
        strings.add(String.format("Groups: %s", groups.size()));
        strings.add(this.clientGroupToString(group));
        strings.add(String.format("States: %s Disconnected: %s Disabled: %s Muted: %s", stateManager.getPlayerStates(true).size(), stateManager.isDisconnected(), stateManager.isDisabled(), stateManager.isMuted()));
    }

    private String clientGroupToString(ClientGroup group) {
        if (group == null) {
            return "Group: N/A";
        }
        return String.format("Group: %s Name: %s Password: %s Persistent: %s Type: %s", group.getId().toString().substring(24), group.getName(), group.hasPassword(), group.isPersistent(), GroupType.fromType(group.getType()).name());
    }

    private void updateCache() {
        ClientVoicechat client = ClientManager.getClient();
        if (client == null) {
            this.audioChannelInfoMap.clear();
            return;
        }
        Map<UUID, AudioChannel> audioChannels = client.getAudioChannels();
        this.audioChannelInfoMap.values().removeIf(audioChannelInfo -> !audioChannels.containsKey(audioChannelInfo.id));
        for (Map.Entry<UUID, AudioChannel> entry : audioChannels.entrySet()) {
            AudioChannel audioChannel = entry.getValue();
            AudioChannelInfo info = this.audioChannelInfoMap.computeIfAbsent(entry.getKey(), uuid -> new AudioChannelInfo((UUID)entry.getKey()));
            info.update(audioChannel);
        }
    }

    private void drawRight(class_332 gui, List<String> strings) {
        for (int i = 0; i < strings.size(); ++i) {
            String text = strings.get(i);
            if (text == null || text.isEmpty()) continue;
            gui.method_51448().pushMatrix();
            int width = DebugOverlay.mc.field_1772.method_1727(text);
            Matrix3x2fStack matrix3x2fStack = gui.method_51448();
            float f = mc.method_22683().method_4486() - width - 5;
            float f2 = i;
            Objects.requireNonNull(DebugOverlay.mc.field_1772);
            matrix3x2fStack.translate(f, 25.0f + f2 * (9.0f + 1.0f));
            Objects.requireNonNull(DebugOverlay.mc.field_1772);
            gui.method_25294(-1, -1, width, 9, -1873784752);
            gui.method_51433(DebugOverlay.mc.field_1772, text, 0, 0, -1, false);
            gui.method_51448().popMatrix();
        }
    }

    private class TimerThread
    extends Thread {
        private boolean stopped;

        private TimerThread() {
            this.setName("Voicechat Debug Overlay Thread");
            this.setDaemon(true);
            this.setUncaughtExceptionHandler(new VoicechatUncaughtExceptionHandler());
            this.start();
        }

        @Override
        public void run() {
            while (!this.stopped) {
                DebugOverlay.this.updateCache();
                try {
                    Thread.sleep(20L);
                }
                catch (InterruptedException interruptedException) {}
            }
        }

        public void close() {
            this.stopped = true;
            this.interrupt();
        }
    }

    private static class AudioChannelInfo {
        private final UUID id;
        private int audioBufferSize;
        private int audioBufferCount;
        private int bufferedPackets;
        private int packetReorderingBuffer;
        private long lostPackets;

        public AudioChannelInfo(UUID id) {
            this.id = id;
        }

        public AudioChannelInfo update(AudioChannel audioChannel) {
            this.audioBufferSize = 32;
            this.audioBufferCount = -1;
            this.bufferedPackets = audioChannel.getQueue().size();
            this.packetReorderingBuffer = audioChannel.getPacketBuffer().getSize();
            this.lostPackets = audioChannel.getLostPackets();
            Speaker speaker = audioChannel.getSpeaker();
            if (speaker instanceof ALSpeaker) {
                ((ALSpeaker)speaker).fetchQueuedBuffersAsync(bufferCount -> {
                    this.audioBufferCount = bufferCount;
                });
            }
            return this;
        }
    }
}

