/*
 * Decompiled with CFR 0.152.
 */
package de.cristelknight.cristellib.data;

import com.mojang.datafixers.util.Either;
import com.mojang.datafixers.util.Pair;
import de.cristelknight.cristellib.CristelLib;
import de.cristelknight.cristellib.StructureConfig;
import de.cristelknight.cristellib.autoconfig.ACInfoData;
import de.cristelknight.cristellib.builtinpacks.BuiltInDataPackLoader;
import de.cristelknight.cristellib.config.ConfigManager;
import de.cristelknight.cristellib.data.Conditions;
import de.cristelknight.cristellib.data.PathFinder;
import de.cristelknight.cristellib.data.codec.BuiltInPackData;
import de.cristelknight.cristellib.data.codec.BuiltInPackDataWrapper;
import de.cristelknight.cristellib.util.Util;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import net.minecraft.class_151;
import net.minecraft.class_2561;

public class ReadData {
    public static Set<String> readData(String modId, Map<String, ACInfoData> autoConfigInfoData, Map<String, Set<StructureConfig>> structureConfigData) {
        PathFinder.PathFinderData finder = PathFinder.getSubPathsInMod(modId, structureConfigData.keySet());
        ReadData.getAutoConfigSettings(modId, finder.autoConfig(), autoConfigInfoData);
        ReadData.getStructureConfigs(modId, finder.structureConfig(), structureConfigData);
        ReadData.getBuiltInPacks(modId, finder.dataPack());
        return finder.structureSets();
    }

    private static void getAutoConfigSettings(String modId, Set<String> subPaths, Map<String, ACInfoData> data) {
        for (String subPath : subPaths) {
            ACInfoData acInfoData = ConfigManager.readFromSubPath(modId, subPath, ACInfoData.CODEC, String.format("Couldn't read %s, crashing instead. This file is corrupted!", subPath));
            if (data.containsKey(modId)) {
                CristelLib.LOGGER.warn("Overriding Auto Config data for modID: {} from path: {}", (Object)modId, (Object)subPath);
            }
            data.put(modId, acInfoData);
        }
    }

    private static void getStructureConfigs(String modId, Set<String> subPaths, Map<String, Set<StructureConfig>> modIdAndConfigs) {
        for (String subPath : subPaths) {
            StructureConfig config = ConfigManager.readFromSubPath(modId, subPath, StructureConfig.CODEC, String.format("Couldn't read %s, crashing instead. This file is corrupted!", subPath));
            if (modId.equals("minecraft") && ReadData.checkForReplace(modIdAndConfigs, Path.of(subPath, new String[0]), config)) continue;
            modIdAndConfigs.computeIfAbsent(modId, k -> new HashSet()).add(config);
        }
    }

    private static boolean checkForReplace(Map<String, Set<StructureConfig>> modIdAndConfigs, Path path, StructureConfig config) {
        try {
            Pair<String, String> pair = Util.parseNamespaceAndPath(Util.fileName(path), '@');
            String namespace = (String)pair.getFirst();
            Set configs = modIdAndConfigs.computeIfAbsent(namespace, k -> new HashSet());
            Iterator it = configs.iterator();
            while (it.hasNext()) {
                StructureConfig old = (StructureConfig)it.next();
                if (!Util.fileName(old.getPath()).equals(pair.getSecond())) continue;
                it.remove();
                configs.add(config);
                return true;
            }
            configs.add(config);
            return true;
        }
        catch (class_151 ignored) {
            return false;
        }
    }

    private static void getBuiltInPacks(String modId, Set<String> subPaths) {
        for (String subPath : subPaths) {
            Either<BuiltInPackData, BuiltInPackDataWrapper> either = ConfigManager.readFromSubPath(modId, subPath, BuiltInPackData.PACKS_CODEC, String.format("Couldn't read %s, crashing instead. This file is corrupted!", subPath));
            either.left().ifPresent(ReadData::loadPack);
            either.right().ifPresent(wrapper -> {
                ArrayList<BuiltInPackData> packs = new ArrayList<BuiltInPackData>(wrapper.packs());
                Collections.reverse(packs);
                packs.forEach(ReadData::loadPack);
            });
        }
    }

    private static void loadPack(BuiltInPackData pack) {
        boolean bl = Conditions.readConditions(pack.conditions());
        BuiltInDataPackLoader.registerPack(pack.location(), class_2561.method_30163((String)pack.displayName()), () -> bl);
    }
}

