/*
 * Decompiled with CFR 0.152.
 */
package atonkish.reinfshulker;

import atonkish.reinfcore.api.ReinforcedCoreModInitializer;
import atonkish.reinfcore.api.ReinforcedCoreRegistry;
import atonkish.reinfcore.util.ReinforcingMaterial;
import atonkish.reinfshulker.api.ReinforcedShulkerBoxesModInitializer;
import atonkish.reinfshulker.api.ReinforcedShulkerBoxesRegistry;
import atonkish.reinfshulker.block.cauldron.ModCauldronBehavior;
import atonkish.reinfshulker.block.dispenser.ModDispenserBehavior;
import atonkish.reinfshulker.recipe.ModRecipeSerializer;
import atonkish.reinfshulker.util.ReinforcingMaterialSettings;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1767;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReinforcedShulkerBoxesMod
implements ModInitializer,
ReinforcedCoreModInitializer {
    public static final String MOD_ID = "reinfshulker";
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"reinfshulker");
    public static boolean IS_REINFCHEST_LOADED = false;

    public void onInitialize() {
        IS_REINFCHEST_LOADED = FabricLoader.getInstance().isModLoaded("reinfchest");
    }

    public void onInitializeReinforcedCore() {
        ReinforcedShulkerBoxesMod.initializeReinforcedCore();
        ReinforcedShulkerBoxesMod.initializeReinforcedShulkerBoxes();
        FabricLoader.getInstance().getEntrypoints(MOD_ID, ReinforcedShulkerBoxesModInitializer.class).forEach(ReinforcedShulkerBoxesModInitializer::onInitializeReinforcedShulkerBoxes);
        ModRecipeSerializer.init();
        ModCauldronBehavior.init();
        ModDispenserBehavior.init();
    }

    private static void initializeReinforcedCore() {
        for (ReinforcingMaterialSettings materialSettings : ReinforcingMaterialSettings.values()) {
            ReinforcingMaterial material = materialSettings.getMaterial();
            ReinforcedCoreRegistry.registerMaterialSingleBlockScreenModel((ReinforcingMaterial)material);
            ReinforcedCoreRegistry.registerMaterialShulkerBoxScreenHandler((ReinforcingMaterial)material);
        }
    }

    private static void initializeReinforcedShulkerBoxes() {
        for (ReinforcingMaterialSettings materialSettings : ReinforcingMaterialSettings.values()) {
            ReinforcingMaterial material = materialSettings.getMaterial();
            ReinforcedShulkerBoxesRegistry.registerMaterialCleanStat(MOD_ID, material);
            ReinforcedShulkerBoxesRegistry.registerMaterialOpenStat(MOD_ID, material);
            ReinforcedShulkerBoxesRegistry.registerMaterialDyeColorBlock(MOD_ID, material, null, materialSettings.getBlockSettings());
            for (class_1767 color : class_1767.values()) {
                ReinforcedShulkerBoxesRegistry.registerMaterialDyeColorBlock(MOD_ID, material, color, materialSettings.getColorBlockSettings(color));
            }
            ReinforcedShulkerBoxesRegistry.registerMaterialBlockEntityType(MOD_ID, material);
            ReinforcedShulkerBoxesRegistry.registerMaterialDyeColorItem(MOD_ID, material, null, materialSettings.getItemSettings());
            for (class_1767 color : class_1767.values()) {
                ReinforcedShulkerBoxesRegistry.registerMaterialDyeColorItem(MOD_ID, material, color, materialSettings.getItemSettings());
            }
        }
        ReinforcedShulkerBoxesRegistry.registerMaterialDyeColorItemGroupIcon(MOD_ID, ReinforcingMaterialSettings.NETHERITE.getMaterial(), null);
    }
}

