/*
 * Decompiled with CFR 0.152.
 */
package aquariusplayz.animalgarden.fennecfox.config;

import aquariusplayz.animalgarden.fennecfox.config.ModConfigProvider;
import aquariusplayz.animalgarden.fennecfox.config.SimpleConfig;
import com.mojang.datafixers.util.Pair;

public class ModConfigs {
    public static SimpleConfig CONFIG;
    private static ModConfigProvider configs;
    public static boolean isAlwaysPersistent;
    public static int checkAreaSizeForMobsOfSameTypeWhenSpawning;
    public static int maxMobOfSameTypeAroundAreaWhenSpawning;
    public static int WEIGHT;
    public static int MIN;
    public static int MAX;
    public static String BIOMES;
    public static String BIOMES_DEFAULT;
    public static int WEIGHT_DEFAULT;
    public static float soundVolume;
    public static int playSoundDistance;

    public static void registerConfigs() {
        configs = new ModConfigProvider();
        ModConfigs.createConfigs();
        CONFIG = SimpleConfig.of("animalgarden_fennecfoxconfig").provider(configs).request();
        ModConfigs.assignConfigs();
    }

    private static void createConfigs() {
        configs.addKeyValuePair(new Pair((Object)"weight", (Object)WEIGHT_DEFAULT), "int");
        configs.addKeyValuePair(new Pair((Object)"min", (Object)1), "int");
        configs.addKeyValuePair(new Pair((Object)"max", (Object)1), "int");
        configs.addKeyValuePair(new Pair((Object)"biomes", (Object)BIOMES_DEFAULT), "String");
        configs.addKeyValuePair(new Pair((Object)"is_always_persistent", (Object)isAlwaysPersistent), "boolean");
        configs.addKeyValuePair(new Pair((Object)"check_area_size_for_mobs_of_same_type_when_spawning", (Object)checkAreaSizeForMobsOfSameTypeWhenSpawning), "int");
        configs.addKeyValuePair(new Pair((Object)"max_mob_number_of_same_type_around_area_when_spawning", (Object)maxMobOfSameTypeAroundAreaWhenSpawning), "int");
        configs.addKeyValuePair(new Pair((Object)"sound_volume", (Object)Float.valueOf(soundVolume)), "float");
        configs.addKeyValuePair(new Pair((Object)"play_sound_distance", (Object)playSoundDistance), "int");
    }

    private static void assignConfigs() {
        WEIGHT = CONFIG.getOrDefault("weight", WEIGHT_DEFAULT);
        MIN = CONFIG.getOrDefault("min", 1);
        MAX = CONFIG.getOrDefault("max", 1);
        BIOMES = CONFIG.getOrDefault("biomes", BIOMES_DEFAULT);
        isAlwaysPersistent = CONFIG.getOrDefault("is_always_persistent", true);
        checkAreaSizeForMobsOfSameTypeWhenSpawning = CONFIG.getOrDefault("check_area_size_for_mobs_of_same_type_when_spawning", 32);
        maxMobOfSameTypeAroundAreaWhenSpawning = CONFIG.getOrDefault("max_mob_number_of_same_type_around_area_when_spawning", 1);
        soundVolume = CONFIG.getOrDefault("sound_volume", 0.2f);
        playSoundDistance = CONFIG.getOrDefault("play_sound_distance", 30);
        System.out.println("All " + configs.getConfigsList().size() + " have been set properly");
    }

    static {
        isAlwaysPersistent = true;
        checkAreaSizeForMobsOfSameTypeWhenSpawning = 32;
        maxMobOfSameTypeAroundAreaWhenSpawning = 1;
        BIOMES = "desert";
        BIOMES_DEFAULT = "desert";
        WEIGHT_DEFAULT = 5;
        soundVolume = 0.2f;
        playSoundDistance = 30;
    }
}

