/*
 * Decompiled with CFR 0.152.
 */
package com.tom.trading.screen;

import com.tom.trading.Content;
import com.tom.trading.menu.VendingMachineConfigMenu;
import com.tom.trading.menu.slot.PhantomSlot;
import com.tom.trading.screen.AbstractFilteredScreen;
import com.tom.trading.screen.widget.IOMode;
import com.tom.trading.screen.widget.IOSideModeButton;
import com.tom.trading.screen.widget.ToggleButton;
import com.tom.trading.util.BlockFaceDirection;
import com.tom.trading.util.PopupMenuManager;
import java.util.EnumMap;
import java.util.List;
import net.minecraft.class_10725;
import net.minecraft.class_10799;
import net.minecraft.class_11905;
import net.minecraft.class_11908;
import net.minecraft.class_11909;
import net.minecraft.class_124;
import net.minecraft.class_1661;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import net.minecraft.class_342;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_5244;
import net.minecraft.class_7919;
import net.minecraft.class_9326;

public class VendingMachineConfigScreen
extends AbstractFilteredScreen<VendingMachineConfigMenu> {
    private static final class_2960 gui = class_2960.method_43902((String)"toms_trading_network", (String)"textures/gui/vending_machine_config.png");
    private static final class_2960 tagBg = class_2960.method_43902((String)"toms_trading_network", (String)"icons/tag_filter_bg");
    private class_342 nameBox;
    private class_2561 title;
    private EnumMap<BlockFaceDirection, IOSideModeButton> sideCfgButtons = new EnumMap(BlockFaceDirection.class);
    private PopupMenuManager popup = new PopupMenuManager((class_437)this);
    private ToggleButton creativeBtn;

    public VendingMachineConfigScreen(VendingMachineConfigMenu pMenu, class_1661 pPlayerInventory, class_2561 pTitle) {
        super(pMenu, pPlayerInventory, pTitle);
        this.title = pTitle;
        pMenu.updateGui = this::updateGui;
    }

    protected void method_2389(class_332 gr, float pPartialTick, int pMouseX, int pMouseY) {
        gr.method_25290(class_10799.field_56883, gui, this.field_2776, this.field_2800, 0.0f, 0.0f, this.field_2792, this.field_2779, 256, 256);
        for (int i = 0; i < 8; ++i) {
            class_1735 s = ((VendingMachineConfigMenu)this.field_2797).method_7611(i);
            if (s.method_7677().method_7960() || (((VendingMachineConfigMenu)this.field_2797).matchNBT & 1 << i) != 0 && s.method_7677().method_7909() != Content.TAG_FILTER.get()) continue;
            gr.method_52706(class_10799.field_56883, tagBg, this.field_2776 + s.field_7873 - 1, this.field_2800 + s.field_7872 - 1, 18, 18);
        }
        gr.method_52709(class_10799.field_56883, this.field_22787.method_72703().method_73025(class_10725.field_56382).method_4608(class_2960.method_43902((String)"toms_trading_network", (String)"block/vending_machine_front")), this.field_2776 + 134, this.field_2800 + 46, 16, 16);
    }

    protected void method_25426() {
        this.field_2792 = 176;
        this.field_2779 = 211;
        this.field_25270 = this.field_2779 - 92;
        this.sideCfgButtons.clear();
        super.method_25426();
        this.nameBox = new class_342(this.field_22793, this.field_2776 + 7, this.field_2800 + 7, 110, 16, (class_2561)class_2561.method_43471((String)"narrator.toms_trading_network.vending_machine_name"));
        this.method_37063((class_364)this.nameBox);
        this.nameBox.method_1852(this.title.getString());
        this.nameBox.method_1863(this::onNameChanged);
        for (BlockFaceDirection d : BlockFaceDirection.values()) {
            if (d == BlockFaceDirection.FRONT) continue;
            IOSideModeButton btn = new IOSideModeButton(this.field_2776 + 118 + d.getX() * 16, this.field_2800 + 30 + d.getY() * 16, d, ((VendingMachineConfigMenu)this.field_2797)::setSides);
            this.sideCfgButtons.put(d, btn);
            this.method_37063((class_364)btn);
        }
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43471((String)"button.toms_trading_network.vending_machine.open_trading"), b -> this.sendButtonClick(64)).method_46434(this.field_2776 + 120, this.field_2800 + 7, 50, 20).method_46431());
        this.creativeBtn = (ToggleButton)this.method_37063((class_364)ToggleButton.builder(this.field_2776 + this.field_2792 - 18, this.field_2800 - 18).name((class_2561)class_2561.method_43471((String)"narrator.toms_trading_network.vending_machine.creative_mode")).iconOff(class_2960.method_43902((String)"toms_trading_network", (String)"icons/creative_off")).iconOn(class_2960.method_43902((String)"toms_trading_network", (String)"icons/creative_on")).build(s -> this.sendButtonClick(0x20 | (s ? 1 : 0))));
        this.creativeBtn.setTooltip(class_7919.method_47407((class_2561)class_2561.method_43471((String)"tooltip.toms_trading_network.creative_mode.off")), class_7919.method_47407((class_2561)class_2561.method_43471((String)"tooltip.toms_trading_network.creative_mode.on")));
        if (this.field_22787.field_1724.method_31549().field_7477) {
            this.method_37063((class_364)this.creativeBtn);
        }
        this.updateGui();
    }

    private void onNameChanged(String name) {
        ((VendingMachineConfigMenu)this.field_2797).setName(name);
        this.title = class_2561.method_43470((String)name);
    }

    private void sendMatchNBT(int slot, boolean config) {
        this.sendButtonClick(0x60 | (config ? 16 : 0) | slot & 0xF);
    }

    private void sendButtonClick(int pPageData) {
        this.field_22787.field_1761.method_2900(((VendingMachineConfigMenu)this.field_2797).field_7763, pPageData);
    }

    public void method_25394(class_332 gr, int pMouseX, int pMouseY, float pPartialTick) {
        super.method_25394(gr, pMouseX, pMouseY, pPartialTick);
        if (this.popup.render(gr, this.field_22793, pMouseX, pMouseY)) {
            this.method_2380(gr, pMouseX, pMouseY);
        }
    }

    protected void method_2388(class_332 gr, int pMouseX, int pMouseY) {
        gr.method_51439(this.field_22793, this.field_29347, this.field_25269, this.field_25270, -12566464, false);
        gr.method_51439(this.field_22793, (class_2561)class_2561.method_43471((String)"label.toms_trading_network.vending_machine.cost"), this.field_25269, 26, -12566464, false);
        gr.method_51439(this.field_22793, (class_2561)class_2561.method_43471((String)"label.toms_trading_network.vending_machine.result"), 76, 26, -12566464, false);
        gr.method_51439(this.field_22793, (class_2561)class_2561.method_43471((String)"label.toms_trading_network.vending_machine.input"), this.field_25269, 72, -12566464, false);
        gr.method_51439(this.field_22793, (class_2561)class_2561.method_43471((String)"label.toms_trading_network.vending_machine.output"), 98, 72, -12566464, false);
    }

    public boolean method_25402(class_11909 mouseButtonEvent, boolean bl) {
        if (this.popup.mouseClick(mouseButtonEvent)) {
            return true;
        }
        class_1735 clicked = this.getSlotUnderMouse();
        if (mouseButtonEvent.method_74245() == 1 && clicked instanceof PhantomSlot && !clicked.method_7677().method_7960()) {
            int popupSlot = clicked.method_34266();
            boolean tagFilter = clicked.method_7677().method_7909() == Content.TAG_FILTER.get();
            List tags = clicked.method_7677().method_40133().toList();
            this.nameBox.method_25365(false);
            this.popup.open(mouseButtonEvent.comp_4798(), mouseButtonEvent.comp_4799(), new PopupMenuManager.TextFieldElement(() -> class_2561.method_43471((String)"tooltip.toms_trading_network.item_count"), s -> {
                try {
                    int c = Integer.parseInt(s);
                    ((VendingMachineConfigMenu)this.field_2797).setConfigCount(clicked, c);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }, this.field_22793, Integer.toString(clicked.method_7677().method_7947())), new PopupMenuManager.ButtonElement(() -> tagFilter ? class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43469((String)"tooltip.toms_trading_network.match_nbt", (Object[])new Object[]{class_5244.field_24337}).method_27692(class_124.field_1063)) : class_2561.method_43469((String)"tooltip.toms_trading_network.match_nbt", (Object[])new Object[]{(((VendingMachineConfigMenu)this.field_2797).matchNBT & 1 << popupSlot) != 0 ? class_5244.field_24336 : class_5244.field_24337}), () -> {
                ((VendingMachineConfigMenu)this.field_2797).matchNBT ^= 1 << popupSlot;
                this.sendMatchNBT(popupSlot, (((VendingMachineConfigMenu)this.field_2797).matchNBT & 1 << popupSlot) != 0);
            }), new PopupMenuManager.ButtonElement(() -> tagFilter || tags.isEmpty() ? class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43471((String)"tooltip.toms_trading_network.to_tag_filter").method_27692(class_124.field_1063)) : class_2561.method_43471((String)"tooltip.toms_trading_network.to_tag_filter"), () -> {
                if (!tags.isEmpty()) {
                    this.popup.replace((PopupMenuManager.PopupElement[])tags.stream().map(s -> new PopupMenuManager.ButtonElement(() -> class_2561.method_43470((String)s.comp_327().toString()), () -> {
                        class_1799 st = new class_1799((class_1935)Content.TAG_FILTER.get(), clicked.method_7677().method_7947());
                        st.method_57366(class_9326.method_57841().method_57854(Content.TAG_COMPONENT.get(), s).method_57852());
                        ((VendingMachineConfigMenu)this.field_2797).setPhantom(clicked, st);
                        this.popup.close();
                    })).toArray(PopupMenuManager.PopupElement[]::new));
                }
            }));
            return true;
        }
        return super.method_25402(mouseButtonEvent, bl);
    }

    public boolean method_25404(class_11908 keyEvent) {
        if (this.popup.keyPressed(keyEvent)) {
            return true;
        }
        if (keyEvent.comp_4795() == 256) {
            if (this.nameBox.method_25370()) {
                this.nameBox.method_25365(false);
            } else {
                this.field_22787.field_1724.method_7346();
            }
            return true;
        }
        if (keyEvent.comp_4795() == 258) {
            return super.method_25404(keyEvent);
        }
        return !this.nameBox.method_25404(keyEvent) && !this.nameBox.method_20315() ? super.method_25404(keyEvent) : true;
    }

    public boolean method_25400(class_11905 characterEvent) {
        if (this.popup.charTyped(characterEvent)) {
            return true;
        }
        return super.method_25400(characterEvent);
    }

    private void updateGui() {
        for (BlockFaceDirection d : BlockFaceDirection.values()) {
            if (d == BlockFaceDirection.FRONT) continue;
            IOSideModeButton b = this.sideCfgButtons.get((Object)d);
            b.setState(this.getFacingState(d));
            b.setAutoMode(this.isAuto(d));
        }
        this.creativeBtn.setState(((VendingMachineConfigMenu)this.field_2797).creativeMode != 0);
    }

    private IOMode getFacingState(BlockFaceDirection d) {
        boolean output;
        boolean input = (((VendingMachineConfigMenu)this.field_2797).inputCfg & 1 << d.ordinal()) != 0;
        boolean bl = output = (((VendingMachineConfigMenu)this.field_2797).outputCfg & 1 << d.ordinal()) != 0;
        if (input && output) {
            return IOMode.IO;
        }
        if (input) {
            return IOMode.INPUT;
        }
        if (output) {
            return IOMode.OUTPUT;
        }
        return IOMode.OFF;
    }

    private boolean isAuto(BlockFaceDirection d) {
        return (((VendingMachineConfigMenu)this.field_2797).autoCfg & 1 << d.ordinal()) != 0;
    }
}

