/*
 * Decompiled with CFR 0.152.
 */
package eu.ha3.presencefootsteps.sound.acoustics;

import com.google.common.base.Preconditions;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import eu.ha3.presencefootsteps.sound.Options;
import eu.ha3.presencefootsteps.sound.State;
import eu.ha3.presencefootsteps.sound.acoustics.Acoustic;
import eu.ha3.presencefootsteps.sound.player.SoundPlayer;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Iterator;
import java.util.List;
import net.minecraft.class_1309;

record WeightedAcoustic(List<Entry> entries) implements Acoustic
{
    public static final MapCodec<WeightedAcoustic> CODEC = RecordCodecBuilder.mapCodec(i -> i.group((App)Entry.CODEC.listOf().fieldOf("entries").forGetter(WeightedAcoustic::entries)).apply((Applicative)i, WeightedAcoustic::new));
    @Deprecated
    static final Acoustic.Serializer FACTORY = Acoustic.Serializer.ofJsObject((json, context) -> {
        ObjectArrayList entries = new ObjectArrayList();
        Iterator iter = json.getAsJsonArray(json.has("array") ? "array" : "entries").iterator();
        while (iter.hasNext()) {
            int weight = ((JsonElement)iter.next()).getAsInt();
            if (!iter.hasNext()) {
                throw new JsonParseException("Probability has odd number of children!");
            }
            entries.add(new Entry(weight, Acoustic.read(context, (JsonElement)iter.next())));
        }
        return new WeightedAcoustic((List<Entry>)entries);
    });

    WeightedAcoustic {
        float total = 0.0f;
        for (Entry entry : entries) {
            Preconditions.checkArgument((entry.weight >= 0 ? 1 : 0) != 0, (Object)"A probability weight can't be negative");
            total += (float)entry.weight;
        }
        if (total < 0.0f) {
            Preconditions.checkArgument((total >= 0.0f ? 1 : 0) != 0, (Object)"A probability weight can't be negative");
        }
        for (Entry entry : entries) {
            entry.threshold = (float)entry.weight / total;
        }
    }

    @Override
    public String type() {
        return Acoustic.PROBABILITY;
    }

    @Override
    public void playSound(SoundPlayer player, class_1309 location, State event, Options inputOptions) {
        float rand = player.getRNG().nextFloat();
        int marker = -1;
        while (++marker < this.entries.size()) {
            if (!(this.entries.get((int)marker).threshold >= rand)) continue;
            this.entries.get((int)marker).acoustic.playSound(player, location, event, inputOptions);
            return;
        }
    }

    private static class Entry {
        public static final Codec<Entry> CODEC = RecordCodecBuilder.create(i -> i.group((App)Codec.INT.optionalFieldOf("weight", (Object)1).validate(weight -> weight >= 0 ? DataResult.success((Object)weight) : DataResult.error(() -> "A probability weight cannot be negative", (Object)weight)).forGetter(o -> o.weight), (App)Acoustic.CODEC.fieldOf("acoustic").forGetter(o -> o.acoustic)).apply((Applicative)i, Entry::new));
        private final Acoustic acoustic;
        private final int weight;
        private float threshold;

        Entry(int weight, Acoustic acoustic) {
            this.weight = weight;
            this.acoustic = acoustic;
        }
    }
}

