/*
 * Decompiled with CFR 0.152.
 */
package eu.ha3.presencefootsteps.sound.acoustics;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonParser;
import eu.ha3.presencefootsteps.PresenceFootsteps;
import eu.ha3.presencefootsteps.sound.acoustics.Acoustic;
import eu.ha3.presencefootsteps.util.Range;
import java.io.Reader;
import java.util.function.BiConsumer;
import net.minecraft.class_2960;
import org.jetbrains.annotations.Nullable;

public record AcousticsFile(Range defaultVolume, Range defaultPitch, String soundRoot) {
    public static final class_2960 FILE_LOCATION = PresenceFootsteps.id("config/acoustics.json");
    private static final int ENGINE_VERSION = 2;

    @Deprecated
    @Nullable
    public static AcousticsFile read(Reader reader, BiConsumer<String, Acoustic> consumer, boolean ignoreVersion) {
        try {
            JsonObject json = JsonParser.parseReader((Reader)reader).getAsJsonObject();
            AcousticsFile context = AcousticsFile.read(json, ignoreVersion);
            json.getAsJsonObject("contents").entrySet().forEach(element -> consumer.accept((String)element.getKey(), Acoustic.read(context, (JsonElement)element.getValue(), "events")));
            return context;
        }
        catch (JsonParseException e) {
            PresenceFootsteps.logger.error("Error whilst loading acoustics", (Throwable)e);
            return null;
        }
    }

    @Deprecated
    private static AcousticsFile read(JsonObject json, boolean ignoreVersion) {
        AcousticsFile.expect("library".equals(json.get("type").getAsString()), "Invalid type: Expected \"library\" got \"" + json.get("type").getAsString() + "\"");
        AcousticsFile.expect(ignoreVersion || json.get("engineversion").getAsInt() == 2, "Unrecognised Engine version: 2 expected, got " + json.get("engineversion").getAsInt());
        AcousticsFile.expect(json.has("contents"), "Empty contents");
        String soundRoot = "";
        if (json.has("soundroot")) {
            soundRoot = json.get("soundroot").getAsString();
        }
        if (json.has("defaults")) {
            JsonObject defaults = json.getAsJsonObject("defaults");
            return new AcousticsFile(Range.DEFAULT.read("volume", defaults), Range.DEFAULT.read("pitch", defaults), soundRoot);
        }
        return new AcousticsFile(Range.DEFAULT, Range.DEFAULT, soundRoot);
    }

    @Deprecated
    private static void expect(boolean condition, String message) {
        if (!condition) {
            throw new JsonParseException(message);
        }
    }

    @Deprecated
    public String getSoundName(String soundName) {
        if (soundName.charAt(0) != '@') {
            return this.soundRoot + soundName;
        }
        return soundName.replace("@", "");
    }
}

