/*
 * Decompiled with CFR 0.152.
 */
package eu.ha3.presencefootsteps.sound.acoustics;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import eu.ha3.presencefootsteps.sound.Options;
import eu.ha3.presencefootsteps.sound.State;
import eu.ha3.presencefootsteps.sound.acoustics.AcousticsFile;
import eu.ha3.presencefootsteps.sound.acoustics.ChanceAcoustic;
import eu.ha3.presencefootsteps.sound.acoustics.DelayedAcoustic;
import eu.ha3.presencefootsteps.sound.acoustics.EventSelectorAcoustics;
import eu.ha3.presencefootsteps.sound.acoustics.SimultaneousAcoustic;
import eu.ha3.presencefootsteps.sound.acoustics.VaryingAcoustic;
import eu.ha3.presencefootsteps.sound.acoustics.WeightedAcoustic;
import eu.ha3.presencefootsteps.sound.player.SoundPlayer;
import it.unimi.dsi.fastutil.objects.Object2ObjectMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectMaps;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import net.minecraft.class_1309;

public interface Acoustic {
    public static final Map<String, MapCodec<? extends Acoustic>> TYPES = new Object2ObjectOpenHashMap();
    public static final MapCodec<Acoustic> MAP_CODEC = Codec.STRING.dispatchMap(Acoustic::type, TYPES::get);
    public static final Codec<Acoustic> CODEC = Codec.xor((Codec)Codec.lazyInitialized(() -> SimultaneousAcoustic.CODEC.xmap(i -> i, i -> (SimultaneousAcoustic)i)), (Codec)MAP_CODEC.codec()).xmap(either -> (Acoustic)Either.unwrap((Either)either), acoustic -> acoustic.type() == "simultaneous" ? Either.left((Object)acoustic) : Either.right((Object)acoustic));
    public static final String BASIC = Acoustic.register("basic", VaryingAcoustic.CODEC);
    public static final String EVENTS = Acoustic.register("events", EventSelectorAcoustics.CODEC);
    public static final String SIMULTANEOUS = Acoustic.register("simultaneous", SimultaneousAcoustic.MAP_CODEC);
    public static final String DELAYED = Acoustic.register("delayed", DelayedAcoustic.CODEC);
    public static final String PROBABILITY = Acoustic.register("probability", WeightedAcoustic.CODEC);
    public static final String CHANCE = Acoustic.register("chance", ChanceAcoustic.CODEC);
    @Deprecated
    public static final Map<String, Serializer> FACTORIES = Object2ObjectMaps.unmodifiable((Object2ObjectMap)new Object2ObjectOpenHashMap((Object[])new String[]{"basic", "events", "simultaneous", "delayed", "probability", "chance"}, (Object[])new Serializer[]{VaryingAcoustic.FACTORY, EventSelectorAcoustics.FACTORY, SimultaneousAcoustic.FACTORY, DelayedAcoustic.FACTORY, WeightedAcoustic.FACTORY, ChanceAcoustic.FACTORY}));

    public static <A extends Acoustic> String register(String type, MapCodec<A> codec) {
        TYPES.put(type, codec);
        return type;
    }

    @Deprecated
    public static Acoustic read(AcousticsFile context, JsonElement unsolved) throws JsonParseException {
        return Acoustic.read(context, unsolved, "basic");
    }

    @Deprecated
    public static Acoustic read(AcousticsFile context, JsonElement json, String defaultUnassigned) throws JsonParseException {
        String type = Acoustic.getType(json, defaultUnassigned);
        return Acoustic.checked(Acoustic.checked(FACTORIES.get(type), () -> "Invalid type for acoustic `" + type + "`").create(json, context), () -> "Unresolved Json element: \r\n" + json.toString());
    }

    @Deprecated
    private static String getType(JsonElement unsolved, String defaultUnassigned) {
        if (unsolved.isJsonObject()) {
            JsonObject json = unsolved.getAsJsonObject();
            return json.has("type") ? json.get("type").getAsString() : defaultUnassigned;
        }
        if (unsolved.isJsonArray()) {
            return "simultaneous";
        }
        if (unsolved.isJsonPrimitive() && unsolved.getAsJsonPrimitive().isString()) {
            return "basic";
        }
        return "";
    }

    @Deprecated
    private static <T> T checked(T t, Supplier<String> message) throws JsonParseException {
        if (t == null) {
            throw new JsonParseException(message.get());
        }
        return t;
    }

    public void playSound(SoundPlayer var1, class_1309 var2, State var3, Options var4);

    public String type();

    @Deprecated
    public static interface Serializer {
        public Acoustic create(JsonElement var1, AcousticsFile var2);

        public static Serializer ofJsObject(BiFunction<JsonObject, AcousticsFile, Acoustic> factory) {
            return (json, context) -> (Acoustic)factory.apply(json.getAsJsonObject(), context);
        }
    }
}

