/*
 * Decompiled with CFR 0.152.
 */
package de.bluecolored.bluemap.core.util.math;

import com.flowpowered.math.TrigMath;

public class MatrixM3f {
    public float m00 = 1.0f;
    public float m01;
    public float m02;
    public float m10;
    public float m11 = 1.0f;
    public float m12;
    public float m20;
    public float m21;
    public float m22 = 1.0f;

    public MatrixM3f set(float m00, float m01, float m02, float m10, float m11, float m12, float m20, float m21, float m22) {
        this.m00 = m00;
        this.m01 = m01;
        this.m02 = m02;
        this.m10 = m10;
        this.m11 = m11;
        this.m12 = m12;
        this.m20 = m20;
        this.m21 = m21;
        this.m22 = m22;
        return this;
    }

    public MatrixM3f invert() {
        float det = this.determinant();
        return this.set((this.m11 * this.m22 - this.m21 * this.m12) / det, -(this.m01 * this.m22 - this.m21 * this.m02) / det, (this.m01 * this.m12 - this.m02 * this.m11) / det, -(this.m10 * this.m22 - this.m20 * this.m12) / det, (this.m00 * this.m22 - this.m20 * this.m02) / det, -(this.m00 * this.m12 - this.m10 * this.m02) / det, (this.m10 * this.m21 - this.m20 * this.m11) / det, -(this.m00 * this.m21 - this.m20 * this.m01) / det, (this.m00 * this.m11 - this.m01 * this.m10) / det);
    }

    public MatrixM3f identity() {
        return this.set(1.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 1.0f);
    }

    public MatrixM3f scale(float x, float y, float z) {
        return this.multiplyTo(x, 0.0f, 0.0f, 0.0f, y, 0.0f, 0.0f, 0.0f, z);
    }

    public MatrixM3f translate(float x, float y) {
        return this.multiplyTo(1.0f, 0.0f, x, 0.0f, 1.0f, y, 0.0f, 0.0f, 1.0f);
    }

    public MatrixM3f rotate(float angle, float axisX, float axisY, float axisZ) {
        double halfAngle = Math.toRadians(angle) * 0.5;
        double q = (double)TrigMath.sin((double)halfAngle) / Math.sqrt(axisX * axisX + axisY * axisY + axisZ * axisZ);
        double qx = (double)axisX * q;
        double qy = (double)axisY * q;
        double qz = (double)axisZ * q;
        double qw = TrigMath.cos((double)halfAngle);
        double qLength = Math.sqrt(qx * qx + qy * qy + qz * qz + qw * qw);
        return this.rotateByQuaternion((float)(qx /= qLength), (float)(qy /= qLength), (float)(qz /= qLength), (float)(qw /= qLength));
    }

    public MatrixM3f rotate(float pitch, float yaw, float roll) {
        double halfYaw = Math.toRadians(yaw) * 0.5;
        double qy1 = TrigMath.sin((double)halfYaw);
        double qw1 = TrigMath.cos((double)halfYaw);
        double halfPitch = Math.toRadians(pitch) * 0.5;
        double qx2 = TrigMath.sin((double)halfPitch);
        double qw2 = TrigMath.cos((double)halfPitch);
        double halfRoll = Math.toRadians(roll) * 0.5;
        double qz3 = TrigMath.sin((double)halfRoll);
        double qw3 = TrigMath.cos((double)halfRoll);
        double qxA = qw1 * qx2;
        double qyA = qy1 * qw2;
        double qzA = -qy1 * qx2;
        double qwA = qw1 * qw2;
        return this.rotateByQuaternion((float)(qxA * qw3 + qyA * qz3), (float)(qyA * qw3 - qxA * qz3), (float)(qwA * qz3 + qzA * qw3), (float)(qwA * qw3 - qzA * qz3));
    }

    public MatrixM3f rotateByQuaternion(float qx, float qy, float qz, float qw) {
        return this.multiplyTo(1.0f - 2.0f * qy * qy - 2.0f * qz * qz, 2.0f * qx * qy - 2.0f * qw * qz, 2.0f * qx * qz + 2.0f * qw * qy, 2.0f * qx * qy + 2.0f * qw * qz, 1.0f - 2.0f * qx * qx - 2.0f * qz * qz, 2.0f * qy * qz - 2.0f * qw * qx, 2.0f * qx * qz - 2.0f * qw * qy, 2.0f * qy * qz + 2.0f * qx * qw, 1.0f - 2.0f * qx * qx - 2.0f * qy * qy);
    }

    public MatrixM3f multiply(float m00, float m01, float m02, float m10, float m11, float m12, float m20, float m21, float m22) {
        return this.set(this.m00 * m00 + this.m01 * m10 + this.m02 * m20, this.m00 * m01 + this.m01 * m11 + this.m02 * m21, this.m00 * m02 + this.m01 * m12 + this.m02 * m22, this.m10 * m00 + this.m11 * m10 + this.m12 * m20, this.m10 * m01 + this.m11 * m11 + this.m12 * m21, this.m10 * m02 + this.m11 * m12 + this.m12 * m22, this.m20 * m00 + this.m21 * m10 + this.m22 * m20, this.m20 * m01 + this.m21 * m11 + this.m22 * m21, this.m20 * m02 + this.m21 * m12 + this.m22 * m22);
    }

    public MatrixM3f multiplyTo(float m00, float m01, float m02, float m10, float m11, float m12, float m20, float m21, float m22) {
        return this.set(m00 * this.m00 + m01 * this.m10 + m02 * this.m20, m00 * this.m01 + m01 * this.m11 + m02 * this.m21, m00 * this.m02 + m01 * this.m12 + m02 * this.m22, m10 * this.m00 + m11 * this.m10 + m12 * this.m20, m10 * this.m01 + m11 * this.m11 + m12 * this.m21, m10 * this.m02 + m11 * this.m12 + m12 * this.m22, m20 * this.m00 + m21 * this.m10 + m22 * this.m20, m20 * this.m01 + m21 * this.m11 + m22 * this.m21, m20 * this.m02 + m21 * this.m12 + m22 * this.m22);
    }

    public float determinant() {
        return this.m00 * (this.m11 * this.m22 - this.m12 * this.m21) - this.m01 * (this.m10 * this.m22 - this.m12 * this.m20) + this.m02 * (this.m10 * this.m21 - this.m11 * this.m20);
    }
}

