/*
 * Decompiled with CFR 0.152.
 */
package de.bluecolored.bluemap.core.util;

import java.util.Objects;
import java.util.function.Supplier;

public class Lazy<T> {
    private Supplier<T> loader;
    private volatile T value;

    public Lazy(Supplier<T> loader) {
        Objects.requireNonNull(loader);
        this.loader = loader;
        this.value = null;
    }

    public Lazy(T value) {
        Objects.requireNonNull(value);
        this.loader = null;
        this.value = value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T getValue() {
        if (this.value == null) {
            Lazy lazy = this;
            synchronized (lazy) {
                if (this.value == null) {
                    this.value = this.loader.get();
                    this.loader = null;
                }
            }
        }
        return this.value;
    }

    public boolean isLoaded() {
        return this.value != null;
    }
}

