/*
 * Decompiled with CFR 0.152.
 */
package de.bluecolored.bluemap.core.resources.pack.resourcepack.model;

import com.flowpowered.math.vector.Vector4f;
import de.bluecolored.bluemap.core.resources.pack.ResourcePool;
import de.bluecolored.bluemap.core.resources.pack.resourcepack.ResourcePack;
import de.bluecolored.bluemap.core.resources.pack.resourcepack.model.TextureVariable;
import de.bluecolored.bluemap.core.resources.pack.resourcepack.texture.Texture;
import de.bluecolored.bluemap.core.util.Direction;
import java.util.function.Function;

public class Face {
    private static final TextureVariable DEFAULT_TEXTURE = new TextureVariable(ResourcePack.MISSING_TEXTURE);
    private Vector4f uv;
    private TextureVariable texture = DEFAULT_TEXTURE;
    private Direction cullface;
    private int rotation = 0;
    private int tintindex = -1;

    public Face(TextureVariable texture) {
        this.texture = texture;
    }

    public Face(Vector4f uv, TextureVariable texture) {
        this.uv = uv;
        this.texture = texture;
    }

    public Face(Vector4f uv, TextureVariable texture, Direction cullface) {
        this.uv = uv;
        this.texture = texture;
        this.cullface = cullface;
    }

    private Face(Face copyFrom) {
        this.uv = copyFrom.uv;
        this.texture = copyFrom.texture.copy();
        this.cullface = copyFrom.cullface;
        this.rotation = copyFrom.rotation;
        this.tintindex = copyFrom.tintindex;
    }

    void init(Direction direction, Function<Direction, Vector4f> defaultUvCalculator) {
        if (this.uv == null) {
            this.uv = defaultUvCalculator.apply(direction);
        }
    }

    public Face copy() {
        return new Face(this);
    }

    public void optimize(ResourcePool<Texture> texturePool) {
        this.texture.optimize(texturePool);
    }

    private Face() {
    }

    public Face(Vector4f uv, TextureVariable texture, Direction cullface, int rotation, int tintindex) {
        this.uv = uv;
        this.texture = texture;
        this.cullface = cullface;
        this.rotation = rotation;
        this.tintindex = tintindex;
    }

    public Vector4f getUv() {
        return this.uv;
    }

    public TextureVariable getTexture() {
        return this.texture;
    }

    public Direction getCullface() {
        return this.cullface;
    }

    public int getRotation() {
        return this.rotation;
    }

    public int getTintindex() {
        return this.tintindex;
    }
}

