/*
 * Decompiled with CFR 0.152.
 */
package de.bluecolored.bluemap.core.resources.pack.resourcepack.atlas;

import com.google.gson.annotations.SerializedName;
import de.bluecolored.bluemap.core.logger.Logger;
import de.bluecolored.bluemap.core.resources.ResourcePath;
import de.bluecolored.bluemap.core.resources.pack.ResourcePool;
import de.bluecolored.bluemap.core.resources.pack.resourcepack.atlas.Source;
import de.bluecolored.bluemap.core.resources.pack.resourcepack.texture.Texture;
import de.bluecolored.bluemap.core.util.BufferedImageUtil;
import de.bluecolored.bluemap.core.util.Key;
import de.bluecolored.bluemap.core.util.math.Color;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.IntUnaryOperator;
import java.util.function.Predicate;

public class PalettedPermutationsSource
extends Source {
    private Set<ResourcePath<Texture>> textures;
    private String separator = "_";
    @SerializedName(value="palette_key")
    private ResourcePath<Texture> paletteKey;
    private Map<String, ResourcePath<Texture>> permutations;

    @Override
    public void load(Path root, ResourcePool<Texture> texturePool, Predicate<Key> textureFilter) throws IOException {
        if (this.textures == null) {
            return;
        }
        if (this.paletteKey == null) {
            return;
        }
        if (this.permutations == null || this.permutations.isEmpty()) {
            return;
        }
        for (ResourcePath<Texture> resource : this.textures) {
            texturePool.load(resource, rp -> {
                Path file = this.getFile(root, resource);
                return this.loadTexture(resource, file);
            });
        }
        texturePool.load(this.paletteKey, rp -> {
            Path file = this.getFile(root, this.paletteKey);
            return this.loadTexture(this.paletteKey, file);
        });
        for (ResourcePath<Texture> resource : this.permutations.values()) {
            texturePool.load(resource, rp -> {
                Path file = this.getFile(root, resource);
                return this.loadTexture(resource, file);
            });
        }
    }

    @Override
    public void bake(ResourcePool<Texture> texturePool, Predicate<Key> textureFilter) throws IOException {
        if (this.textures == null) {
            return;
        }
        if (this.paletteKey == null) {
            return;
        }
        if (this.permutations == null || this.permutations.isEmpty()) {
            return;
        }
        Texture paletteKeyTexture = texturePool.get(this.paletteKey);
        if (paletteKeyTexture == null) {
            return;
        }
        BufferedImage keyPalette = paletteKeyTexture.getTextureImage();
        HashMap<String, PaletteMap> palettes = new HashMap<String, PaletteMap>(this.permutations.size());
        for (Map.Entry<String, ResourcePath<Texture>> permutationEntry : this.permutations.entrySet()) {
            try {
                Texture texture = texturePool.get(permutationEntry.getValue());
                if (texture == null) continue;
                BufferedImage image = texture.getTextureImage();
                PaletteMap palette = new PaletteMap(keyPalette, image);
                palettes.put(permutationEntry.getKey(), palette);
            }
            catch (ArrayIndexOutOfBoundsException ex) {
                Logger.global.logDebug("Failed to load paletted_permutation: Permutation palette %s does not match key palette %s.".formatted(permutationEntry.getValue(), this.paletteKey));
            }
        }
        Color tempColor = new Color();
        for (ResourcePath<Texture> resource : this.textures) {
            Texture texture = texturePool.get(resource);
            if (texture == null) continue;
            BufferedImage image = texture.getTextureImage();
            for (Map.Entry paletteEntry : palettes.entrySet()) {
                String suffix = (String)paletteEntry.getKey();
                PaletteMap palette = (PaletteMap)paletteEntry.getValue();
                ResourcePath<Texture> sprite = new ResourcePath<Texture>(resource.getNamespace(), resource.getValue() + this.separator + suffix);
                if (texturePool.contains(sprite) || !textureFilter.test(sprite)) continue;
                BufferedImage resultImage = new BufferedImage(image.getWidth(), image.getHeight(), 2);
                for (int x = 0; x < image.getWidth(); ++x) {
                    for (int y = 0; y < image.getHeight(); ++y) {
                        int color = BufferedImageUtil.readPixel(image, x, y, tempColor).getInt();
                        float alpha = (float)(color >> 24 & 0xFF) / 255.0f;
                        color = palette.applyAsInt(color);
                        resultImage.setRGB(x, y, ((int)((alpha *= (float)(color >> 24 & 0xFF) / 255.0f) * 255.0f) & 0xFF) << 24 | color & 0xFFFFFF);
                    }
                }
                texturePool.put(sprite, Texture.from(sprite, resultImage, texture.getAnimation()));
            }
        }
    }

    @Override
    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        PalettedPermutationsSource that = (PalettedPermutationsSource)o;
        return Objects.equals(this.textures, that.textures) && Objects.equals(this.separator, that.separator) && Objects.equals(this.paletteKey, that.paletteKey) && Objects.equals(this.permutations, that.permutations);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.textures, this.separator, this.paletteKey, this.permutations);
    }

    public Set<ResourcePath<Texture>> getTextures() {
        return this.textures;
    }

    public String getSeparator() {
        return this.separator;
    }

    public ResourcePath<Texture> getPaletteKey() {
        return this.paletteKey;
    }

    public Map<String, ResourcePath<Texture>> getPermutations() {
        return this.permutations;
    }

    public PalettedPermutationsSource(Set<ResourcePath<Texture>> textures, String separator, ResourcePath<Texture> paletteKey, Map<String, ResourcePath<Texture>> permutations) {
        this.textures = textures;
        this.separator = separator;
        this.paletteKey = paletteKey;
        this.permutations = permutations;
    }

    private PalettedPermutationsSource() {
    }

    private static class PaletteMap
    implements IntUnaryOperator {
        private final Map<Integer, Integer> map = new HashMap<Integer, Integer>();

        public PaletteMap(BufferedImage keys, BufferedImage values) {
            Color tempColor = new Color();
            for (int x = 0; x < keys.getWidth(); ++x) {
                for (int y = 0; y < keys.getHeight(); ++y) {
                    int keyColor = BufferedImageUtil.readPixel(keys, x, y, tempColor).getInt();
                    int valueColor = BufferedImageUtil.readPixel(values, x, y, tempColor).getInt();
                    this.map.put(keyColor | 0xFF000000, valueColor);
                }
            }
        }

        @Override
        public int applyAsInt(int operand) {
            Integer result = this.map.get(operand |= 0xFF000000);
            return result == null ? operand : result;
        }
    }
}

