/*
 * Decompiled with CFR 0.152.
 */
package de.bluecolored.bluemap.core.map.hires.block;

import de.bluecolored.bluemap.core.map.TextureGallery;
import de.bluecolored.bluemap.core.map.hires.RenderSettings;
import de.bluecolored.bluemap.core.map.hires.block.BlockRenderer;
import de.bluecolored.bluemap.core.map.hires.block.BlockRendererFactory;
import de.bluecolored.bluemap.core.map.hires.block.LiquidModelRenderer;
import de.bluecolored.bluemap.core.map.hires.block.MissingModelRenderer;
import de.bluecolored.bluemap.core.map.hires.block.ResourceModelRenderer;
import de.bluecolored.bluemap.core.resources.pack.resourcepack.ResourcePack;
import de.bluecolored.bluemap.core.util.Key;
import de.bluecolored.bluemap.core.util.Keyed;
import de.bluecolored.bluemap.core.util.Registry;
import de.bluecolored.bluemap.core.world.BlockState;

public interface BlockRendererType
extends Keyed,
BlockRendererFactory {
    public static final BlockRendererType DEFAULT = new Impl(Key.bluemap("default"), ResourceModelRenderer::new);
    public static final BlockRendererType LIQUID = new Impl(Key.bluemap("liquid"), LiquidModelRenderer::new);
    public static final BlockRendererType MISSING = new Impl(Key.bluemap("missing"), MissingModelRenderer::new);
    public static final Registry<BlockRendererType> REGISTRY = new Registry((Keyed[])new BlockRendererType[]{DEFAULT, LIQUID, MISSING});

    default public boolean isFallbackFor(BlockState blockState) {
        return false;
    }

    public static class Impl
    implements BlockRendererType {
        private final Key key;
        private final BlockRendererFactory rendererFactory;

        @Override
        public BlockRenderer create(ResourcePack resourcePack, TextureGallery textureGallery, RenderSettings renderSettings) {
            return this.rendererFactory.create(resourcePack, textureGallery, renderSettings);
        }

        public Impl(Key key, BlockRendererFactory rendererFactory) {
            this.key = key;
            this.rendererFactory = rendererFactory;
        }

        @Override
        public Key getKey() {
            return this.key;
        }
    }
}

