/*
 * Decompiled with CFR 0.152.
 */
package de.bluecolored.bluemap.common.web;

import de.bluecolored.bluemap.common.config.PluginConfig;
import de.bluecolored.bluemap.common.live.LiveMarkersDataSupplier;
import de.bluecolored.bluemap.common.live.LivePlayersDataSupplier;
import de.bluecolored.bluemap.common.serverinterface.Server;
import de.bluecolored.bluemap.common.web.CachedRateLimitDataSupplier;
import de.bluecolored.bluemap.common.web.JsonDataRequestHandler;
import de.bluecolored.bluemap.common.web.MapStorageRequestHandler;
import de.bluecolored.bluemap.common.web.RoutingRequestHandler;
import de.bluecolored.bluemap.common.web.http.HttpRequestHandler;
import de.bluecolored.bluemap.core.map.BmMap;
import de.bluecolored.bluemap.core.storage.MapStorage;
import java.util.UUID;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.jetbrains.annotations.Nullable;

public class MapRequestHandler
extends RoutingRequestHandler {
    public MapRequestHandler(BmMap map, Server serverInterface, PluginConfig pluginConfig, Predicate<UUID> playerFilter) {
        this(map.getStorage(), new LivePlayersDataSupplier(serverInterface, pluginConfig, map.getWorld(), playerFilter), new LiveMarkersDataSupplier(map.getMarkerSets()));
    }

    public MapRequestHandler(MapStorage mapStorage) {
        this(mapStorage, null, null);
    }

    public MapRequestHandler(MapStorage mapStorage, @Nullable Supplier<String> livePlayersDataSupplier, @Nullable Supplier<String> liveMarkerDataSupplier) {
        this.register(".*", (HttpRequestHandler)new MapStorageRequestHandler(mapStorage));
        if (livePlayersDataSupplier != null) {
            this.register("live/players\\.json", "", (HttpRequestHandler)new JsonDataRequestHandler(new CachedRateLimitDataSupplier(livePlayersDataSupplier, 1000L)));
        }
        if (liveMarkerDataSupplier != null) {
            this.register("live/markers\\.json", "", (HttpRequestHandler)new JsonDataRequestHandler(new CachedRateLimitDataSupplier(liveMarkerDataSupplier, 10000L)));
        }
    }
}

