/*
 * Decompiled with CFR 0.152.
 */
package de.bluecolored.bluemap.common.config;

import com.flowpowered.math.vector.Vector2i;
import com.google.gson.FieldNamingPolicy;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonParseException;
import com.google.gson.reflect.TypeToken;
import de.bluecolored.bluemap.api.gson.MarkerGson;
import de.bluecolored.bluemap.api.markers.MarkerSet;
import de.bluecolored.bluemap.common.config.ConfigurationException;
import de.bluecolored.bluemap.core.map.MapSettings;
import de.bluecolored.bluemap.core.map.mask.CombinedMask;
import de.bluecolored.bluemap.core.util.Key;
import de.bluecolored.shadow.configurate.ConfigurateException;
import de.bluecolored.shadow.configurate.ConfigurationNode;
import de.bluecolored.shadow.configurate.gson.GsonConfigurationLoader;
import de.bluecolored.shadow.configurate.loader.HeaderMode;
import de.bluecolored.shadow.configurate.objectmapping.ConfigSerializable;
import java.lang.reflect.Type;
import java.nio.file.Path;
import java.util.Map;
import org.jetbrains.annotations.Nullable;

@ConfigSerializable
public class MapConfig
implements MapSettings {
    @Nullable
    private Path world = null;
    @Nullable
    private Key dimension = null;
    @Nullable
    private String name = null;
    private int sorting = 0;
    @Nullable
    private Vector2i startPos = null;
    private String skyColor = "#7dabff";
    private String voidColor = "#000000";
    private float ambientLight = 0.0f;
    private float skyLight = 1.0f;
    private int removeCavesBelowY = 55;
    private int caveDetectionOceanFloor = 10000;
    private boolean caveDetectionUsesBlockLight = false;
    private CombinedMask renderMask = new CombinedMask();
    private long minInhabitedTime = 0L;
    private int minInhabitedTimeRadius = 0;
    private boolean renderEdges = true;
    private int edgeLightStrength = 15;
    private boolean enablePerspectiveView = true;
    private boolean enableFlatView = true;
    private boolean enableFreeFlightView = true;
    private boolean enableHires = true;
    private boolean checkForRemovedRegions = true;
    private String storage = "file";
    private boolean ignoreMissingLightData = false;
    @Nullable
    private ConfigurationNode markerSets = null;
    private int hiresTileSize = 32;
    private int lowresTileSize = 500;
    private int lodCount = 3;
    private int lodFactor = 5;
    private Integer minX;
    private Integer maxX;
    private Integer minZ;
    private Integer maxZ;
    private Integer minY;
    private Integer maxY;

    public Map<String, MarkerSet> parseMarkerSets() throws ConfigurationException {
        if (this.markerSets == null || this.markerSets.empty()) {
            return Map.of();
        }
        try {
            String markerJson = ((GsonConfigurationLoader.Builder)GsonConfigurationLoader.builder().headerMode(HeaderMode.NONE)).lenient(false).indent(0).buildAndSaveString(this.markerSets);
            Gson gson = MarkerGson.addAdapters(new GsonBuilder()).setFieldNamingPolicy(FieldNamingPolicy.LOWER_CASE_WITH_DASHES).create();
            Type markerSetType = new TypeToken<Map<String, MarkerSet>>(this){}.getType();
            return (Map)gson.fromJson(markerJson, markerSetType);
        }
        catch (JsonParseException | ConfigurateException ex) {
            throw new ConfigurationException("Failed to parse marker-sets.Make sure your marker-configuration for this map is valid.", ex);
        }
    }

    public void checkLegacy() throws ConfigurationException {
        if (this.minX != null || this.maxX != null || this.minZ != null || this.maxZ != null || this.minY != null || this.maxY != null) {
            throw new ConfigurationException("Your map-configuration is outdated!\nLooks like you updated BlueMap but did not follow the upgrade-instructions correctly.\nTo fix your config, make sure to follow all relevant upgrade-instructions from BlueMap's changelogs.\nYou can find them here: https://github.com/BlueMap-Minecraft/BlueMap/releases\n".trim());
        }
    }

    @Nullable
    public Path getWorld() {
        return this.world;
    }

    @Nullable
    public Key getDimension() {
        return this.dimension;
    }

    @Nullable
    public String getName() {
        return this.name;
    }

    @Override
    public int getSorting() {
        return this.sorting;
    }

    @Override
    @Nullable
    public Vector2i getStartPos() {
        return this.startPos;
    }

    @Override
    public String getSkyColor() {
        return this.skyColor;
    }

    @Override
    public String getVoidColor() {
        return this.voidColor;
    }

    @Override
    public float getAmbientLight() {
        return this.ambientLight;
    }

    @Override
    public float getSkyLight() {
        return this.skyLight;
    }

    @Override
    public int getRemoveCavesBelowY() {
        return this.removeCavesBelowY;
    }

    @Override
    public int getCaveDetectionOceanFloor() {
        return this.caveDetectionOceanFloor;
    }

    @Override
    public boolean isCaveDetectionUsesBlockLight() {
        return this.caveDetectionUsesBlockLight;
    }

    @Override
    public CombinedMask getRenderMask() {
        return this.renderMask;
    }

    @Override
    public long getMinInhabitedTime() {
        return this.minInhabitedTime;
    }

    @Override
    public int getMinInhabitedTimeRadius() {
        return this.minInhabitedTimeRadius;
    }

    @Override
    public boolean isRenderEdges() {
        return this.renderEdges;
    }

    @Override
    public int getEdgeLightStrength() {
        return this.edgeLightStrength;
    }

    @Override
    public boolean isEnablePerspectiveView() {
        return this.enablePerspectiveView;
    }

    @Override
    public boolean isEnableFlatView() {
        return this.enableFlatView;
    }

    @Override
    public boolean isEnableFreeFlightView() {
        return this.enableFreeFlightView;
    }

    @Override
    public boolean isEnableHires() {
        return this.enableHires;
    }

    @Override
    public boolean isCheckForRemovedRegions() {
        return this.checkForRemovedRegions;
    }

    public String getStorage() {
        return this.storage;
    }

    @Override
    public boolean isIgnoreMissingLightData() {
        return this.ignoreMissingLightData;
    }

    @Nullable
    public ConfigurationNode getMarkerSets() {
        return this.markerSets;
    }

    @Override
    public int getHiresTileSize() {
        return this.hiresTileSize;
    }

    @Override
    public int getLowresTileSize() {
        return this.lowresTileSize;
    }

    @Override
    public int getLodCount() {
        return this.lodCount;
    }

    @Override
    public int getLodFactor() {
        return this.lodFactor;
    }
}

