/*
 * Decompiled with CFR 0.152.
 */
package de.bluecolored.bluemap.common.commands.commands;

import de.bluecolored.bluecommands.annotations.Argument;
import de.bluecolored.bluecommands.annotations.Command;
import de.bluecolored.bluemap.common.commands.Permission;
import de.bluecolored.bluemap.common.commands.TextFormat;
import de.bluecolored.bluemap.common.plugin.Plugin;
import de.bluecolored.bluemap.common.rendermanager.MapUpdatePreparationTask;
import de.bluecolored.bluemap.common.serverinterface.CommandSource;
import de.bluecolored.bluemap.core.map.BmMap;
import de.bluecolored.shadow.adventure.adventure.text.Component;

public class UnfreezeCommand {
    private final Plugin plugin;

    @Command(value={"unfreeze <map>"})
    @Permission(value="bluemap.unfreeze")
    public void unfreeze(CommandSource source, @Argument(value="map") BmMap map) {
        this.plugin.getPluginState().getMapState(map).setUpdateEnabled(true);
        this.plugin.startWatchingMap(map);
        source.sendMessage(TextFormat.format("% Map % is no longer % and will update automatically", TextFormat.ICON_IN_PROGRESS, TextFormat.formatMap(map).color(TextFormat.HIGHLIGHT_COLOR), Component.text("frozen").color(TextFormat.FROZEN_COLOR)).color(TextFormat.BASE_COLOR));
        this.plugin.getRenderManager().scheduleRenderTask(MapUpdatePreparationTask.updateMap(map, this.plugin.getRenderManager()));
        this.plugin.save();
    }

    public UnfreezeCommand(Plugin plugin) {
        this.plugin = plugin;
    }
}

