/*
 * Decompiled with CFR 0.152.
 */
package com.finndog.moogs_structures.utils;

import com.mojang.serialization.DataResult;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.StringJoiner;
import net.minecraft.class_2960;

public final class VersionResolver {
    private static final String CURRENT_VERSION_STRING = "1.21.5";
    private static final VersionNumber CURRENT_VERSION = VersionNumber.parseInternal("1.21.5");

    private VersionResolver() {
    }

    public static VersionNumber getCurrentVersion() {
        return CURRENT_VERSION;
    }

    public static String getCurrentVersionString() {
        return CURRENT_VERSION_STRING;
    }

    public static DataResult<List<VersionEntry>> parseVersionMap(Map<String, class_2960> raw) {
        ArrayList<VersionEntry> entries = new ArrayList<VersionEntry>();
        for (Map.Entry<String, class_2960> entry : raw.entrySet()) {
            DataResult parsedEntry = VersionResolver.parseRange(entry.getKey()).map(range -> new VersionEntry((String)entry.getKey(), (VersionRange)range, (class_2960)entry.getValue()));
            Optional result = parsedEntry.result();
            if (result.isEmpty()) {
                String errorMessage = parsedEntry.error().map(DataResult.Error::message).orElse("Unknown version range error");
                return DataResult.error(() -> errorMessage);
            }
            entries.add((VersionEntry)result.get());
        }
        return DataResult.success(List.copyOf(entries));
    }

    public static DataResult<Map<String, class_2960>> encodeVersionEntries(List<VersionEntry> entries) {
        LinkedHashMap<String, class_2960> map = new LinkedHashMap<String, class_2960>();
        for (VersionEntry entry : entries) {
            map.put(entry.rawRange(), entry.location());
        }
        return DataResult.success(map);
    }

    public static Optional<VersionEntry> resolve(List<VersionEntry> entries, VersionNumber version) {
        for (VersionEntry entry : entries) {
            if (!entry.range().contains(version)) continue;
            return Optional.of(entry);
        }
        return Optional.empty();
    }

    public static DataResult<VersionRange> parseRange(String raw) {
        String trimmed = raw.trim();
        if (trimmed.isEmpty()) {
            return DataResult.error(() -> "Version range cannot be empty");
        }
        String[] tokens = trimmed.split("-", -1);
        if (tokens.length == 1) {
            return VersionResolver.parseVersionNumber(tokens[0]).map(number -> new VersionRange((VersionNumber)number, (VersionNumber)number));
        }
        if (tokens.length == 2) {
            if (tokens[0].isEmpty() || tokens[1].isEmpty()) {
                return DataResult.error(() -> "Version range '" + raw + "' must specify both minimum and maximum versions");
            }
            DataResult<VersionNumber> minResult = VersionResolver.parseVersionNumber(tokens[0]);
            DataResult<VersionNumber> maxResult = VersionResolver.parseVersionNumber(tokens[1]);
            Optional min = minResult.result();
            if (min.isEmpty()) {
                String errorMessage = minResult.error().map(DataResult.Error::message).orElse("Failed to parse minimum version for range '" + raw + "'");
                return DataResult.error(() -> errorMessage);
            }
            Optional max = maxResult.result();
            if (max.isEmpty()) {
                String errorMessage = maxResult.error().map(DataResult.Error::message).orElse("Failed to parse maximum version for range '" + raw + "'");
                return DataResult.error(() -> errorMessage);
            }
            if (((VersionNumber)min.get()).compareTo((VersionNumber)max.get()) > 0) {
                return DataResult.error(() -> "Version range '" + raw + "' has a minimum greater than its maximum");
            }
            return DataResult.success((Object)new VersionRange((VersionNumber)min.get(), (VersionNumber)max.get()));
        }
        return DataResult.error(() -> "Version range '" + raw + "' has too many '-' separators");
    }

    private static DataResult<VersionNumber> parseVersionNumber(String raw) {
        String trimmed = raw.trim();
        if (trimmed.isEmpty()) {
            return DataResult.error(() -> "Version value cannot be empty");
        }
        String[] parts = trimmed.split("\\.");
        ArrayList<Integer> numbers = new ArrayList<Integer>(parts.length);
        for (String part : parts) {
            if (part.isEmpty()) {
                return DataResult.error(() -> "Version '" + raw + "' contains empty components");
            }
            try {
                numbers.add(Integer.parseInt(part));
            }
            catch (NumberFormatException exception) {
                return DataResult.error(() -> "Version '" + raw + "' contains non-numeric component '" + part + "'");
            }
        }
        return DataResult.success((Object)new VersionNumber(List.copyOf(numbers)));
    }

    public record VersionNumber(List<Integer> parts) implements Comparable<VersionNumber>
    {
        public VersionNumber {
            if (parts.isEmpty()) {
                throw new IllegalArgumentException("Version number must contain at least one component");
            }
            parts = List.copyOf(parts);
        }

        private static VersionNumber parseInternal(String value) {
            String[] tokens = value.split("\\.");
            ArrayList<Integer> numbers = new ArrayList<Integer>(tokens.length);
            for (String token : tokens) {
                numbers.add(Integer.parseInt(token));
            }
            return new VersionNumber(List.copyOf(numbers));
        }

        @Override
        public int compareTo(VersionNumber other) {
            int maxLength = Math.max(this.parts.size(), other.parts.size());
            for (int index = 0; index < maxLength; ++index) {
                int right;
                int left = index < this.parts.size() ? this.parts.get(index) : 0;
                int n = right = index < other.parts.size() ? other.parts.get(index) : 0;
                if (left == right) continue;
                return Integer.compare(left, right);
            }
            return 0;
        }

        @Override
        public String toString() {
            StringJoiner joiner = new StringJoiner(".");
            for (Integer part : this.parts) {
                joiner.add(Integer.toString(part));
            }
            return joiner.toString();
        }
    }

    public record VersionEntry(String rawRange, VersionRange range, class_2960 location) {
    }

    public record VersionRange(VersionNumber minInclusive, VersionNumber maxInclusive) {
        public VersionRange {
            Objects.requireNonNull(minInclusive, "minInclusive");
            Objects.requireNonNull(maxInclusive, "maxInclusive");
        }

        public boolean contains(VersionNumber version) {
            return version.compareTo(this.minInclusive) >= 0 && version.compareTo(this.maxInclusive) <= 0;
        }

        @Override
        public String toString() {
            return String.valueOf(this.minInclusive) + "-" + String.valueOf(this.maxInclusive);
        }
    }
}

