/*
 * Decompiled with CFR 0.152.
 */
package com.illusivesoulworks.polymorph.server;

import com.illusivesoulworks.polymorph.PolymorphConstants;
import com.illusivesoulworks.polymorph.platform.Services;
import com.illusivesoulworks.polymorph.server.wrapper.CraftingRecipeWrapper;
import com.illusivesoulworks.polymorph.server.wrapper.RecipeWrapper;
import com.illusivesoulworks.polymorph.server.wrapper.SmithingRecipeWrapper;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.StringJoiner;
import java.util.TreeSet;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import net.minecraft.class_1852;
import net.minecraft.class_1860;
import net.minecraft.class_1863;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3956;
import net.minecraft.class_7923;
import net.minecraft.class_8786;
import net.minecraft.class_9695;

public class PolymorphCommands {
    public static void register(CommandDispatcher<class_2168> dispatcher) {
        int opPermissionLevel = 2;
        LiteralArgumentBuilder command = (LiteralArgumentBuilder)class_2170.method_9247((String)"polymorph").requires(player -> player.method_9259(2));
        command.then(class_2170.method_9247((String)"conflicts").executes(context -> PolymorphCommands.findConflicts((class_2168)context.getSource())));
        dispatcher.register(command);
    }

    private static int findConflicts(class_2168 source) {
        CompletableFuture.runAsync(() -> {
            source.method_9226(() -> class_2561.method_43471((String)"commands.polymorph.conflicts.starting"), true);
            class_3218 world = source.method_9225();
            class_1863 recipeManager = world.method_64577();
            ArrayList<String> output = new ArrayList<String>();
            int count = 0;
            int craftingConflicts = PolymorphCommands.scanRecipes(class_3956.field_17545, output, recipeManager, CraftingRecipeWrapper::new, source, "crafting");
            count += craftingConflicts;
            int smeltingConflicts = PolymorphCommands.scanRecipes(class_3956.field_17546, output, recipeManager, RecipeWrapper::new, source, "smelting");
            count += smeltingConflicts;
            int blastingConflicts = PolymorphCommands.scanRecipes(class_3956.field_17547, output, recipeManager, RecipeWrapper::new, source, "blasting");
            count += blastingConflicts;
            int smokingConflicts = PolymorphCommands.scanRecipes(class_3956.field_17548, output, recipeManager, RecipeWrapper::new, source, "smoking");
            count += smokingConflicts;
            int smithingConflicts = PolymorphCommands.scanRecipes(class_3956.field_25388, output, recipeManager, SmithingRecipeWrapper::new, source, "smithing");
            if ((count += smithingConflicts) > 0) {
                try {
                    Files.write(Paths.get(String.valueOf(Services.PLATFORM.getGameDir()) + "/logs/polymorph-conflicts.log", new String[0]), output, StandardCharsets.UTF_8, new OpenOption[0]);
                }
                catch (IOException e) {
                    PolymorphConstants.LOG.error("Whoops! Something went wrong writing down your conflicts :(");
                    e.printStackTrace();
                }
            }
            int finalCount = count;
            source.method_9226(() -> class_2561.method_43469((String)"commands.polymorph.conflicts.success", (Object[])new Object[]{finalCount}), true);
        });
        return 1;
    }

    private static <I extends class_9695, T extends class_1860<I>> int scanRecipes(class_3956<T> pType, List<String> pOutput, class_1863 pRecipeManager, Function<class_8786<?>, RecipeWrapper> pFactory, class_2168 pSource, String pLabel) {
        List<RecipeWrapper> recipes = pRecipeManager.method_8126().stream().filter(holder -> holder.comp_1933().method_17716() == pType).map(h -> (RecipeWrapper)pFactory.apply((class_8786<?>)h)).toList();
        ArrayList conflicts = new ArrayList();
        TreeSet<class_2960> skipped = new TreeSet<class_2960>();
        HashSet<class_2960> processed = new HashSet<class_2960>();
        int totalRecipes = recipes.size();
        pSource.method_9226(() -> class_2561.method_43469((String)"commands.polymorph.conflicts.scanning", (Object[])new Object[]{totalRecipes, pLabel}), true);
        int checked = 0;
        int lastReportedPercent = 0;
        for (RecipeWrapper recipeWrapper : recipes) {
            int currentPercent;
            class_2960 class_29602 = recipeWrapper.getId();
            if ((currentPercent = ++checked * 100 / totalRecipes) >= lastReportedPercent + 10) {
                lastReportedPercent = currentPercent / 10 * 10;
                int finalChecked = checked;
                int finalPercent = lastReportedPercent;
                pSource.method_9226(() -> class_2561.method_43469((String)"commands.polymorph.conflicts.progress", (Object[])new Object[]{finalChecked, totalRecipes, finalPercent}), true);
            }
            if (processed.contains(class_29602)) continue;
            processed.add(class_29602);
            if (recipeWrapper.getRecipe() instanceof class_1852) {
                skipped.add(class_29602);
                continue;
            }
            TreeSet<class_2960> currentGroup = new TreeSet<class_2960>();
            for (RecipeWrapper otherRecipe : recipes) {
                if (processed.contains(otherRecipe.getId()) || !otherRecipe.conflicts(recipeWrapper)) continue;
                currentGroup.add(class_29602);
                currentGroup.add(otherRecipe.getId());
                processed.add(otherRecipe.getId());
            }
            if (currentGroup.isEmpty()) continue;
            conflicts.add(currentGroup);
        }
        pOutput.add("===================================================================");
        pOutput.add(String.valueOf(class_7923.field_41188.method_10221(pType)) + " recipe conflicts (" + conflicts.size() + ")");
        pOutput.add("===================================================================");
        pOutput.add("");
        int count = 1;
        for (Set set : conflicts) {
            StringJoiner joiner = new StringJoiner(", ");
            set.stream().map(class_2960::toString).forEach(joiner::add);
            pOutput.add(count + ": " + String.valueOf(joiner));
            pOutput.add("");
            ++count;
        }
        if (!skipped.isEmpty()) {
            pOutput.add("Skipped special recipes: ");
            for (class_2960 class_29603 : skipped) {
                pOutput.add(class_29603.toString());
            }
            pOutput.add("");
        }
        int n = conflicts.size();
        pSource.method_9226(() -> class_2561.method_43469((String)"commands.polymorph.conflicts.found", (Object[])new Object[]{conflictCount, pLabel}), true);
        return n;
    }
}

