/*
 * Decompiled with CFR 0.152.
 */
package com.illusivesoulworks.polymorph.common.integration;

import com.google.common.collect.ImmutableSet;
import com.illusivesoulworks.polymorph.common.integration.AbstractCompatibilityModule;
import com.illusivesoulworks.polymorph.platform.Services;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;
import net.minecraft.class_1703;
import net.minecraft.class_2586;
import net.minecraft.class_3222;
import net.minecraft.class_8786;

public class PolymorphIntegrations {
    private static final Set<String> ACTIVATED = ConcurrentHashMap.newKeySet();
    private static final Map<String, AbstractCompatibilityModule> ACTIVE_INTEGRATIONS = new ConcurrentHashMap<String, AbstractCompatibilityModule>();
    private static final Map<String, Supplier<Supplier<AbstractCompatibilityModule>>> INTEGRATIONS = Services.INTEGRATION_PLATFORM.createCompatibilityModules();

    public static void load() {
        for (Mod mod : Mod.values()) {
            ACTIVATED.add(mod.getId());
        }
    }

    public static void init() {
        INTEGRATIONS.forEach((modid, supplier) -> {
            if (Services.PLATFORM.isModLoaded((String)modid)) {
                ACTIVE_INTEGRATIONS.put((String)modid, (AbstractCompatibilityModule)((Supplier)supplier.get()).get());
            }
        });
    }

    public static void setup() {
        for (AbstractCompatibilityModule integration : PolymorphIntegrations.get()) {
            integration.setup();
        }
    }

    public static void clientSetup() {
        for (AbstractCompatibilityModule integration : PolymorphIntegrations.get()) {
            integration.clientSetup();
        }
    }

    public static void selectRecipe(class_2586 blockEntity, class_1703 containerMenu, class_8786<?> recipe) {
        for (AbstractCompatibilityModule integration : PolymorphIntegrations.get()) {
            if (!integration.selectRecipe(blockEntity, recipe) && !integration.selectRecipe(containerMenu, recipe)) continue;
            return;
        }
    }

    public static void selectRecipe(class_1703 containerMenu, class_8786<?> recipe) {
        for (AbstractCompatibilityModule integration : PolymorphIntegrations.get()) {
            if (!integration.selectRecipe(containerMenu, recipe)) continue;
            return;
        }
    }

    public static void openContainer(class_1703 containerMenu, class_3222 serverPlayer) {
        for (AbstractCompatibilityModule integration : PolymorphIntegrations.get()) {
            if (!integration.openContainer(containerMenu, serverPlayer)) continue;
            return;
        }
    }

    public static Set<AbstractCompatibilityModule> get() {
        return ImmutableSet.copyOf(ACTIVE_INTEGRATIONS.values());
    }

    public static boolean isActive(String id) {
        return ACTIVATED.contains(id);
    }

    public static void disable(String id) {
        ACTIVATED.remove(id);
        INTEGRATIONS.remove(id);
        AbstractCompatibilityModule module = ACTIVE_INTEGRATIONS.remove(id);
        if (module != null) {
            module.disable();
        }
    }

    public static enum Mod {
        REI("roughlyenoughitems", true),
        JEI("jei", true),
        EMI("emi", true),
        QUICKBENCH("quickbench", true);

        private final String id;
        private final boolean defaultValue;

        private Mod(String id, boolean defaultValue) {
            this.id = id;
            this.defaultValue = defaultValue;
        }

        public boolean getDefaultValue() {
            return this.defaultValue;
        }

        public String getId() {
            return this.id;
        }
    }
}

