/*
 * Decompiled with CFR 0.152.
 */
package com.illusivesoulworks.polymorph.common.capability;

import com.illusivesoulworks.polymorph.api.PolymorphApi;
import com.illusivesoulworks.polymorph.api.common.capability.IPlayerRecipeData;
import com.illusivesoulworks.polymorph.client.RecipesWidget;
import com.illusivesoulworks.polymorph.common.capability.AbstractRecipeData;
import com.mojang.datafixers.util.Pair;
import java.util.List;
import java.util.Set;
import java.util.SortedSet;
import javax.annotation.Nonnull;
import net.minecraft.class_1657;
import net.minecraft.class_1703;
import net.minecraft.class_1860;
import net.minecraft.class_1937;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3956;
import net.minecraft.class_8786;
import net.minecraft.class_9695;
import net.minecraft.server.MinecraftServer;

public class PlayerRecipeData
extends AbstractRecipeData<class_1657>
implements IPlayerRecipeData {
    private class_1703 containerMenu;
    private class_8786<?> cachedSelection;
    private int lastAccessTick;

    public PlayerRecipeData(class_1657 owner) {
        super(owner);
    }

    @Override
    public <I extends class_9695, T extends class_1860<I>> class_8786<T> getRecipe(class_3956<T> type, I recipeInput, class_1937 level, List<class_8786<T>> recipesList) {
        if (((class_1657)this.getOwner()).field_6012 == this.lastAccessTick) {
            if (this.cachedSelection != null) {
                this.setSelectedRecipe(this.cachedSelection);
            }
        } else {
            this.cachedSelection = null;
        }
        class_8786<T> result = super.getRecipe(type, recipeInput, level, recipesList);
        if (this.getContainerMenu() == ((class_1657)this.getOwner()).field_7512) {
            this.syncPlayerRecipeData();
        }
        this.setContainerMenu(null);
        if (((class_1657)this.getOwner()).field_6012 != this.lastAccessTick) {
            this.lastAccessTick = ((class_1657)this.getOwner()).field_6012;
            if (this.validateThread(level)) {
                this.cachedSelection = result;
            }
        }
        return result;
    }

    private boolean validateThread(class_1937 level) {
        MinecraftServer server = level.method_8503();
        return server != null && server.method_3777() == Thread.currentThread();
    }

    @Override
    public void selectRecipe(@Nonnull class_8786<?> recipe) {
        this.cachedSelection = null;
        super.selectRecipe(recipe);
        this.syncPlayerRecipeData();
    }

    private void syncPlayerRecipeData() {
        if (this.getOwner() instanceof class_3222) {
            class_2960 resourceLocation = this.getSelectedRecipe() != null ? this.getSelectedRecipe().comp_1932().method_29177() : null;
            PolymorphApi.getInstance().getNetwork().sendPlayerSyncS2C((class_3222)this.getOwner(), this.getRecipesList(), resourceLocation);
        }
    }

    @Override
    public void sendRecipesListToListeners() {
        if (this.getContainerMenu() == ((class_1657)this.getOwner()).field_7512) {
            class_2960 resourceLocation = this.getSelectedRecipe() != null ? this.getSelectedRecipe().comp_1932().method_29177() : null;
            Pair packetData = new Pair(this.getRecipesList(), (Object)resourceLocation);
            class_1657 player = (class_1657)this.getOwner();
            if (player.method_73183().method_8608()) {
                RecipesWidget.get().ifPresent(widget -> widget.setRecipesList((Set)packetData.getFirst(), (class_2960)packetData.getSecond()));
            } else if (player instanceof class_3222) {
                PolymorphApi.getInstance().getNetwork().sendRecipesListS2C((class_3222)player, (SortedSet)packetData.getFirst(), (class_2960)packetData.getSecond());
            }
        }
    }

    @Override
    public void setContainerMenu(class_1703 containerMenu) {
        this.containerMenu = containerMenu;
    }

    @Override
    public class_1703 getContainerMenu() {
        return this.containerMenu;
    }
}

