/*
 * Decompiled with CFR 0.152.
 */
package com.illusivesoulworks.polymorph.common.capability;

import com.illusivesoulworks.polymorph.api.PolymorphApi;
import com.illusivesoulworks.polymorph.api.common.base.IRecipePair;
import com.illusivesoulworks.polymorph.api.common.capability.IRecipeData;
import com.illusivesoulworks.polymorph.common.capability.RecipeCache;
import com.illusivesoulworks.polymorph.common.util.RecipePair;
import com.mojang.datafixers.util.Pair;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.UUID;
import javax.annotation.Nonnull;
import net.minecraft.class_10295;
import net.minecraft.class_10302;
import net.minecraft.class_1799;
import net.minecraft.class_1852;
import net.minecraft.class_1860;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3956;
import net.minecraft.class_5321;
import net.minecraft.class_5455;
import net.minecraft.class_7225;
import net.minecraft.class_7924;
import net.minecraft.class_8786;
import net.minecraft.class_9695;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractRecipeData<E>
implements IRecipeData<E> {
    private final SortedSet<IRecipePair> recipesList = new TreeSet<IRecipePair>();
    private final E owner;
    private final RecipeCache recipeCache;
    private final Map<UUID, class_3222> listeners;
    private class_8786<?> selectedRecipe;
    protected class_2960 loadedRecipe;

    public AbstractRecipeData(E owner) {
        this.owner = owner;
        this.recipeCache = new RecipeCache(10);
        this.listeners = new HashMap<UUID, class_3222>();
    }

    @Override
    public <I extends class_9695, T extends class_1860<I>> class_8786<T> getRecipe(class_3956<T> type, I recipeInput, class_1937 level, List<class_8786<T>> recipesListIn) {
        List<class_8786<T>> recipes;
        List<class_8786<T>> list = recipes = recipesListIn.isEmpty() ? this.recipeCache.get(level, type, recipeInput) : recipesListIn;
        if (recipes.isEmpty()) {
            this.updateRecipesList(new TreeSet<IRecipePair>());
            return null;
        }
        class_5455 registryAccess = level.method_30349();
        if (this.loadedRecipe != null && this.getSelectedRecipe() == null && level instanceof class_3218) {
            class_3218 serverLevel = (class_3218)level;
            class_5321 recipeKey = class_5321.method_29179((class_5321)class_7924.field_52178, (class_2960)this.loadedRecipe);
            serverLevel.method_64577().method_8130(recipeKey).ifPresent(this::setSelectedRecipe);
        }
        this.loadedRecipe = null;
        class_8786<T> firstResult = null;
        class_8786<T> selected = null;
        TreeSet<IRecipePair> recipesList = new TreeSet<IRecipePair>();
        for (class_8786<T> entry : recipes) {
            class_1860 recipe = entry.comp_1933();
            class_2960 id = entry.comp_1932().method_29177();
            class_1799 output = class_1799.field_8037;
            List display = entry.comp_1933().method_64664();
            if (!display.isEmpty()) {
                class_10302 resultDisplay = ((class_10295)display.getFirst()).comp_3258();
                if (resultDisplay instanceof class_10302.class_10306) {
                    class_10302.class_10306 itemDisplay = (class_10302.class_10306)resultDisplay;
                    output = new class_1799((class_1935)itemDisplay.comp_3273().comp_349());
                } else if (resultDisplay instanceof class_10302.class_10307) {
                    class_10302.class_10307 stackDisplay = (class_10302.class_10307)resultDisplay;
                    output = stackDisplay.comp_3274();
                }
            }
            if (output == null || output.method_7960() || entry.comp_1933() instanceof class_1852) {
                output = recipe.method_8116(recipeInput, (class_7225.class_7874)registryAccess);
            }
            if (output.method_7960()) continue;
            if (firstResult == null) {
                firstResult = entry;
            }
            boolean flag = false;
            if (selected == null && this.getSelectedRecipe() != null && this.getSelectedRecipe().comp_1932().method_29177().equals((Object)id)) {
                selected = entry;
                flag = true;
            }
            if (recipesList.size() >= 15 && !flag) continue;
            recipesList.add(new RecipePair(id, output));
        }
        if (selected == null) {
            selected = firstResult;
            this.setSelectedRecipe(selected);
        }
        this.updateRecipesList(recipesList);
        return selected;
    }

    protected void updateRecipesList(SortedSet<IRecipePair> recipesList) {
        this.setRecipesList(recipesList);
        this.sendRecipesListToListeners();
    }

    @Override
    public class_8786<?> getSelectedRecipe() {
        return this.selectedRecipe;
    }

    @Override
    public void setSelectedRecipe(class_8786<?> recipe) {
        this.selectedRecipe = recipe;
    }

    @Override
    @Nonnull
    public SortedSet<IRecipePair> getRecipesList() {
        return this.recipesList;
    }

    @Override
    public void setRecipesList(@Nonnull SortedSet<IRecipePair> recipesList) {
        this.recipesList.clear();
        this.recipesList.addAll(recipesList);
    }

    @Override
    public E getOwner() {
        return this.owner;
    }

    @Override
    public void selectRecipe(@Nonnull class_8786<?> recipe) {
        this.setSelectedRecipe(recipe);
    }

    @Override
    public Collection<class_3222> getListeners() {
        return Collections.unmodifiableCollection(this.listeners.values());
    }

    @Override
    public void addListener(@Nonnull class_3222 serverPlayer) {
        this.listeners.put(serverPlayer.method_5667(), serverPlayer);
    }

    @Override
    public void removeListener(@NotNull class_3222 serverPlayer) {
        this.listeners.remove(serverPlayer.method_5667());
    }

    @Override
    public void clearListeners() {
        this.listeners.clear();
    }

    @Override
    public void sendRecipesListToListeners() {
        class_2960 resourceLocation = this.getSelectedRecipe() != null ? this.getSelectedRecipe().comp_1932().method_29177() : null;
        Pair packetData = new Pair(this.getRecipesList(), (Object)resourceLocation);
        for (class_3222 listener : this.getListeners()) {
            PolymorphApi.getInstance().getNetwork().sendRecipesListS2C(listener, (SortedSet)packetData.getFirst(), (class_2960)packetData.getSecond());
        }
    }

    @Override
    public void readNBT(class_7225.class_7874 provider, class_2487 compoundTag) {
        if (compoundTag.method_10545("SelectedRecipe")) {
            compoundTag.method_10558("SelectedRecipe").ifPresent(str -> {
                this.loadedRecipe = class_2960.method_12829((String)str);
            });
        }
    }

    @Override
    @Nonnull
    public class_2487 writeNBT(class_7225.class_7874 provider) {
        class_2487 nbt = new class_2487();
        if (this.selectedRecipe != null) {
            nbt.method_10582("SelectedRecipe", this.selectedRecipe.comp_1932().method_29177().toString());
        }
        return nbt;
    }
}

