/*
 * Decompiled with CFR 0.152.
 */
package com.illusivesoulworks.polymorph.api.client.widgets.children;

import com.illusivesoulworks.polymorph.api.client.widgets.children.OutputWidget;
import com.illusivesoulworks.polymorph.api.common.base.IRecipePair;
import com.illusivesoulworks.polymorph.platform.Services;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_364;
import net.minecraft.class_4068;
import net.minecraft.class_465;
import net.minecraft.class_8666;

public class SelectionWidget
implements class_4068,
class_364 {
    private final Consumer<class_2960> onSelect;
    private final class_465<?> containerScreen;
    private final List<OutputWidget> outputWidgets = new ArrayList<OutputWidget>();
    private final Pair<class_8666, class_8666> sprites;
    private int xOffset;
    private int yOffset;
    private OutputWidget hoveredButton;
    private boolean active = false;
    private int x;
    private int y;
    private int lastX;
    private int lastY;

    public SelectionWidget(int x, int y, int xOffset, int yOffset, Pair<class_8666, class_8666> sprites, Consumer<class_2960> onSelect, class_465<?> containerScreen) {
        this.setPosition(x, y);
        this.onSelect = onSelect;
        this.containerScreen = containerScreen;
        this.xOffset = xOffset;
        this.yOffset = yOffset;
        this.sprites = sprites;
    }

    public void setPosition(int x, int y) {
        this.x = x;
        this.y = y;
        this.updateButtonPositions();
    }

    public void setOffsets(int x, int y) {
        this.xOffset = x;
        this.yOffset = y;
    }

    public void highlightButton(class_2960 resourceLocation) {
        this.outputWidgets.forEach(widget -> widget.setHighlighted(widget.getResourceLocation().equals((Object)resourceLocation)));
    }

    private void updateButtonPositions() {
        int size = this.outputWidgets.size();
        int xOffset = (int)(-25.0 * Math.floor((float)size / 2.0f));
        if (size % 2 == 0) {
            xOffset += 13;
        }
        int[] pos = new int[]{this.x + xOffset, this.y};
        this.outputWidgets.forEach(widget -> {
            widget.method_48229(pos[0], pos[1]);
            pos[0] = pos[0] + 25;
        });
    }

    public List<OutputWidget> getOutputWidgets() {
        return this.outputWidgets;
    }

    public void setRecipeList(Set<IRecipePair> recipeList) {
        this.outputWidgets.clear();
        recipeList.forEach(data -> {
            if (!data.getOutput().method_7960()) {
                this.outputWidgets.add(new OutputWidget(this.sprites, (IRecipePair)data));
            }
        });
        this.updateButtonPositions();
    }

    public void setActive(boolean active) {
        this.active = active;
    }

    public boolean isActive() {
        return this.active;
    }

    public void renderTooltip(class_332 guiGraphics, int mouseX, int mouseY) {
        class_310 mc = class_310.method_1551();
        if (mc.field_1755 != null && this.hoveredButton != null) {
            guiGraphics.method_51446(mc.field_1772, this.hoveredButton.getOutput(), mouseX, mouseY);
        }
    }

    public void method_25394(@Nonnull class_332 guiGraphics, int mouseX, int mouseY, float partialTicks) {
        if (this.isActive()) {
            int x = Services.CLIENT_PLATFORM.getScreenLeft(this.containerScreen) + this.xOffset;
            int y = Services.CLIENT_PLATFORM.getScreenTop(this.containerScreen) + this.yOffset;
            if (this.lastX != x || this.lastY != y) {
                this.setPosition(x, y);
                this.lastX = x;
                this.lastY = y;
            }
            this.hoveredButton = null;
            this.outputWidgets.forEach(button -> {
                button.method_25394(guiGraphics, mouseX, mouseY, partialTicks);
                if (button.field_22764 && button.method_25367()) {
                    this.hoveredButton = button;
                }
            });
            this.renderTooltip(guiGraphics, mouseX, mouseY);
        }
    }

    public boolean handleClick(double mouseX, double mouseY, int button) {
        if (this.isActive()) {
            for (OutputWidget widget : this.outputWidgets) {
                if (!widget.method_49606()) continue;
                this.onSelect.accept(widget.getResourceLocation());
                return true;
            }
        }
        return false;
    }

    public void method_25365(boolean var1) {
    }

    public boolean method_25370() {
        return false;
    }
}

