/*
 * Decompiled with CFR 0.152.
 */
package net.replaceitem.integratedcircuit.client.gui.widget;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.class_11909;
import net.replaceitem.integratedcircuit.circuit.Component;
import net.replaceitem.integratedcircuit.circuit.Components;
import net.replaceitem.integratedcircuit.client.gui.IntegratedCircuitScreen;
import net.replaceitem.integratedcircuit.client.gui.widget.ToolSelectionInfo;
import net.replaceitem.integratedcircuit.client.gui.widget.ToolboxButton;

public class Toolbox {
    private static final int PALETTE_COLS = 4;
    private final IntegratedCircuitScreen owner;
    private final int x;
    private final int y;
    private static final Component[] PALETTE = new Component[]{Components.WIRE, Components.CROSSOVER, Components.TORCH, Components.REDSTONE_BLOCK, Components.REPEATER, Components.COMPARATOR, Components.OBSERVER, Components.BLOCK, Components.LAMP, Components.COPPER_BULB, Components.LECTERN, Components.TARGET, Components.STONE_BUTTON, Components.WOODEN_BUTTON, Components.LEVER};
    private int selectedToolSlot = -1;
    private final List<ToolboxButton> componentButtons = new ArrayList<ToolboxButton>(PALETTE.length);
    private final List<Consumer<ToolSelectionInfo>> toolSelectionSubscribers = new ArrayList<Consumer<ToolSelectionInfo>>();

    public Toolbox(IntegratedCircuitScreen owner, int x, int y) {
        this.owner = owner;
        this.x = x;
        this.y = y;
    }

    public void init() {
        this.componentButtons.clear();
        int i = 0;
        while (i < PALETTE.length) {
            Component component = PALETTE[i];
            int slotColumn = i % 4;
            int slotX = slotColumn * 16;
            int slotRow = i / 4;
            int slotY = slotRow * 16;
            final int index = i++;
            this.componentButtons.add(new ToolboxButton(this.owner.getX() + this.x + (slotX += 2 * (slotColumn + 1)), this.owner.getY() + this.y + (slotY += 2 * (slotRow + 1)), component){

                public void method_25348(class_11909 click, boolean doubled) {
                    if (this.selected) {
                        Toolbox.this.deselectTool();
                    } else {
                        Toolbox.this.selectTool(index);
                    }
                }
            });
        }
        this.componentButtons.forEach(this.owner::method_37063);
    }

    public void registerToolSelectionSubscriber(Consumer<ToolSelectionInfo> subscriber) {
        this.toolSelectionSubscribers.add(subscriber);
    }

    public void unregisterToolSelectionSubscriber(Consumer<ToolSelectionInfo> subscriber) {
        this.toolSelectionSubscribers.remove(subscriber);
    }

    public ToolSelectionInfo selectTool(int index) {
        if (index < 0 || index >= this.componentButtons.size()) {
            return null;
        }
        if (this.selectedToolSlot >= 0 && this.selectedToolSlot < this.componentButtons.size()) {
            this.componentButtons.get(this.selectedToolSlot).setSelected(false);
        }
        this.selectedToolSlot = index;
        ToolboxButton toolboxButton = this.componentButtons.get(index);
        toolboxButton.setSelected(true);
        Component component = toolboxButton.getComponent();
        ToolSelectionInfo selectionInfo = new ToolSelectionInfo(index, component);
        this.notifyToolSelectionSubscribers(selectionInfo);
        return selectionInfo;
    }

    public void deselectTool() {
        if (this.selectedToolSlot >= 0 && this.selectedToolSlot < this.componentButtons.size()) {
            this.componentButtons.get(this.selectedToolSlot).setSelected(false);
        }
        this.selectedToolSlot = -1;
        this.notifyToolSelectionSubscribers(new ToolSelectionInfo(this.selectedToolSlot, null));
    }

    private void notifyToolSelectionSubscribers(ToolSelectionInfo selectionInfo) {
        for (Consumer<ToolSelectionInfo> subscriber : this.toolSelectionSubscribers) {
            subscriber.accept(selectionInfo);
        }
    }

    public Component getComponent(int index) {
        if (index < 0 || index >= this.componentButtons.size()) {
            return null;
        }
        return this.componentButtons.get(index).getComponent();
    }

    public int getComponentIndex(Component component) {
        for (int i = 0; i < this.componentButtons.size(); ++i) {
            if (this.componentButtons.get(i).getComponent() != component) continue;
            return i;
        }
        return -1;
    }

    public int getSelectedToolSlot() {
        return this.selectedToolSlot;
    }
}

