/*
 * Decompiled with CFR 0.152.
 */
package net.replaceitem.integratedcircuit.circuit.components;

import net.minecraft.class_1657;
import net.minecraft.class_2561;
import net.minecraft.class_2689;
import net.minecraft.class_2741;
import net.minecraft.class_2746;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_5819;
import net.minecraft.class_9848;
import net.replaceitem.integratedcircuit.IntegratedCircuit;
import net.replaceitem.integratedcircuit.circuit.Circuit;
import net.replaceitem.integratedcircuit.circuit.Component;
import net.replaceitem.integratedcircuit.circuit.ComponentState;
import net.replaceitem.integratedcircuit.circuit.ServerCircuit;
import net.replaceitem.integratedcircuit.circuit.components.FacingComponent;
import net.replaceitem.integratedcircuit.client.gui.IntegratedCircuitScreen;
import net.replaceitem.integratedcircuit.util.ComponentPos;
import net.replaceitem.integratedcircuit.util.FlatDirection;
import org.jetbrains.annotations.Nullable;

public class ButtonComponent
extends FacingComponent {
    private static final class_2960 ITEM_TEXTURE_STONE = IntegratedCircuit.id("textures/integrated_circuit/button_stone.png");
    private static final class_2960 ITEM_TEXTURE_WOOD = IntegratedCircuit.id("textures/integrated_circuit/button_wood.png");
    private static final class_2960 TOOL_TEXTURE_STONE = IntegratedCircuit.id("toolbox/icons/button_stone");
    private static final class_2960 TOOL_TEXTURE_WOOD = IntegratedCircuit.id("toolbox/icons/button_wood");
    public static final class_2746 POWERED = class_2741.field_12484;
    private final boolean wooden;

    public ButtonComponent(Component.Settings settings, boolean wooden) {
        super(settings);
        this.wooden = wooden;
        this.setDefaultState((ComponentState)((Object)((ComponentState)this.getStateManager().method_11664()).method_11657((class_2769)POWERED, Boolean.valueOf(false))));
    }

    @Override
    @Nullable
    public class_2960 getItemTexture() {
        return this.wooden ? ITEM_TEXTURE_WOOD : ITEM_TEXTURE_STONE;
    }

    @Override
    @Nullable
    public class_2960 getToolTexture() {
        return this.wooden ? TOOL_TEXTURE_WOOD : TOOL_TEXTURE_STONE;
    }

    @Override
    public class_2561 getHoverInfoText(ComponentState state) {
        return IntegratedCircuitScreen.getSignalStrengthText((Boolean)state.method_11654((class_2769)POWERED) != false ? 15 : 0);
    }

    @Override
    public void render(class_332 drawContext, int x, int y, float a, ComponentState state) {
        class_2960 texture = this.getItemTexture();
        float b = (Boolean)state.method_11654((class_2769)POWERED) != false ? 0.5f : 1.0f;
        IntegratedCircuitScreen.renderComponentTexture(drawContext, texture, x, y, ((FlatDirection)((Object)state.method_11654((class_2769)FACING))).getIndex(), class_9848.method_61318((float)a, (float)b, (float)b, (float)b));
    }

    @Override
    public void onUse(ComponentState state, Circuit circuit, ComponentPos pos, class_1657 player) {
        if (((Boolean)state.method_11654((class_2769)POWERED)).booleanValue()) {
            return;
        }
        this.powerOn(state, circuit, pos);
        this.playClickSound(player, circuit, true);
    }

    protected void playClickSound(@Nullable class_1657 player, Circuit circuit, boolean powered) {
        circuit.playSound((class_1657)(powered ? player : null), this.getClickSound(powered), class_3419.field_15245, 1.0f, 1.0f);
    }

    protected class_3414 getClickSound(boolean powered) {
        return powered ? (this.wooden ? class_3417.field_14699 : class_3417.field_14791) : (this.wooden ? class_3417.field_15105 : class_3417.field_14954);
    }

    @Override
    public void onStateReplaced(ComponentState state, Circuit circuit, ComponentPos pos, ComponentState newState) {
        if (state.isOf(newState.getComponent())) {
            return;
        }
        if (((Boolean)state.method_11654((class_2769)POWERED)).booleanValue()) {
            circuit.updateNeighborsAlways(pos, this);
        }
    }

    @Override
    public void scheduledTick(ComponentState state, ServerCircuit circuit, ComponentPos pos, class_5819 random) {
        if (!((Boolean)state.method_11654((class_2769)POWERED)).booleanValue()) {
            return;
        }
        circuit.setComponentState(pos, (ComponentState)((Object)state.method_11657((class_2769)POWERED, Boolean.valueOf(false))), 3);
        circuit.updateNeighborsAlways(pos, this);
        this.playClickSound(null, circuit, false);
    }

    public void powerOn(ComponentState state, Circuit circuit, ComponentPos pos) {
        circuit.setComponentState(pos, (ComponentState)((Object)state.method_11657((class_2769)POWERED, Boolean.valueOf(true))), 3);
        circuit.updateNeighborsAlways(pos, this);
        circuit.scheduleBlockTick(pos, this, this.wooden ? 30 : 20);
    }

    @Override
    public int getWeakRedstonePower(ComponentState state, Circuit circuit, ComponentPos pos, FlatDirection direction) {
        return (Boolean)state.method_11654((class_2769)POWERED) != false ? 15 : 0;
    }

    @Override
    public boolean isSolidBlock(Circuit circuit, ComponentPos pos) {
        return false;
    }

    @Override
    public boolean emitsRedstonePower(ComponentState state) {
        return true;
    }

    @Override
    public void appendProperties(class_2689.class_2690<Component, ComponentState> builder) {
        super.appendProperties(builder);
        builder.method_11667(new class_2769[]{POWERED});
    }
}

