/*
 * Decompiled with CFR 0.152.
 */
package net.replaceitem.integratedcircuit.circuit.components;

import net.minecraft.class_2561;
import net.minecraft.class_2758;
import net.minecraft.class_2769;
import net.replaceitem.integratedcircuit.circuit.Circuit;
import net.replaceitem.integratedcircuit.circuit.Component;
import net.replaceitem.integratedcircuit.circuit.ComponentState;
import net.replaceitem.integratedcircuit.circuit.components.AbstractConductingComponent;
import net.replaceitem.integratedcircuit.circuit.components.WireComponent;
import net.replaceitem.integratedcircuit.client.gui.IntegratedCircuitScreen;
import net.replaceitem.integratedcircuit.util.ComponentPos;
import net.replaceitem.integratedcircuit.util.FlatDirection;

public abstract class AbstractWireComponent
extends AbstractConductingComponent {
    public AbstractWireComponent(Component.Settings settings) {
        super(settings);
    }

    @Override
    public class_2561 getHoverInfoText(ComponentState state) {
        int signalStrength = (Integer)state.method_11654((class_2769)this.getPowerProperty());
        return IntegratedCircuitScreen.getSignalStrengthText(signalStrength);
    }

    @Override
    public void onBlockAdded(ComponentState state, Circuit circuit, ComponentPos pos, ComponentState oldState) {
        if (oldState.getComponent() == state.getComponent() || circuit.isClient) {
            return;
        }
        this.update(circuit, pos, state);
        this.updateOffsetNeighbors(circuit, pos);
    }

    @Override
    public void neighborUpdate(ComponentState state, Circuit circuit, ComponentPos pos, Component sourceBlock, ComponentPos sourcePos, boolean notify) {
        if (circuit.isClient) {
            return;
        }
        this.update(circuit, pos, state);
    }

    @Override
    public int getStrongRedstonePower(ComponentState state, Circuit circuit, ComponentPos pos, FlatDirection direction) {
        return this.getWeakRedstonePower(state, circuit, pos, direction);
    }

    @Override
    protected void update(Circuit circuit, ComponentPos pos, ComponentState state) {
        int i = this.getReceivedRedstonePower(circuit, pos);
        if ((Integer)state.method_11654((class_2769)this.getPowerProperty()) != i) {
            if (circuit.getComponentState(pos) == state) {
                circuit.setComponentState(pos, (ComponentState)((Object)state.method_11657((class_2769)this.getPowerProperty(), Integer.valueOf(i))), 2);
            }
            this.updateAfterSignalStrengthChange(circuit, pos);
        }
    }

    protected class_2758 getPowerProperty() {
        return WireComponent.POWER;
    }

    protected int getReceivedRedstonePower(Circuit circuit, ComponentPos pos) {
        wiresGivePower = false;
        int i = circuit.getReceivedRedstonePower(pos);
        wiresGivePower = true;
        int j = 0;
        if (i < 15) {
            for (FlatDirection direction : FlatDirection.VALUES) {
                ComponentPos blockPos = pos.offset(direction);
                ComponentState blockState = circuit.getComponentState(blockPos);
                j = Math.max(j, blockState.increasePower(direction.getOpposite()));
            }
        }
        return Math.max(i, j - 1);
    }
}

