/*
 * Decompiled with CFR 0.152.
 */
package net.replaceitem.integratedcircuit.circuit.components;

import net.minecraft.class_1953;
import net.minecraft.class_2689;
import net.minecraft.class_2741;
import net.minecraft.class_2746;
import net.minecraft.class_2769;
import net.minecraft.class_5819;
import net.replaceitem.integratedcircuit.circuit.Circuit;
import net.replaceitem.integratedcircuit.circuit.Component;
import net.replaceitem.integratedcircuit.circuit.ComponentState;
import net.replaceitem.integratedcircuit.circuit.Components;
import net.replaceitem.integratedcircuit.circuit.ServerCircuit;
import net.replaceitem.integratedcircuit.circuit.components.FacingComponent;
import net.replaceitem.integratedcircuit.circuit.components.WireComponent;
import net.replaceitem.integratedcircuit.util.ComponentPos;
import net.replaceitem.integratedcircuit.util.FlatDirection;

public abstract class AbstractRedstoneGateComponent
extends FacingComponent {
    public static final class_2746 POWERED = class_2741.field_12484;

    public AbstractRedstoneGateComponent(Component.Settings settings) {
        super(settings);
    }

    @Override
    public void scheduledTick(ComponentState state, ServerCircuit circuit, ComponentPos pos, class_5819 random) {
        if (this.isLocked(circuit, pos, state)) {
            return;
        }
        boolean powered = (Boolean)state.method_11654((class_2769)POWERED);
        boolean hasPower = this.hasPower(circuit, pos, state);
        if (powered && !hasPower) {
            circuit.setComponentState(pos, (ComponentState)((Object)state.method_11657((class_2769)POWERED, Boolean.valueOf(false))), 2);
        } else if (!powered) {
            circuit.setComponentState(pos, (ComponentState)((Object)state.method_11657((class_2769)POWERED, Boolean.valueOf(true))), 2);
            if (!hasPower) {
                circuit.scheduleBlockTick(pos, this, this.getUpdateDelayInternal(state), class_1953.field_9313);
            }
        }
    }

    @Override
    public int getStrongRedstonePower(ComponentState state, Circuit circuit, ComponentPos pos, FlatDirection direction) {
        return state.getWeakRedstonePower(circuit, pos, direction);
    }

    @Override
    public int getWeakRedstonePower(ComponentState state, Circuit circuit, ComponentPos pos, FlatDirection direction) {
        if (!((Boolean)state.method_11654((class_2769)POWERED)).booleanValue()) {
            return 0;
        }
        if (state.method_11654((class_2769)FACING) == direction) {
            return this.getOutputLevel(circuit, pos, state);
        }
        return 0;
    }

    @Override
    public void neighborUpdate(ComponentState state, Circuit circuit, ComponentPos pos, Component sourceBlock, ComponentPos sourcePos, boolean notify) {
        if (state.canPlaceAt(circuit, pos)) {
            this.updatePowered(circuit, pos, state);
            return;
        }
        circuit.removeBlock(pos);
        for (FlatDirection direction : FlatDirection.VALUES) {
            circuit.updateNeighborsAlways(pos.offset(direction), this);
        }
    }

    protected void updatePowered(Circuit circuit, ComponentPos pos, ComponentState state) {
        if (this.isLocked(circuit, pos, state)) {
            return;
        }
        boolean isPowered = (Boolean)state.method_11654((class_2769)POWERED);
        if (isPowered != this.hasPower(circuit, pos, state) && !circuit.getCircuitTickScheduler().isTicking(pos, this)) {
            class_1953 tickPriority = class_1953.field_9310;
            if (this.isTargetNotAligned(circuit, pos, state)) {
                tickPriority = class_1953.field_9315;
            } else if (isPowered) {
                tickPriority = class_1953.field_9313;
            }
            circuit.scheduleBlockTick(pos, this, this.getUpdateDelayInternal(state), tickPriority);
        }
    }

    public boolean isLocked(Circuit circuit, ComponentPos pos, ComponentState state) {
        return false;
    }

    protected boolean hasPower(Circuit circuit, ComponentPos pos, ComponentState state) {
        return this.getPower(circuit, pos, state) > 0;
    }

    protected int getPower(Circuit circuit, ComponentPos pos, ComponentState state) {
        FlatDirection facing = (FlatDirection)((Object)state.method_11654((class_2769)FACING));
        ComponentPos blockPos = pos.offset(facing);
        int i = circuit.getEmittedRedstonePower(blockPos, facing);
        if (i >= 15) {
            return i;
        }
        ComponentState blockState = circuit.getComponentState(blockPos);
        return Math.max(i, blockState.isOf(Components.WIRE) ? (Integer)blockState.method_11654((class_2769)WireComponent.POWER) : 0);
    }

    protected int getMaxInputLevelSides(Circuit circuit, ComponentPos pos, ComponentState state) {
        FlatDirection direction = (FlatDirection)((Object)state.method_11654((class_2769)FACING));
        FlatDirection direction2 = direction.rotated(1);
        FlatDirection direction3 = direction.rotated(-1);
        return Math.max(this.getInputLevel(circuit, pos.offset(direction2), direction2), this.getInputLevel(circuit, pos.offset(direction3), direction3));
    }

    protected int getInputLevel(Circuit circuit, ComponentPos pos, FlatDirection dir) {
        ComponentState state = circuit.getComponentState(pos);
        if (this.isValidInput(state)) {
            if (state.isOf(Components.REDSTONE_BLOCK)) {
                return 15;
            }
            if (state.isOf(Components.WIRE)) {
                return (Integer)state.method_11654((class_2769)WireComponent.POWER);
            }
            return circuit.getStrongRedstonePower(pos, dir);
        }
        return 0;
    }

    @Override
    public boolean emitsRedstonePower(ComponentState state) {
        return true;
    }

    @Override
    public ComponentState getPlacementState(Circuit circuit, ComponentPos pos, FlatDirection rotation) {
        return (ComponentState)((Object)this.getDefaultState().method_11657((class_2769)FACING, (Comparable)((Object)rotation)));
    }

    @Override
    public void onPlaced(ServerCircuit circuit, ComponentPos pos, ComponentState state) {
        if (this.hasPower(circuit, pos, state)) {
            circuit.scheduleBlockTick(pos, this, 1);
        }
    }

    @Override
    public void onBlockAdded(ComponentState state, Circuit circuit, ComponentPos pos, ComponentState oldState) {
        this.updateTarget(circuit, pos, state);
    }

    @Override
    public void onStateReplaced(ComponentState state, Circuit circuit, ComponentPos pos, ComponentState newState) {
        if (state.isOf(newState.getComponent())) {
            return;
        }
        super.onStateReplaced(state, circuit, pos, newState);
        this.updateTarget(circuit, pos, state);
    }

    protected void updateTarget(Circuit circuit, ComponentPos pos, ComponentState state) {
        FlatDirection direction = (FlatDirection)((Object)state.method_11654((class_2769)FACING));
        ComponentPos blockPos = pos.offset(direction.getOpposite());
        circuit.updateNeighbor(blockPos, this, pos);
        circuit.updateNeighborsExcept(blockPos, this, direction);
    }

    protected boolean isValidInput(ComponentState state) {
        return state.emitsRedstonePower();
    }

    protected int getOutputLevel(Circuit circuit, ComponentPos pos, ComponentState state) {
        return 15;
    }

    public static boolean isRedstoneGate(ComponentState state) {
        return state.getComponent() instanceof AbstractRedstoneGateComponent;
    }

    public boolean isTargetNotAligned(Circuit world, ComponentPos pos, ComponentState state) {
        FlatDirection direction = ((FlatDirection)((Object)state.method_11654((class_2769)FACING))).getOpposite();
        ComponentState blockState = world.getComponentState(pos.offset(direction));
        return AbstractRedstoneGateComponent.isRedstoneGate(blockState) && state.method_11654((class_2769)FACING) != direction;
    }

    protected abstract int getUpdateDelayInternal(ComponentState var1);

    @Override
    public boolean isSolidBlock(Circuit circuit, ComponentPos pos) {
        return false;
    }

    @Override
    public void appendProperties(class_2689.class_2690<Component, ComponentState> builder) {
        super.appendProperties(builder);
        builder.method_11667(new class_2769[]{POWERED});
    }
}

