/*
 * Decompiled with CFR 0.152.
 */
package net.replaceitem.integratedcircuit.circuit;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.class_1657;
import net.minecraft.class_2769;
import net.minecraft.class_3414;
import net.minecraft.class_3419;
import net.minecraft.class_3532;
import net.replaceitem.integratedcircuit.circuit.Circuit;
import net.replaceitem.integratedcircuit.circuit.CircuitSection;
import net.replaceitem.integratedcircuit.circuit.CircuitTickScheduler;
import net.replaceitem.integratedcircuit.circuit.Component;
import net.replaceitem.integratedcircuit.circuit.ComponentState;
import net.replaceitem.integratedcircuit.circuit.Components;
import net.replaceitem.integratedcircuit.circuit.components.PortComponent;
import net.replaceitem.integratedcircuit.circuit.context.CircuitContext;
import net.replaceitem.integratedcircuit.circuit.context.ServerCircuitContext;
import net.replaceitem.integratedcircuit.util.ComponentPos;
import net.replaceitem.integratedcircuit.util.ContextCodec;
import net.replaceitem.integratedcircuit.util.FlatDirection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ServerCircuit
extends Circuit {
    public static final ContextCodec<ServerCircuitContext, ServerCircuit> CODEC = context -> RecordCodecBuilder.create(instance -> instance.group((App)MapCodec.unit((Object)context).forGetter(ServerCircuit::getContext), (App)PORTS_CODEC.fieldOf("ports").forGetter(Circuit::getPorts), (App)CircuitSection.CODEC.fieldOf("section").forGetter(Circuit::getSection), (App)CircuitTickScheduler.CODEC.withContext((CircuitContext)context).fieldOf("tickScheduler").forGetter(ServerCircuit::getCircuitTickScheduler)).apply((Applicative)instance, ServerCircuit::new));
    private final ServerCircuitContext context;
    protected final CircuitTickScheduler circuitTickScheduler;

    public ServerCircuit(ServerCircuitContext context) {
        super(false);
        this.context = context;
        this.circuitTickScheduler = new CircuitTickScheduler();
    }

    public ServerCircuit(@NotNull ServerCircuitContext context, @NotNull ComponentState[] portStates, @NotNull CircuitSection section, @NotNull CircuitTickScheduler tickScheduler) {
        super(false, portStates, section);
        this.context = context;
        this.circuitTickScheduler = tickScheduler;
    }

    @Override
    public CircuitTickScheduler getCircuitTickScheduler() {
        return this.circuitTickScheduler;
    }

    public ServerCircuitContext getContext() {
        return this.context;
    }

    public void tick() {
        this.circuitTickScheduler.tick(this.getTime(), 65536, this::tickBlock);
        this.context.markDirty();
    }

    private void tickBlock(ComponentPos pos, Component block) {
        ComponentState blockState = this.getComponentState(pos);
        if (blockState.isOf(block)) {
            blockState.scheduledTick(this, pos, this.context.getRandom());
        }
    }

    public void onExternalPowerChanged(FlatDirection direction, int power) {
        power = class_3532.method_15340((int)power, (int)0, (int)15);
        ComponentPos pos = (ComponentPos)((Object)PORT_POSITIONS.get((Object)direction));
        ComponentState state = this.getComponentState(pos);
        boolean isOutput = (Boolean)state.method_11654((class_2769)PortComponent.IS_OUTPUT);
        if (!isOutput && (Integer)state.method_11654((class_2769)PortComponent.POWER) != power) {
            this.setComponentState(pos, (ComponentState)((Object)state.method_11657((class_2769)PortComponent.POWER, Integer.valueOf(power))), 3);
        }
    }

    public int getPortOutputStrength(FlatDirection direction) {
        ComponentPos pos = (ComponentPos)((Object)PORT_POSITIONS.get((Object)direction));
        ComponentState state = this.getComponentState(pos);
        if (!((Boolean)state.method_11654((class_2769)PortComponent.IS_OUTPUT)).booleanValue()) {
            return 0;
        }
        return (Integer)state.method_11654((class_2769)PortComponent.POWER);
    }

    @Override
    public long getTime() {
        return this.context.getTime();
    }

    @Override
    public void placeComponentState(ComponentPos pos, Component component, FlatDirection placementRotation) {
        ComponentState beforeState;
        ComponentState placementState = component.getPlacementState(this, pos, placementRotation);
        if (placementState == null) {
            placementState = Components.AIR_DEFAULT_STATE;
        }
        if ((beforeState = this.getComponentState(pos)).isAir() && placementState.isAir()) {
            return;
        }
        this.setComponentState(pos, placementState, 3);
        placementState.getComponent().onPlaced(this, pos, placementState);
    }

    @Override
    public void playSoundInternal(@Nullable class_1657 except, class_3414 sound, class_3419 category, float volume, float pitch) {
        this.context.playSound(except, sound, category, volume, pitch);
    }

    @Override
    protected void updateListeners(ComponentPos pos, ComponentState oldState, ComponentState state, int flags) {
        this.context.onComponentUpdate(pos, state);
    }

    @Override
    public void updateNeighbors(ComponentPos pos, Component component) {
        this.updateNeighborsAlways(pos, component);
    }

    @Override
    public void updateNeighborsAlways(ComponentPos pos, Component sourceComponent) {
        this.neighborUpdater.updateNeighbors(pos, sourceComponent, null);
    }

    @Override
    public void updateNeighborsExcept(ComponentPos pos, Component sourceComponent, FlatDirection direction) {
        this.neighborUpdater.updateNeighbors(pos, sourceComponent, direction);
    }

    @Override
    public void updateNeighbor(ComponentPos pos, Component sourceComponent, ComponentPos sourcePos) {
        this.neighborUpdater.updateNeighbor(pos, sourceComponent, sourcePos);
    }

    @Override
    public void updateNeighbor(ComponentState state, ComponentPos pos, Component sourceComponent, ComponentPos sourcePos, boolean notify) {
        this.neighborUpdater.updateNeighbor(state, pos, sourceComponent, sourcePos, notify);
    }
}

