/*
 * Decompiled with CFR 0.152.
 */
package net.replaceitem.integratedcircuit.circuit;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.Hash;
import java.util.Comparator;
import net.minecraft.class_1953;
import net.replaceitem.integratedcircuit.IntegratedCircuit;
import net.replaceitem.integratedcircuit.circuit.Component;
import net.replaceitem.integratedcircuit.circuit.context.CircuitContext;
import net.replaceitem.integratedcircuit.util.ComponentPos;
import net.replaceitem.integratedcircuit.util.ContextCodec;
import org.jetbrains.annotations.Nullable;

public record OrderedCircuitTick(Component type, ComponentPos pos, long triggerTick, class_1953 priority, long subTickOrder) {
    public static final Codec<class_1953> TICK_PRIORITY_CODEC = Codec.INT.xmap(class_1953::method_8680, class_1953::method_8681);
    public static final ContextCodec<CircuitContext, OrderedCircuitTick> CODEC = context -> RecordCodecBuilder.create(instance -> instance.group((App)IntegratedCircuit.COMPONENTS_REGISTRY.method_39673().fieldOf("c").forGetter(OrderedCircuitTick::type), (App)ComponentPos.MAP_CODEC.forGetter(OrderedCircuitTick::pos), (App)Codec.INT.fieldOf("t").xmap(integer -> context.getTime() + (long)integer.intValue(), l -> (int)(l - context.getTime())).forGetter(OrderedCircuitTick::triggerTick), (App)TICK_PRIORITY_CODEC.fieldOf("p").forGetter(OrderedCircuitTick::priority), (App)Codec.LONG.fieldOf("s").forGetter(OrderedCircuitTick::subTickOrder)).apply((Applicative)instance, OrderedCircuitTick::new));
    public static final Comparator<OrderedCircuitTick> TRIGGER_TICK_COMPARATOR = Comparator.comparingLong(orderedCircuitTick -> orderedCircuitTick.triggerTick).thenComparing(orderedCircuitTick -> orderedCircuitTick.priority).thenComparingLong(orderedCircuitTick -> orderedCircuitTick.subTickOrder);
    public static final Comparator<OrderedCircuitTick> BASIC_COMPARATOR = Comparator.comparing(orderedCircuitTick -> orderedCircuitTick.priority).thenComparingLong(orderedCircuitTick -> orderedCircuitTick.subTickOrder);
    public static final Hash.Strategy<OrderedCircuitTick> HASH_STRATEGY = new Hash.Strategy<OrderedCircuitTick>(){

        public int hashCode(OrderedCircuitTick orderedTick) {
            return 31 * orderedTick.pos().hashCode() + orderedTick.type().hashCode();
        }

        public boolean equals(@Nullable OrderedCircuitTick orderedTick, @Nullable OrderedCircuitTick orderedTick2) {
            if (orderedTick == orderedTick2) {
                return true;
            }
            if (orderedTick != null && orderedTick2 != null) {
                return orderedTick.type() == orderedTick2.type() && orderedTick.pos().equals((Object)orderedTick2.pos());
            }
            return false;
        }
    };

    public OrderedCircuitTick(Component type, ComponentPos pos, long triggerTick, long subTickOrder) {
        this(type, pos, triggerTick, class_1953.field_9314, subTickOrder);
    }

    public static OrderedCircuitTick create(Component type, ComponentPos pos) {
        return new OrderedCircuitTick(type, pos, 0L, class_1953.field_9314, 0L);
    }
}

