/*
 * Decompiled with CFR 0.152.
 */
package net.replaceitem.integratedcircuit.circuit;

import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.minecraft.class_1657;
import net.minecraft.class_2498;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_3414;
import net.minecraft.class_3419;
import net.minecraft.class_8710;
import net.replaceitem.integratedcircuit.circuit.Circuit;
import net.replaceitem.integratedcircuit.circuit.CircuitSection;
import net.replaceitem.integratedcircuit.circuit.CircuitTickScheduler;
import net.replaceitem.integratedcircuit.circuit.Component;
import net.replaceitem.integratedcircuit.circuit.ComponentState;
import net.replaceitem.integratedcircuit.circuit.Components;
import net.replaceitem.integratedcircuit.circuit.context.ClientCircuitContext;
import net.replaceitem.integratedcircuit.network.packet.ComponentInteractionC2SPacket;
import net.replaceitem.integratedcircuit.network.packet.PlaceComponentC2SPacket;
import net.replaceitem.integratedcircuit.network.packet.RenameCircuitC2SPacket;
import net.replaceitem.integratedcircuit.util.ComponentPos;
import net.replaceitem.integratedcircuit.util.FlatDirection;
import org.jetbrains.annotations.Nullable;

public class ClientCircuit
extends Circuit {
    private final ClientCircuitContext context;

    public ClientCircuit(ClientCircuitContext context) {
        super(true);
        this.context = context;
    }

    public ClientCircuit(ClientCircuitContext context, ComponentState[] portStates, CircuitSection section) {
        super(true, portStates, section);
        this.context = context;
    }

    public ClientCircuitContext getContext() {
        return this.context;
    }

    @Override
    public CircuitTickScheduler getCircuitTickScheduler() {
        return CircuitTickScheduler.getClientTickScheduler();
    }

    public void onComponentUpdateFromServer(ComponentState state, ComponentPos pos) {
        this.setComponentState(pos, state, 19);
    }

    @Override
    public void placeComponentState(ComponentPos pos, Component component, FlatDirection placementRotation) {
        ClientPlayNetworking.send((class_8710)new PlaceComponentC2SPacket(pos, this.context.getBlockPos(), component, placementRotation));
        ComponentState placementState = component.getPlacementState(this, pos, placementRotation);
        boolean breaking = component == Components.AIR;
        class_2498 soundGroup = (breaking ? this.getComponentState((ComponentPos)pos).getComponent() : component).getSettings().soundGroup;
        boolean success = this.setComponentState(pos, placementState, 3);
        if (success) {
            this.playSound((class_1657)class_310.method_1551().field_1724, breaking ? soundGroup.method_10595() : soundGroup.method_10598(), class_3419.field_15245, (soundGroup.method_10597() + 1.0f) / 2.0f, soundGroup.method_10599());
        }
    }

    @Override
    public void playSoundInternal(@Nullable class_1657 except, class_3414 sound, class_3419 category, float volume, float pitch) {
        this.context.playSound(except, sound, category, volume, pitch);
    }

    public void breakComponentState(ComponentPos pos) {
        this.placeComponentState(pos, Components.AIR, FlatDirection.NORTH);
    }

    @Override
    public void useComponent(ComponentPos pos, class_1657 player) {
        ClientPlayNetworking.send((class_8710)new ComponentInteractionC2SPacket(pos, this.context.getBlockPos()));
        super.useComponent(pos, player);
    }

    public void rename(class_2561 newName) {
        ClientPlayNetworking.send((class_8710)new RenameCircuitC2SPacket(newName, this.context.getBlockPos()));
    }

    @Override
    public long getTime() {
        return this.context.getTime();
    }

    @Override
    protected void updateListeners(ComponentPos pos, ComponentState oldState, ComponentState state, int flags) {
    }
}

