/*
 * Decompiled with CFR 0.152.
 */
package com.faboslav.friendsandfoes.common.entity;

import com.faboslav.friendsandfoes.common.FriendsAndFoes;
import com.faboslav.friendsandfoes.common.api.MoobloomVariant;
import com.faboslav.friendsandfoes.common.api.MoobloomVariantManager;
import com.faboslav.friendsandfoes.common.init.FriendsAndFoesBlocks;
import com.faboslav.friendsandfoes.common.init.FriendsAndFoesEntityTypes;
import com.faboslav.friendsandfoes.common.init.FriendsAndFoesSoundEvents;
import com.faboslav.friendsandfoes.common.versions.VersionedEntity;
import com.faboslav.friendsandfoes.common.versions.VersionedEntitySpawnReason;
import com.faboslav.friendsandfoes.common.versions.VersionedInteractionResult;
import com.faboslav.friendsandfoes.common.versions.VersionedNbt;
import java.util.Optional;
import net.minecraft.class_10730;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_1266;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1296;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1315;
import net.minecraft.class_1430;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1920;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2261;
import net.minecraft.class_2320;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2756;
import net.minecraft.class_2769;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3218;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3730;
import net.minecraft.class_5147;
import net.minecraft.class_5328;
import net.minecraft.class_5425;
import net.minecraft.class_5712;
import net.minecraft.class_5819;
import net.minecraft.class_6880;
import net.minecraft.class_7917;
import net.minecraft.class_9298;
import net.minecraft.class_9334;
import org.jetbrains.annotations.Nullable;

public final class MoobloomEntity
extends class_1430
implements class_5147 {
    public static final String VARIANT_NBT_NAME = "Variant";
    public static final String FLOWER_NBT_NAME = "Flower";
    private static final class_2940<String> VARIANT = class_2945.method_12791(MoobloomEntity.class, (class_2941)class_2943.field_13326);

    public MoobloomEntity(class_1299<? extends MoobloomEntity> entityType, class_1937 world) {
        super(entityType, world);
    }

    public static boolean canSpawn(class_1299<MoobloomEntity> moobloomEntityType, class_5425 serverWorldAccess, class_3730 spawnReason, class_2338 blockPos, class_5819 random) {
        return serverWorldAccess.method_8320(blockPos.method_10074()).method_27852(class_2246.field_10219) && MoobloomEntity.method_39448((class_1920)serverWorldAccess, (class_2338)blockPos);
    }

    public class_1315 method_5943(class_5425 serverWorldAccess, class_1266 difficulty, class_3730 spawnReason, @Nullable class_1315 entityData) {
        MoobloomVariant possibleMoobloomVariant = MoobloomVariantManager.MOOBLOOM_VARIANT_MANAGER.getRandomBiomeSpecificMoobloomVariant(serverWorldAccess, this.method_24515());
        if (possibleMoobloomVariant != null) {
            this.setVariant(possibleMoobloomVariant);
        } else {
            this.setVariant(MoobloomVariantManager.MOOBLOOM_VARIANT_MANAGER.getRandomMoobloomVariant(serverWorldAccess.method_8409()));
        }
        return super.method_5943(serverWorldAccess, difficulty, spawnReason, entityData);
    }

    public boolean method_27072() {
        return this.method_5805() && !this.method_6109();
    }

    protected void method_5693(class_2945.class_9222 builder) {
        super.method_5693(builder);
        builder.method_56912(VARIANT, (Object)MoobloomVariantManager.MOOBLOOM_VARIANT_MANAGER.getDefaultMoobloomVariant().getName());
    }

    public void method_5652(class_11372 nbt) {
        super.method_5652(nbt);
        nbt.method_71469(VARIANT_NBT_NAME, this.getVariant().getName());
        nbt.method_71469(FLOWER_NBT_NAME, this.getVariant().getFlowerName());
    }

    public void method_5749(class_11368 nbt) {
        super.method_5749(nbt);
        MoobloomVariant moobloomVariant = MoobloomVariantManager.MOOBLOOM_VARIANT_MANAGER.getMoobloomVariantByName(VersionedNbt.getString(nbt, VARIANT_NBT_NAME, this.getVariant().getName()));
        if (moobloomVariant == null) {
            moobloomVariant = MoobloomVariantManager.MOOBLOOM_VARIANT_MANAGER.getDefaultMoobloomVariant();
        }
        this.setVariant(moobloomVariant);
    }

    public class_1269 method_5992(class_1657 player, class_1268 hand) {
        class_1799 itemStack = player.method_5998(hand);
        MoobloomVariant moobloomVariant = MoobloomVariantManager.MOOBLOOM_VARIANT_MANAGER.getByFlowerItem(itemStack.method_7909());
        if (moobloomVariant != null && moobloomVariant != this.getVariant()) {
            this.setVariant(moobloomVariant);
            this.method_5783((class_3414)FriendsAndFoesSoundEvents.ENTITY_MOOBLOOM_CONVERT.get(), 2.0f, 1.0f);
            if (!this.method_73183().method_8608()) {
                itemStack.method_57008(1, (class_1309)player);
            }
            return VersionedInteractionResult.success((class_1297)this);
        }
        if (itemStack.method_31574(class_1802.field_8428) && !this.method_6109()) {
            if (!this.method_73183().method_8608()) {
                class_3414 soundEvent;
                class_1799 suspiciousStew;
                Optional<class_9298> stewEffect = this.getEffectsFromItemStack(this.getVariant().getFlowerAsItem().method_7854());
                if (stewEffect.isPresent()) {
                    suspiciousStew = new class_1799((class_1935)class_1802.field_8766);
                    suspiciousStew.method_57379(class_9334.field_49652, (Object)stewEffect.get());
                    soundEvent = class_3417.field_18269;
                } else {
                    suspiciousStew = new class_1799((class_1935)class_1802.field_8766);
                    suspiciousStew.method_57379(class_9334.field_49652, (Object)class_9298.field_49362);
                    soundEvent = class_3417.field_18268;
                }
                class_1799 itemStack3 = class_5328.method_30270((class_1799)itemStack, (class_1657)player, (class_1799)suspiciousStew, (boolean)false);
                player.method_6122(hand, itemStack3);
                this.method_5783(soundEvent, 2.0f, 1.0f);
            }
            return class_1269.field_5812;
        }
        if (itemStack.method_7909() == class_1802.field_8868 && this.method_27072()) {
            class_1937 class_19372 = this.method_73183();
            if (class_19372 instanceof class_3218) {
                class_3218 serverLevel = (class_3218)class_19372;
                this.method_6636(serverLevel, class_3419.field_15248, itemStack);
                this.method_32875((class_6880)class_5712.field_28730, (class_1297)player);
                itemStack.method_7970(1, (class_1309)player, VersionedEntity.getEquipmentSlotForItem(hand));
            }
            return VersionedInteractionResult.success((class_1297)this);
        }
        return super.method_5992(player, hand);
    }

    public void method_6636(class_3218 level, class_3419 soundSource, class_1799 shears) {
        level.method_43129(null, (class_1297)this, (class_3414)FriendsAndFoesSoundEvents.ENTITY_MOOBLOOM_SHEAR.get(), class_3419.field_15248, 1.0f, 1.0f);
        this.transformToCow(level);
        this.dropShearedItems(level);
    }

    private void transformToCow(class_3218 level) {
        this.method_31472();
        class_10730 cowEntity = (class_10730)class_1299.field_6085.method_5883((class_1937)level, VersionedEntitySpawnReason.CONVERSION);
        if (cowEntity == null) {
            return;
        }
        cowEntity.method_6033(this.method_6032());
        cowEntity.method_5719((class_1297)this);
        cowEntity.field_6220 = this.field_6220;
        cowEntity.field_6283 = this.field_6283;
        cowEntity.field_6259 = this.field_6259;
        cowEntity.field_6241 = this.field_6241;
        if (this.method_16914()) {
            cowEntity.method_5665(this.method_5797());
            cowEntity.method_5880(this.method_5807());
        }
        if (this.method_5947()) {
            cowEntity.method_5971();
        }
        cowEntity.method_5684(this.method_5655());
        level.method_8649((class_1297)cowEntity);
    }

    private void dropShearedItems(class_3218 level) {
        for (int i = 0; i < 5; ++i) {
            level.method_8649((class_1297)new class_1542((class_1937)level, this.method_23317(), this.method_23323(1.0), this.method_23321(), new class_1799((class_1935)this.getVariant().getFlower())));
        }
    }

    private Optional<class_9298> getEffectsFromItemStack(class_1799 stack) {
        class_7917 suspiciousEffectHolder = class_7917.method_47380((class_1935)stack.method_7909());
        return suspiciousEffectHolder != null ? Optional.of(suspiciousEffectHolder.method_53233()) : Optional.empty();
    }

    public MoobloomEntity getBreedOffspring(class_3218 serverWorld, class_1296 entity) {
        MoobloomVariant moobloomVariant = this.getVariant();
        if (this.method_59922().method_39332(0, 1) == 0) {
            moobloomVariant = ((MoobloomEntity)entity).getVariant();
        }
        MoobloomEntity moobloom = (MoobloomEntity)((class_1299)FriendsAndFoesEntityTypes.MOOBLOOM.get()).method_5883((class_1937)serverWorld, VersionedEntitySpawnReason.BREEDING);
        moobloom.setVariant(moobloomVariant);
        return moobloom;
    }

    public void method_6007() {
        class_2248 blockUnderneath;
        super.method_6007();
        if (this.method_73183().method_8608() || this.method_6109()) {
            return;
        }
        if ((double)this.method_59922().method_43057() <= 1.6666666E-4 && (blockUnderneath = this.method_73183().method_8320(new class_2338((int)this.method_23317(), (int)this.method_23318() - 1, (int)this.method_23321())).method_26204()) == class_2246.field_10219 && this.method_73183().method_22347(this.method_24515())) {
            class_2261 flower = this.getVariant().getFlower();
            if (MoobloomVariantManager.MOOBLOOM_VARIANT_MANAGER.getMoobloomVariants().size() == 1) {
                int flowerChance = this.method_59922().method_39332(1, 100);
                if (flowerChance >= 0 && flowerChance < 40) {
                    this.method_73183().method_8501(this.method_24515(), ((class_2248)FriendsAndFoesBlocks.BUTTERCUP.get()).method_9564());
                } else if (flowerChance >= 40 && flowerChance < 80) {
                    this.method_73183().method_8501(this.method_24515(), class_2246.field_10182.method_9564());
                } else {
                    class_2680 sunflowerBlockState = (class_2680)class_2246.field_10583.method_9564().method_11657((class_2769)class_2320.field_10929, (Comparable)class_2756.field_12609);
                    this.method_73183().method_8501(this.method_24515(), (class_2680)sunflowerBlockState.method_28493((class_2769)class_2741.field_12533));
                    this.method_73183().method_8501(this.method_24515().method_10084(), sunflowerBlockState);
                }
            } else if (flower instanceof class_2320) {
                class_2680 upperHalfBlockState = (class_2680)flower.method_9564().method_11657((class_2769)class_2320.field_10929, (Comparable)class_2756.field_12609);
                this.method_73183().method_8501(this.method_24515(), (class_2680)upperHalfBlockState.method_28493((class_2769)class_2741.field_12533));
                this.method_73183().method_8501(this.method_24515().method_10084(), upperHalfBlockState);
            } else {
                this.method_73183().method_8501(this.method_24515(), flower.method_9564());
            }
        }
    }

    public void method_5773() {
        if (!FriendsAndFoes.getConfig().enableMoobloom) {
            this.method_31472();
        }
        super.method_5773();
    }

    private void setVariant(MoobloomVariant variant) {
        this.field_6011.method_12778(VARIANT, (Object)variant.getName());
    }

    public MoobloomVariant getVariant() {
        MoobloomVariant moobloomVariant = MoobloomVariantManager.MOOBLOOM_VARIANT_MANAGER.getMoobloomVariantByName((String)this.field_6011.method_12789(VARIANT));
        if (moobloomVariant == null) {
            moobloomVariant = MoobloomVariantManager.MOOBLOOM_VARIANT_MANAGER.getDefaultMoobloomVariant();
        }
        return moobloomVariant;
    }
}

