/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.forgivingvoid;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.blay09.mods.balm.api.Balm;
import net.blay09.mods.balm.api.config.reflection.Comment;
import net.blay09.mods.balm.api.config.reflection.Config;
import net.blay09.mods.balm.api.config.reflection.NestedType;
import net.blay09.mods.forgivingvoid.DamageOnFallMode;
import net.minecraft.class_2960;

@Config(value="forgivingvoid")
public class ForgivingVoidConfig {
    @Comment(value="The distance to the minimum y level at which Forgiving Void should forgive the player and send them towards the sky.")
    public int triggerAtDistanceBelow = 32;
    @Comment(value="Set to ABSOLUTE for absolute fall damage in half hearts, RELATIVE_CURRENT for a percentage of their current health, or RELATIVE_MAX for a percentage of their max health.")
    public DamageOnFallMode damageOnFallMode = DamageOnFallMode.ABSOLUTE;
    @Comment(value="The amount of damage applied to the player when they land.")
    public float damageOnFall = 19.0f;
    @Comment(value="The height from which the player will be falling after falling through the void.")
    public int fallingHeight = 300;
    @Comment(value="Set to true to make Forgiving Void return the player to the sky above their last grounded position instead of their current position. Prevents players from using Forgiving Void to fly across larger distances.")
    public boolean returnToLastGrounded = true;
    @Comment(value="Prevent death on void fall (limits damage to leave at least 0.5 hearts)")
    public boolean preventDeath = false;
    @Comment(value="Set to false to make Forgiving Void not trigger in the overworld void (dimension 0).")
    public boolean triggerInOverworld = true;
    @Comment(value="Set to false to make Forgiving Void not trigger in the nether void (dimension -1).")
    public boolean triggerInNether = true;
    @Comment(value="Set to false to make Forgiving Void not trigger in the end void (dimension 1).")
    public boolean triggerInEnd = true;
    @Comment(value="Set to true if players are rubber-banding while falling through the void. If you're hosting a public server, you should only do this if you have proper anti-cheat installed.")
    public boolean disableVanillaAntiCheatWhileFalling = true;
    @Comment(value="Set to true to have tridents with loyalty be affected by Forgiving Void. Not supported on Forge.")
    public boolean tridentForgiveness = false;
    @NestedType(value=String.class)
    @Comment(value="Effects applied to a player when they fall through the void, in the format \"effect|duration|amplifier\"")
    public List<String> fallThroughVoidEffects = List.of("minecraft:blindness|60|3");
    @Comment(value="List of dimension ids to be allowed for Forgiving Void. Options triggerInOverworld etc. take priority.")
    @NestedType(value=class_2960.class)
    public Set<class_2960> dimensionAllowList = new HashSet<class_2960>();
    @Comment(value="List of additional dimension ids to be deny-listed from Forgiving Void. Options triggerInOverworld etc. take priority. Ignored if dimensionAllowList is set.")
    @NestedType(value=class_2960.class)
    public Set<class_2960> dimensionDenyList = new HashSet<class_2960>();
    @Comment(value="List of entity ids to be allowed for Forgiving Void. On Forge this only supports living entities.")
    @NestedType(value=class_2960.class)
    public Set<class_2960> entityAllowList = Set.of(class_2960.method_60656((String)"player"));

    public static ForgivingVoidConfig getActive() {
        return (ForgivingVoidConfig)Balm.getConfig().getActiveConfig(ForgivingVoidConfig.class);
    }

    public static void initialize() {
        Balm.getConfig().registerConfig(ForgivingVoidConfig.class);
    }
}

