/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.forgivingvoid;

import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayList;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import net.blay09.mods.balm.api.Balm;
import net.blay09.mods.balm.api.event.LivingFallEvent;
import net.blay09.mods.balm.api.event.TickPhase;
import net.blay09.mods.balm.api.event.TickType;
import net.blay09.mods.forgivingvoid.DamageOnFallMode;
import net.blay09.mods.forgivingvoid.ForgivingVoidConfig;
import net.blay09.mods.forgivingvoid.ForgivingVoidFallThroughEvent;
import net.blay09.mods.forgivingvoid.mixin.ServerGamePacketListenerImplAccessor;
import net.blay09.mods.forgivingvoid.mixin.ServerPlayerAccessor;
import net.blay09.mods.forgivingvoid.mixin.ThrownTridentAccessor;
import net.minecraft.class_1293;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1685;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_5321;
import net.minecraft.class_6880;
import net.minecraft.class_7923;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ForgivingVoid {
    public static final String MOD_ID = "forgivingvoid";
    public static final Logger logger = LoggerFactory.getLogger(ForgivingVoid.class);
    public static final Set<class_2248> FALL_CATCHING_BLOCKS = Set.of(class_2246.field_10343);

    public static void initialize() {
        ForgivingVoidConfig.initialize();
        Balm.getEvents().onTickEvent(TickType.ServerEntity, TickPhase.Start, ForgivingVoid::onEntityTick);
        Balm.getEvents().onEvent(LivingFallEvent.class, ForgivingVoid::onLivingEntityFall);
    }

    /*
     * Unable to fully structure code
     */
    public static void onEntityTick(class_1297 entity) {
        if (!ForgivingVoid.isAllowedEntity(entity)) {
            return;
        }
        triggerAtY = entity.method_73183().method_31607() - ForgivingVoidConfig.getActive().triggerAtDistanceBelow;
        v0 = isInVoid = entity.method_23318() < (double)triggerAtY && entity.field_6036 < (double)triggerAtY;
        if (!(entity instanceof class_3222)) ** GOTO lbl-1000
        player = (class_3222)entity;
        if (((ServerGamePacketListenerImplAccessor)player.field_13987).getAwaitingPositionFromClient() != null) {
            v1 = true;
        } else lbl-1000:
        // 2 sources

        {
            v1 = false;
        }
        isTeleporting = v1;
        persistentData = Balm.getHooks().getPersistentData(entity);
        if (entity.method_24828()) {
            persistentData.method_10544("LastGroundedPos", entity.method_24515().method_10063());
        }
        if (isInVoid && !isTeleporting && ForgivingVoid.isEnabledForDimension((class_5321<class_1937>)entity.method_73183().method_27983()) && ForgivingVoid.fireForgivingVoidEvent(entity)) {
            if (entity instanceof class_1309) {
                livingEntity = (class_1309)entity;
                ForgivingVoid.applyFallThroughVoidEffects(livingEntity);
            }
            entitiesToTeleport = new ArrayList<class_1297>();
            entitiesToTeleport.add(entity);
            if (entity.method_5782()) {
                entitiesToTeleport.addAll(entity.method_5685());
                entity.method_5772();
            }
            if ((vehicle = entity.method_5854()) != null) {
                entitiesToTeleport.add(vehicle);
                entity.method_5848();
            }
            entitiesToTeleport.forEach((Consumer<class_1297>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)V, lambda$onEntityTick$0(net.minecraft.class_1297 ), (Lnet/minecraft/class_1297;)V)());
            if (vehicle != null) {
                entity.method_5804(vehicle);
            }
        } else if (persistentData.method_68566("ForgivingVoidIsFalling", false)) {
            if (ForgivingVoid.hasLanded(entity) || ForgivingVoid.isOrMayFly(entity)) {
                persistentData.method_10556("ForgivingVoidIsFalling", false);
                if (entity instanceof ServerPlayerAccessor) {
                    player = (ServerPlayerAccessor)entity;
                    player.setIsChangingDimension(false);
                }
                return;
            }
            if (ForgivingVoidConfig.getActive().disableVanillaAntiCheatWhileFalling && entity instanceof ServerPlayerAccessor) {
                player = (ServerPlayerAccessor)entity;
                player.setIsChangingDimension(true);
            }
        }
    }

    private static void applyFallThroughVoidEffects(class_1309 entity) {
        for (String effectString : ForgivingVoidConfig.getActive().fallThroughVoidEffects) {
            String[] parts = effectString.split("\\|");
            class_2960 registryName = class_2960.method_12829((String)parts[0]);
            if (registryName != null) {
                Optional holder = class_7923.field_41174.method_10223(registryName);
                if (holder.isPresent()) {
                    int duration = ForgivingVoid.tryParseInt(parts.length >= 2 ? parts[1] : null, 600);
                    int amplifier = ForgivingVoid.tryParseInt(parts.length >= 3 ? parts[2] : null, 0);
                    entity.method_6092(new class_1293((class_6880)holder.get(), duration, amplifier));
                    continue;
                }
                logger.info("Invalid fall through void effect '{}'", (Object)parts[0]);
                continue;
            }
            logger.info("Invalid fall through void effect '{}'", (Object)parts[0]);
        }
    }

    private static int tryParseInt(@Nullable String text, int defaultVal) {
        if (text != null) {
            try {
                return Integer.parseInt(text);
            }
            catch (NumberFormatException e) {
                return defaultVal;
            }
        }
        return defaultVal;
    }

    private static boolean isAllowedEntity(class_1297 entity) {
        class_1685 trident;
        Byte loyalty;
        if (entity.method_73183().method_8608()) {
            return false;
        }
        Set<class_2960> entityAllowList = ForgivingVoidConfig.getActive().entityAllowList;
        class_2960 entityId = class_7923.field_41177.method_10221((Object)entity.method_5864());
        if (entityAllowList.isEmpty() && entity instanceof class_1657) {
            return true;
        }
        if (ForgivingVoidConfig.getActive().tridentForgiveness && entity instanceof class_1685 && (loyalty = (Byte)(trident = (class_1685)entity).method_5841().method_12789(ThrownTridentAccessor.getIdLoyalty())) > 0) {
            return true;
        }
        return entityAllowList.contains(entityId);
    }

    private static boolean hasLanded(class_1297 entity) {
        if (entity.method_24828() || entity.method_5799() || entity.method_5771()) {
            return true;
        }
        class_2680 landedOnState = entity.method_73183().method_8320(entity.method_24515());
        return FALL_CATCHING_BLOCKS.contains(landedOnState.method_26204());
    }

    private static boolean isOrMayFly(class_1297 entity) {
        class_1309 livingEntity;
        if (entity instanceof class_1309 && (livingEntity = (class_1309)entity).method_6128()) {
            return true;
        }
        if (!(entity instanceof class_1657)) {
            return false;
        }
        class_1657 player = (class_1657)entity;
        return player.method_31549().field_7479 || player.method_31549().field_7478;
    }

    public static void onLivingEntityFall(LivingFallEvent event) {
        class_2487 persistentData;
        class_1309 entity = event.getEntity();
        if (ForgivingVoid.isAllowedEntity((class_1297)entity) && (persistentData = Balm.getHooks().getPersistentData((class_1297)entity)).method_68566("ForgivingVoidIsFalling", false)) {
            ForgivingVoidConfig config = ForgivingVoidConfig.getActive();
            float damage = ForgivingVoid.calculateFallDamage(config, entity);
            event.setFallDamageOverride(Float.valueOf(damage));
            if (entity instanceof ServerPlayerAccessor) {
                ServerPlayerAccessor player = (ServerPlayerAccessor)entity;
                player.setIsChangingDimension(false);
            }
        }
    }

    private static float calculateFallDamage(ForgivingVoidConfig config, class_1309 entity) {
        float damage = config.damageOnFall;
        if (config.damageOnFallMode != DamageOnFallMode.ABSOLUTE && damage > 1.0f) {
            damage /= 100.0f;
        }
        if (config.damageOnFallMode == DamageOnFallMode.RELATIVE_CURRENT) {
            damage = entity.method_6032() * damage;
        } else if (config.damageOnFallMode == DamageOnFallMode.RELATIVE_MAX) {
            damage = entity.method_6063() * damage;
        }
        if (config.preventDeath && entity.method_6032() - damage <= 0.0f) {
            damage = entity.method_6032() - 1.0f;
        }
        return damage;
    }

    private static boolean fireForgivingVoidEvent(class_1297 entity) {
        ForgivingVoidFallThroughEvent event = new ForgivingVoidFallThroughEvent(entity);
        Balm.getEvents().fireEvent((Object)event);
        return !event.isCanceled();
    }

    private static boolean isEnabledForDimension(class_5321<class_1937> dimensionKey) {
        if (dimensionKey == class_1937.field_25179) {
            return ForgivingVoidConfig.getActive().triggerInOverworld;
        }
        if (dimensionKey == class_1937.field_25181) {
            return ForgivingVoidConfig.getActive().triggerInEnd;
        }
        if (dimensionKey == class_1937.field_25180) {
            return ForgivingVoidConfig.getActive().triggerInNether;
        }
        class_2960 dimension = dimensionKey.method_29177();
        Set<class_2960> dimensionAllowList = ForgivingVoidConfig.getActive().dimensionAllowList;
        Set<class_2960> dimensionDenyList = ForgivingVoidConfig.getActive().dimensionDenyList;
        if (!dimensionAllowList.isEmpty() && !dimensionAllowList.contains(dimension)) {
            return false;
        }
        return !dimensionDenyList.contains(dimension);
    }

    private static /* synthetic */ void lambda$onEntityTick$0(class_1297 teleportedEntity) {
        if (ForgivingVoid.isAllowedEntity(teleportedEntity)) {
            if (teleportedEntity instanceof ServerPlayerAccessor) {
                ServerPlayerAccessor player = (ServerPlayerAccessor)teleportedEntity;
                player.setIsChangingDimension(true);
            }
            class_2487 teleportedEntityData = Balm.getHooks().getPersistentData(teleportedEntity);
            boolean returnToGrounded = ForgivingVoidConfig.getActive().returnToLastGrounded;
            class_2338 lastGroundedPos = teleportedEntityData.method_10537("LastGroundedPos").map(class_2338::method_10092).orElseGet(() -> ((class_1297)teleportedEntity).method_24515());
            double x = returnToGrounded ? (double)((float)lastGroundedPos.method_10263() + 0.5f) : teleportedEntity.method_23317();
            int y = ForgivingVoidConfig.getActive().fallingHeight;
            double z = returnToGrounded ? (double)((float)lastGroundedPos.method_10260() + 0.5f) : teleportedEntity.method_23321();
            teleportedEntity.method_5859(x, (double)y, z);
            teleportedEntityData.method_10556("ForgivingVoidIsFalling", true);
        }
    }
}

