/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.formations.tools.template.screen;

import com.supermartijn642.core.ClientUtils;
import com.supermartijn642.core.TextComponents;
import com.supermartijn642.core.gui.GuiGraphicsHelper;
import com.supermartijn642.core.gui.widget.BaseWidget;
import com.supermartijn642.core.gui.widget.Widget;
import com.supermartijn642.core.gui.widget.WidgetRenderContext;
import com.supermartijn642.core.gui.widget.premade.TextFieldWidget;
import com.supermartijn642.core.network.BasePacket;
import com.supermartijn642.formations.Formations;
import com.supermartijn642.formations.FormationsDev;
import com.supermartijn642.formations.tools.template.Template;
import com.supermartijn642.formations.tools.template.TemplateManager;
import com.supermartijn642.formations.tools.template.TemplateRenderer;
import com.supermartijn642.formations.tools.template.packets.CreateTemplatePacket;
import com.supermartijn642.formations.tools.template.packets.DeleteTemplatePacket;
import com.supermartijn642.formations.tools.template.screen.TemplateEditButton;
import net.minecraft.class_1074;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_327;
import net.minecraft.class_5250;
import net.minecraft.class_5348;

public class TemplateEditingScreen
extends BaseWidget {
    private static final class_2960 SCREEN_BACKGROUND = Formations.location("textures/gui/template_creation_screen.png");
    private final Template template;
    private TemplateEditButton saveButton;

    public TemplateEditingScreen(Template template) {
        super(0, 0, 144, 166);
        this.template = template;
    }

    public class_2561 getNarrationMessage() {
        return this.template == null ? TextComponents.translation((String)"formations.template.edit.new_template").get() : TextComponents.translation((String)"formations.template.edit.edit_template").get();
    }

    public void addWidgets() {
        if (this.template == null) {
            TextFieldWidget nameField = new TextFieldWidget(8, 32, 128, 12, "", 50, t -> {
                this.saveButton.active = Template.isValidName(t) && TemplateManager.get(ClientUtils.getWorld()).getTemplateByName(t.trim()) == null;
            });
            nameField.setSuggestion(class_1074.method_4662((String)"formations.template.edit.name_hint", (Object[])new Object[0]));
            this.addWidget((Widget)nameField);
            this.addWidget((Widget)new TemplateEditButton(0, 151, 72, 15, (class_2561)TextComponents.translation((String)"formations.template.edit.cancel").get(), TemplateEditButton.LEFT_BUTTON, () -> {
                TemplateRenderer.selectionDimension = null;
                ClientUtils.getMinecraft().method_1507(null);
            }));
            this.saveButton = new TemplateEditButton(72, 151, 72, 15, (class_2561)TextComponents.translation((String)"formations.template.edit.save").get(), TemplateEditButton.GREEN_RIGHT_BUTTON, () -> {
                String name = nameField.getText().trim();
                if (Template.isValidName(name) && TemplateManager.get(ClientUtils.getWorld()).getTemplateByName(name) == null) {
                    FormationsDev.CHANNEL.sendToServer((BasePacket)new CreateTemplatePacket(Template.create(new class_238(TemplateRenderer.selectionPos1).method_991(new class_238(TemplateRenderer.selectionPos2)), name)));
                    TemplateRenderer.selectionDimension = null;
                    ClientUtils.getMinecraft().method_1507(null);
                }
            });
            this.saveButton.active = false;
            this.addWidget((Widget)this.saveButton);
        } else {
            TextFieldWidget nameField = new TextFieldWidget(8, 32, 128, 12, this.template.getName(), 50, t -> {
                this.saveButton.active = Template.isValidName(t) && (t.trim().equals(this.template.getName()) || TemplateManager.get(ClientUtils.getWorld()).getTemplateByName(t.trim()) == null);
            });
            nameField.setSuggestion(class_1074.method_4662((String)"formations.template.edit.name_hint", (Object[])new Object[0]));
            this.addWidget((Widget)nameField);
            this.addWidget((Widget)new TemplateEditButton(0, 151, 72, 15, (class_2561)TextComponents.translation((String)"formations.template.edit.delete").get(), TemplateEditButton.RED_LEFT_BUTTON, () -> {
                FormationsDev.CHANNEL.sendToServer((BasePacket)new DeleteTemplatePacket(this.template));
                ClientUtils.getMinecraft().method_1507(null);
            }));
            this.saveButton = new TemplateEditButton(72, 151, 72, 15, (class_2561)TextComponents.translation((String)"formations.template.edit.confirm").get(), TemplateEditButton.RIGHT_BUTTON, () -> {
                String name = nameField.getText().trim();
                if (name.equals(this.template.getName())) {
                    ClientUtils.getMinecraft().method_1507(null);
                } else if (Template.isValidName(name) && TemplateManager.get(ClientUtils.getWorld()).getTemplateByName(name) == null) {
                    FormationsDev.CHANNEL.sendToServer((BasePacket)new CreateTemplatePacket(Template.create(this.template.getArea(), name)));
                    ClientUtils.getMinecraft().method_1507(null);
                }
            });
            this.saveButton.active = true;
            this.addWidget((Widget)this.saveButton);
        }
    }

    public void renderBackground(WidgetRenderContext context, GuiGraphicsHelper graphics, int mouseX, int mouseY) {
        graphics.submitTexture(SCREEN_BACKGROUND, (float)this.left(), (float)this.top(), (float)this.width, (float)this.height);
        super.renderBackground(context, graphics, mouseX, mouseY);
    }

    public void renderForeground(WidgetRenderContext context, GuiGraphicsHelper graphics, int mouseX, int mouseY) {
        super.renderForeground(context, graphics, mouseX, mouseY);
        class_238 area = this.template == null ? new class_238(TemplateRenderer.selectionPos1).method_991(new class_238(TemplateRenderer.selectionPos2)) : this.template.getArea();
        class_243 center = area.method_1005();
        graphics.submitText((class_5348)TextComponents.translation((String)"formations.template.edit.new_template").get(), 72.0f, 3.0f, p -> p.shadow().activeColor().centerHorizontally());
        graphics.submitText((class_5348)TextComponents.translation((String)"formations.template.edit.name").get(), 32.0f, 22.0f, p -> p.centerHorizontally());
        graphics.submitText((class_5348)TextComponents.translation((String)"formations.template.edit.location").get(), 32.0f, 51.0f, p -> p.centerHorizontally());
        graphics.submitText((class_5348)TextComponents.translation((String)"formations.template.edit.location.x").get(), 10.0f, 63.0f);
        graphics.submitText((class_5348)TextComponents.translation((String)"formations.template.edit.location.y").get(), 10.0f, 74.0f);
        graphics.submitText((class_5348)TextComponents.translation((String)"formations.template.edit.location.z").get(), 10.0f, 85.0f);
        class_327 font = ClientUtils.getFontRenderer();
        class_5250 posX = TextComponents.number((double)center.field_1352, (int)1).get();
        class_5250 posY = TextComponents.number((double)center.field_1351, (int)1).get();
        class_5250 posZ = TextComponents.number((double)center.field_1350, (int)1).get();
        graphics.submitText((class_5348)posX, (float)(132 - font.method_27525((class_5348)posX)), 63.0f);
        graphics.submitText((class_5348)posY, (float)(132 - font.method_27525((class_5348)posY)), 74.0f);
        graphics.submitText((class_5348)posZ, (float)(132 - font.method_27525((class_5348)posZ)), 85.0f);
        graphics.submitText((class_5348)TextComponents.translation((String)"formations.template.edit.size").get(), 32.0f, 101.0f, p -> p.centerHorizontally());
        graphics.submitText((class_5348)TextComponents.translation((String)"formations.template.edit.size.x").get(), 10.0f, 113.0f);
        graphics.submitText((class_5348)TextComponents.translation((String)"formations.template.edit.size.y").get(), 10.0f, 124.0f);
        graphics.submitText((class_5348)TextComponents.translation((String)"formations.template.edit.size.z").get(), 10.0f, 135.0f);
        class_5250 sizeX = TextComponents.number((int)((int)area.method_17939())).get();
        class_5250 sizeY = TextComponents.number((int)((int)area.method_17940())).get();
        class_5250 sizeZ = TextComponents.number((int)((int)area.method_17941())).get();
        graphics.submitText((class_5348)sizeX, (float)(132 - font.method_27525((class_5348)sizeX)), 113.0f);
        graphics.submitText((class_5348)sizeY, (float)(132 - font.method_27525((class_5348)sizeY)), 124.0f);
        graphics.submitText((class_5348)sizeZ, (float)(132 - font.method_27525((class_5348)sizeZ)), 135.0f);
    }
}

