/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.formations.structure.processors;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.supermartijn642.formations.FormationsStructures;
import com.supermartijn642.formations.structure.BlockInstance;
import com.supermartijn642.formations.structure.FormationsStructureProcessor;
import java.util.Map;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3491;
import net.minecraft.class_3492;
import net.minecraft.class_3828;
import net.minecraft.class_4538;
import net.minecraft.class_4969;
import org.jetbrains.annotations.NotNull;

public class RespawnAnchorProcessor
extends class_3491
implements FormationsStructureProcessor {
    public static final MapCodec<RespawnAnchorProcessor> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.intRange((int)0, (int)4).optionalFieldOf("minCharges", (Object)0).forGetter(p -> p.minCharges), (App)Codec.intRange((int)0, (int)4).optionalFieldOf("maxCharges", (Object)4).forGetter(p -> p.maxCharges)).apply((Applicative)instance, RespawnAnchorProcessor::new)).validate(processor -> {
        if (processor.minCharges > processor.maxCharges) {
            return DataResult.error(() -> "Max charges must be greater than or equal to min charges, minCharges: " + processor.minCharges + ", maxCharges: " + processor.maxCharges);
        }
        return DataResult.success((Object)processor);
    });
    private final int minCharges;
    private final int maxCharges;

    public RespawnAnchorProcessor(int minCharges, int maxCharges) {
        this.minCharges = minCharges;
        this.maxCharges = maxCharges;
    }

    public RespawnAnchorProcessor() {
        this(0, 4);
    }

    @Override
    @NotNull
    public BlockInstance processBlock(BlockInstance block, class_2338 pos, class_4538 level, class_2338 piecePosition, class_2338 structurePosition, class_3492 placeSettings, Map<class_2338, BlockInstance> pieceBlocks) {
        if (block.state() != null && block.state().method_27852(class_2246.field_23152)) {
            int charges = this.minCharges + placeSettings.method_15115(pos).method_43048(this.maxCharges - this.minCharges);
            return new BlockInstance((class_2680)block.state().method_11657((class_2769)class_4969.field_23153, (Comparable)Integer.valueOf(charges)), block.nbt());
        }
        return block;
    }

    protected class_3828<?> method_16772() {
        return FormationsStructures.RESPAWN_ANCHOR_PROCESSOR;
    }
}

