/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.formations.structure;

import com.google.common.collect.Lists;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.supermartijn642.formations.FormationsStructures;
import com.supermartijn642.formations.structure.StructurePlacement;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_2338;
import net.minecraft.class_2378;
import net.minecraft.class_238;
import net.minecraft.class_247;
import net.minecraft.class_2470;
import net.minecraft.class_259;
import net.minecraft.class_265;
import net.minecraft.class_2794;
import net.minecraft.class_2919;
import net.minecraft.class_3195;
import net.minecraft.class_3341;
import net.minecraft.class_3443;
import net.minecraft.class_3485;
import net.minecraft.class_3777;
import net.minecraft.class_3778;
import net.minecraft.class_3784;
import net.minecraft.class_3785;
import net.minecraft.class_3790;
import net.minecraft.class_5539;
import net.minecraft.class_5819;
import net.minecraft.class_6626;
import net.minecraft.class_6880;
import net.minecraft.class_7138;
import net.minecraft.class_7151;
import net.minecraft.class_7924;
import net.minecraft.class_8891;
import net.minecraft.class_9822;

public class PiecedStructure
extends class_3195 {
    public static final MapCodec<PiecedStructure> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)class_3195.class_7302.field_38430.forGetter(structure -> structure.field_38429), (App)class_3785.field_24954.fieldOf("start_pool").forGetter(structure -> structure.startPool), (App)Codec.intRange((int)0, (int)7).fieldOf("max_depth").forGetter(structure -> structure.maxDepth), (App)Codec.intRange((int)1, (int)128).fieldOf("max_distance_from_center").forGetter(structure -> structure.maxDistanceFromCenter), (App)StructurePlacement.CODEC.fieldOf("placement").forGetter(s -> s.placement)).apply((Applicative)instance, PiecedStructure::new));
    private final class_6880<class_3785> startPool;
    private final int maxDepth;
    private final int maxDistanceFromCenter;
    private final StructurePlacement placement;

    public PiecedStructure(class_3195.class_7302 settings, class_6880<class_3785> startPool, int maxDepth, int maxDistanceFromCenter, StructurePlacement placement) {
        super(settings);
        this.startPool = startPool;
        this.maxDepth = maxDepth;
        this.maxDistanceFromCenter = maxDistanceFromCenter;
        this.placement = placement;
    }

    protected Optional<class_3195.class_7150> method_38676(class_3195.class_7149 context) {
        class_3784 element = ((class_3785)this.startPool.comp_349()).method_16631((class_5819)context.comp_566());
        if (element == class_3777.field_16663) {
            return Optional.empty();
        }
        int x = context.comp_568().method_33939(context.comp_566().method_43048(16));
        int z = context.comp_568().method_33941(context.comp_566().method_43048(16));
        class_2470 rotation = class_2470.method_16548((class_5819)context.comp_566());
        class_3341 boundingBox = element.method_16628(context.comp_565(), new class_2338(x, 0, z), rotation);
        Optional<Integer> height = this.placement.findHeight(context, boundingBox);
        if (height.isEmpty()) {
            return Optional.empty();
        }
        class_2338 pos = new class_2338(x, height.get() + 1, z);
        return PiecedStructure.addPieces(context, element, rotation, this.maxDepth, pos, this.maxDistanceFromCenter);
    }

    public class_7151<?> method_41618() {
        return FormationsStructures.PIECED_STRUCTURE;
    }

    private static Optional<class_3195.class_7150> addPieces(class_3195.class_7149 context, class_3784 startElement, class_2470 rotation, int maxDepth, class_2338 pos, int maxDistanceFromCenter) {
        if (startElement == class_3777.field_16663) {
            return Optional.empty();
        }
        class_2794 chunkGenerator = context.comp_562();
        class_3485 templateManager = context.comp_565();
        class_5539 levelHeightAccessor = context.comp_569();
        class_2919 random = context.comp_566();
        class_2378 registry = context.comp_561().method_30530(class_7924.field_41249);
        class_3790 structurePiece = new class_3790(templateManager, startElement, pos, startElement.method_19308(), rotation, startElement.method_16628(templateManager, pos, rotation), class_9822.field_52238);
        class_3341 boundingBox = structurePiece.method_14935();
        int centeredX = (boundingBox.method_35418() + boundingBox.method_35415()) / 2;
        int centeredZ = (boundingBox.method_35420() + boundingBox.method_35417()) / 2;
        int heightOffset = boundingBox.method_35416() + structurePiece.method_16646();
        structurePiece.method_14922(0, pos.method_10264() - heightOffset, 0);
        class_2338 centeredPos = new class_2338(centeredX, pos.method_10264(), centeredZ);
        return Optional.of(new class_3195.class_7150(centeredPos, piecesBuilder -> {
            piecesBuilder.method_35462((class_3443)structurePiece);
            if (maxDepth <= 0) {
                return;
            }
            class_265 allowedSpace = class_259.method_1072((class_265)class_259.method_1078((class_238)new class_238(centeredPos).method_1014((double)maxDistanceFromCenter)), (class_265)class_259.method_1078((class_238)class_238.method_19316((class_3341)boundingBox)), (class_247)class_247.field_16886);
            ArrayList pieces = Lists.newArrayList();
            class_3778.method_27230((class_7138)context.comp_564(), (int)maxDepth, (boolean)false, (class_2794)chunkGenerator, (class_3485)templateManager, (class_5539)levelHeightAccessor, (class_5819)random, (class_2378)registry, (class_3790)structurePiece, (List)pieces, (class_265)allowedSpace, (class_8891)class_8891.field_46826, (class_9822)class_9822.field_52238);
            pieces.forEach(arg_0 -> ((class_6626)piecesBuilder).method_35462(arg_0));
        }));
    }
}

