/*
 * Decompiled with CFR 0.152.
 */
package dev.tr7zw.skinlayers.api;

import dev.tr7zw.skinlayers.api.BoxBuilder;
import dev.tr7zw.skinlayers.api.Mesh;
import dev.tr7zw.skinlayers.api.MeshHelper;
import dev.tr7zw.skinlayers.api.MeshProvider;
import dev.tr7zw.skinlayers.api.MeshTransformerProvider;
import dev.tr7zw.skinlayers.api.PlayerData;
import dev.tr7zw.skinlayers.render.CustomizableCubeListBuilder;
import dev.tr7zw.skinlayers.render.CustomizableModelPart;
import dev.tr7zw.skinlayers.util.NMSWrapper;
import dev.tr7zw.skinlayers.versionless.util.wrapper.SolidPixelWrapper;
import java.util.Collections;
import lombok.Generated;
import net.minecraft.class_1011;
import net.minecraft.class_742;

public final class SkinLayersAPI {
    private static final MeshHelper meshHelper = new MeshHelperImplementation();
    private static final MeshProvider meshProvider = new MeshProviderImplementation();
    private static MeshTransformerProvider meshTransformerProvider = MeshTransformerProvider.EMPTY_PROVIDER;
    private static BoxBuilder boxBuilder = BoxBuilder.DEFAULT;

    public static void setupBoxBuilder(BoxBuilder builder) {
        boxBuilder = builder;
    }

    public static void setupMeshTransformerProvider(MeshTransformerProvider provider) {
        meshTransformerProvider = provider;
    }

    public static MeshTransformerProvider getMeshTransformerProvider() {
        return meshTransformerProvider;
    }

    @Generated
    private SkinLayersAPI() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    @Generated
    public static MeshHelper getMeshHelper() {
        return meshHelper;
    }

    @Generated
    public static MeshProvider getMeshProvider() {
        return meshProvider;
    }

    @Generated
    public static BoxBuilder getBoxBuilder() {
        return boxBuilder;
    }

    private static class MeshHelperImplementation
    implements MeshHelper {
        private MeshHelperImplementation() {
        }

        @Override
        public Mesh create3DMesh(class_1011 natImage, int width, int height, int depth, int textureU, int textureV, boolean topPivot, float rotationOffset, boolean mirror) {
            CustomizableCubeListBuilder builder = new CustomizableCubeListBuilder();
            builder.mirror(mirror);
            if (SolidPixelWrapper.wrapBox(builder, new NMSWrapper.WrappedNativeImage(natImage), width, height, depth, textureU, textureV, topPivot, rotationOffset) != null) {
                return new CustomizableModelPart(builder.getVanillaCubes(), builder.getCubes(), Collections.emptyMap());
            }
            return Mesh.EMPTY;
        }

        @Override
        public Mesh create3DMesh(class_1011 natImage, int width, int height, int depth, int textureU, int textureV, boolean topPivot, float rotationOffset) {
            return this.create3DMesh(natImage, width, height, depth, textureU, textureV, topPivot, rotationOffset, false);
        }
    }

    private static class MeshProviderImplementation
    implements MeshProvider {
        private MeshProviderImplementation() {
        }

        @Override
        public PlayerData getPlayerMesh(class_742 abstractClientPlayerEntity) {
            if (abstractClientPlayerEntity instanceof PlayerData) {
                return (PlayerData)abstractClientPlayerEntity;
            }
            return null;
        }
    }
}

