/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.core.network;

import com.supermartijn642.core.ClientUtils;
import com.supermartijn642.core.CommonUtils;
import com.supermartijn642.core.CoreLib;
import com.supermartijn642.core.CoreSide;
import com.supermartijn642.core.network.BasePacket;
import com.supermartijn642.core.network.PacketContext;
import com.supermartijn642.core.network.PacketDirection;
import com.supermartijn642.core.registry.RegistryUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import net.fabricmc.fabric.api.client.networking.v1.ClientConfigurationNetworking;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.networking.v1.PayloadTypeRegistry;
import net.fabricmc.fabric.api.networking.v1.PlayerLookup;
import net.fabricmc.fabric.api.networking.v1.ServerConfigurationNetworking;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2535;
import net.minecraft.class_2540;
import net.minecraft.class_2547;
import net.minecraft.class_2598;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3244;
import net.minecraft.class_5321;
import net.minecraft.class_8610;
import net.minecraft.class_8710;
import net.minecraft.class_9139;
import net.minecraft.server.MinecraftServer;

public class PacketChannel {
    private final String modid;
    private final String name;
    private final class_2960 channelName;
    private final class_8710.class_9154<Payload> payloadType;
    private final List<PacketProperties<?>> packetsByIndex = new ArrayList();
    private final Map<Class<? extends BasePacket>, PacketProperties<?>> packetsByClass = new HashMap();

    public static PacketChannel create(String modid, String channelName) {
        if (!RegistryUtil.isValidNamespace(modid)) {
            throw new IllegalArgumentException("Modid '" + modid + "' must only contain characters [a-z0-9_.-]!");
        }
        if (!RegistryUtil.isValidNamespace(channelName)) {
            throw new IllegalArgumentException("Channel name '" + channelName + "' must only contain characters [a-z0-9_.-]!");
        }
        if (modid.equals("minecraft")) {
            CoreLib.LOGGER.warn("Mod is requesting registration helper for modid '{}'!", (Object)modid);
        } else {
            ModContainer container = FabricLoader.getInstance().getModContainer(modid).orElse(null);
            if (container == null) {
                CoreLib.LOGGER.warn("Mod is requesting registration helper for unknown modid '{}'!", (Object)modid);
            }
        }
        return new PacketChannel(modid, channelName);
    }

    public static PacketChannel create(String modid) {
        return PacketChannel.create(modid, "main");
    }

    private PacketChannel(String modid, String name) {
        this.modid = modid;
        this.name = name;
        this.channelName = class_2960.method_60655((String)modid, (String)name);
        this.payloadType = new class_8710.class_9154(this.channelName);
        class_9139 s2cPayloadCodec = class_9139.method_56437((buffer, payload) -> this.write(payload.packet, (class_2540)buffer), buffer -> new Payload(this.read((class_2540)buffer, PacketDirection.SERVER_TO_CLIENT)));
        class_9139 c2sPayloadCodec = class_9139.method_56437((buffer, payload) -> this.write(payload.packet, (class_2540)buffer), buffer -> new Payload(this.read((class_2540)buffer, PacketDirection.CLIENT_TO_SERVER)));
        PayloadTypeRegistry.configurationS2C().register(this.payloadType, s2cPayloadCodec);
        if (CommonUtils.getEnvironmentSide().isClient()) {
            ClientConfigurationNetworking.registerGlobalReceiver(this.payloadType, (payload, context) -> this.handle(payload.packet, new PacketContext(CoreSide.CLIENT, null, null)));
        }
        PayloadTypeRegistry.configurationC2S().register(this.payloadType, c2sPayloadCodec);
        ServerConfigurationNetworking.registerGlobalReceiver(this.payloadType, (payload, context) -> this.handle(payload.packet, new PacketContext(CoreSide.SERVER, null, context.server())));
        PayloadTypeRegistry.playS2C().register(this.payloadType, s2cPayloadCodec);
        if (CommonUtils.getEnvironmentSide().isClient()) {
            new Runnable(){

                @Override
                public void run() {
                    ClientPlayNetworking.registerGlobalReceiver(PacketChannel.this.payloadType, (payload, context) -> PacketChannel.this.handle(payload.packet, new PacketContext(CoreSide.CLIENT, (class_1657)context.player(), null)));
                }
            }.run();
        }
        PayloadTypeRegistry.playC2S().register(this.payloadType, c2sPayloadCodec);
        ServerPlayNetworking.registerGlobalReceiver(this.payloadType, (payload, context) -> this.handle(payload.packet, new PacketContext(CoreSide.SERVER, (class_1657)context.player(), context.server())));
    }

    public <T extends BasePacket> void registerMessage(Class<T> packetClass, Supplier<T> packetSupplier, PacketDirection direction, boolean shouldBeQueued) {
        if (this.packetsByClass.containsKey(packetClass)) {
            throw new IllegalArgumentException("Class '" + String.valueOf(packetClass) + "' has already been registered!");
        }
        int index = this.packetsByIndex.size();
        PacketProperties<T> properties = new PacketProperties<T>(index, packetClass, packetSupplier, direction, shouldBeQueued);
        this.packetsByIndex.add(properties);
        this.packetsByClass.put(packetClass, properties);
    }

    @Deprecated
    public <T extends BasePacket> void registerMessage(Class<T> packetClass, Supplier<T> packetSupplier, boolean shouldBeQueued) {
        this.registerMessage(packetClass, packetSupplier, PacketDirection.BOTH_WAYS, shouldBeQueued);
    }

    public void sendToServer(BasePacket packet) {
        this.checkRegistration(packet, PacketDirection.CLIENT_TO_SERVER);
        if (ClientUtils.getPlayer() != null) {
            ClientPlayNetworking.send((class_8710)new Payload(packet));
        } else {
            ClientConfigurationNetworking.send((class_8710)new Payload(packet));
        }
    }

    public void sendToClient(class_2535 connection, BasePacket packet) {
        this.checkRegistration(packet, PacketDirection.SERVER_TO_CLIENT);
        if (connection.method_36121() == class_2598.field_11942) {
            throw new IllegalArgumentException("This must only be called server-side!");
        }
        class_2547 class_25472 = connection.method_10744();
        if (class_25472 instanceof class_8610) {
            class_8610 listener = (class_8610)class_25472;
            ServerConfigurationNetworking.send((class_8610)listener, (class_8710)new Payload(packet));
        } else {
            class_25472 = connection.method_10744();
            if (class_25472 instanceof class_3244) {
                class_3244 listener = (class_3244)class_25472;
                ServerPlayNetworking.getSender((class_3244)listener).sendPacket((class_8710)new Payload(packet));
            } else {
                throw new IllegalArgumentException("Cannot send packet during the current network stage!");
            }
        }
    }

    public void sendToPlayer(class_1657 player, BasePacket packet) {
        if (!(player instanceof class_3222)) {
            throw new IllegalStateException("This must only be called server-side!");
        }
        this.checkRegistration(packet, PacketDirection.SERVER_TO_CLIENT);
        ServerPlayNetworking.send((class_3222)((class_3222)player), (class_8710)new Payload(packet));
    }

    public void sendToAllPlayers(BasePacket packet) {
        this.checkRegistration(packet, PacketDirection.SERVER_TO_CLIENT);
        PlayerLookup.all((MinecraftServer)CommonUtils.getServer()).forEach(player -> this.sendToPlayer((class_1657)player, packet));
    }

    public void sendToDimension(class_5321<class_1937> dimension, BasePacket packet) {
        this.sendToDimension(CommonUtils.getLevel(dimension), packet);
    }

    public void sendToDimension(class_1937 world, BasePacket packet) {
        if (world.method_8608()) {
            throw new IllegalStateException("This must only be called server-side!");
        }
        this.checkRegistration(packet, PacketDirection.SERVER_TO_CLIENT);
        PlayerLookup.world((class_3218)((class_3218)world)).forEach(player -> this.sendToPlayer((class_1657)player, packet));
    }

    public void sendToAllTrackingEntity(class_1297 entity, BasePacket packet) {
        if (entity.method_73183().method_8608()) {
            throw new IllegalStateException("This must only be called server-side!");
        }
        this.checkRegistration(packet, PacketDirection.SERVER_TO_CLIENT);
        PlayerLookup.tracking((class_1297)entity).forEach(player -> this.sendToPlayer((class_1657)player, packet));
    }

    public void sendToAllNear(class_5321<class_1937> world, double x, double y, double z, double radius, BasePacket packet) {
        this.sendToAllNear(CommonUtils.getLevel(world), x, y, z, radius, packet);
    }

    public void sendToAllNear(class_5321<class_1937> world, class_2338 pos, double radius, BasePacket packet) {
        this.sendToAllNear(CommonUtils.getLevel(world), pos, radius, packet);
    }

    public void sendToAllNear(class_1937 world, double x, double y, double z, double radius, BasePacket packet) {
        if (!(world instanceof class_3218)) {
            throw new IllegalStateException("This must only be called server-side!");
        }
        this.checkRegistration(packet, PacketDirection.SERVER_TO_CLIENT);
        PlayerLookup.around((class_3218)((class_3218)world), (class_243)new class_243(x, y, z), (double)radius).forEach(player -> this.sendToPlayer((class_1657)player, packet));
    }

    public void sendToAllNear(class_1937 world, class_2338 pos, double radius, BasePacket packet) {
        if (world.method_8608()) {
            throw new IllegalStateException("This must only be called server-side!");
        }
        this.sendToAllNear(world, (double)pos.method_10263() + 0.5, (double)pos.method_10264() + 0.5, (double)pos.method_10260() + 0.5, radius, packet);
    }

    private void checkRegistration(BasePacket packet, PacketDirection direction) {
        PacketProperties<?> properties = this.packetsByClass.get(packet.getClass());
        if (properties == null) {
            throw new IllegalArgumentException("Tried to send unregistered packet '" + String.valueOf(packet.getClass()) + "' on channel '" + this.modid + ":" + this.name + "'!");
        }
        if (properties.direction != PacketDirection.BOTH_WAYS && properties.direction != direction) {
            throw new IllegalArgumentException("Tried to send packet '" + String.valueOf(packet.getClass()) + "' on channel '" + this.modid + ":" + this.name + "' in invalid direction '" + String.valueOf((Object)direction) + "'!");
        }
    }

    void write(BasePacket packet, class_2540 buffer) {
        int index = this.packetsByClass.get(packet.getClass()).index;
        buffer.method_53002(index);
        try {
            packet.write(buffer);
        }
        catch (Exception e) {
            throw new RuntimeException("Encountered an exception whilst writing packet of class '" + packet.getClass().getName() + "' for channel '" + this.modid + ":" + this.name + "'!", e);
        }
    }

    BasePacket read(class_2540 buffer, PacketDirection direction) {
        int index = buffer.readInt();
        if (this.packetsByIndex.size() < index) {
            throw new RuntimeException("Received an unregistered packet with index '" + index + "' on channel '" + this.modid + ":" + this.name + "'!");
        }
        PacketProperties<?> properties = this.packetsByIndex.get(index);
        if (properties.direction != PacketDirection.BOTH_WAYS && properties.direction != direction) {
            throw new RuntimeException("Received packet of class '" + String.valueOf(properties.clazz) + "' on channel '" + this.modid + ":" + this.name + "' for invalid direction '" + String.valueOf((Object)(direction == PacketDirection.CLIENT_TO_SERVER ? PacketDirection.SERVER_TO_CLIENT : PacketDirection.CLIENT_TO_SERVER)) + "'!");
        }
        BasePacket packet = (BasePacket)properties.supplier().get();
        try {
            packet.read(buffer);
        }
        catch (Exception e) {
            throw new RuntimeException("Encountered an exception whilst reading packet of class '" + packet.getClass().getName() + "' for channel '" + this.modid + ":" + this.name + "'!", e);
        }
        return packet;
    }

    void handle(BasePacket packet, PacketContext context) {
        try {
            boolean verify = packet.verify(context);
            if (!verify) {
                return;
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Encountered an exception whilst verifying packet of class '" + packet.getClass().getName() + "' for channel '" + this.modid + ":" + this.name + "'!", e);
        }
        Runnable handle = () -> {
            try {
                packet.handle(context);
            }
            catch (Exception e) {
                throw new RuntimeException("Encountered an exception whilst processing packet of class '" + packet.getClass().getName() + "' for channel '" + this.modid + ":" + this.name + "'!", e);
            }
        };
        PacketProperties<?> properties = this.packetsByClass.get(packet.getClass());
        if (properties.shouldBeQueued) {
            context.queueTask(handle);
        } else {
            handle.run();
        }
    }

    private record PacketProperties<T extends BasePacket>(int index, Class<T> clazz, Supplier<T> supplier, PacketDirection direction, boolean shouldBeQueued) {
    }

    private class Payload
    implements class_8710 {
        private final BasePacket packet;

        private Payload(BasePacket packet) {
            this.packet = packet;
        }

        public class_8710.class_9154<?> method_56479() {
            return PacketChannel.this.payloadType;
        }
    }
}

