/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.core.gui.widget.premade;

import com.supermartijn642.core.TextComponents;
import com.supermartijn642.core.gui.CursorTypes;
import com.supermartijn642.core.gui.GuiGraphicsHelper;
import com.supermartijn642.core.gui.widget.BaseWidget;
import com.supermartijn642.core.gui.widget.WidgetRenderContext;
import com.supermartijn642.core.util.Holder;
import java.util.function.DoubleConsumer;
import java.util.function.DoubleSupplier;
import net.minecraft.class_11875;
import net.minecraft.class_11910;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import org.jetbrains.annotations.ApiStatus;

public class ScrollbarWidget
extends BaseWidget {
    @ApiStatus.Internal
    public static final class_2960 BACKGROUND = class_2960.method_60655((String)"supermartijn642corelib", (String)"gui/scrollbar_background");
    @ApiStatus.Internal
    public static final class_2960 SCROLLER = class_2960.method_60655((String)"supermartijn642corelib", (String)"gui/scroller");
    private final int scrollerHeight;
    private final DoubleSupplier value;
    private final DoubleSupplier minValue;
    private final DoubleSupplier maxValue;
    private final boolean invertScrolling;
    private final Double stepSize;
    private final ScrollListener onChange;
    private final Double scrollerSpeed;
    private final boolean smoothValues;
    private final class_2960 background;
    private final class_2960 scroller;
    private final Double scrollWheelStep;
    private float scrollerPosition = 0.0f;
    private boolean dragging = false;
    private boolean active = true;
    private boolean scrollable = true;

    public static Builder builder(int height) {
        return new Builder(height);
    }

    private ScrollbarWidget(int x, int y, int width, int height, int scrollerHeight, DoubleSupplier value, DoubleSupplier minValue, DoubleSupplier maxValue, boolean invertScrolling, Double stepSize, ScrollListener onChange, Integer scrollerSpeed, boolean smoothValues, class_2960 background, class_2960 scroller, Double scrollWheelStep) {
        super(x, y, width, height);
        this.scrollerHeight = scrollerHeight;
        this.value = value;
        this.minValue = minValue;
        this.maxValue = maxValue;
        this.invertScrolling = invertScrolling;
        this.stepSize = stepSize;
        this.onChange = onChange;
        this.scrollWheelStep = scrollWheelStep;
        this.scrollerSpeed = scrollerSpeed == null ? null : Double.valueOf((double)scrollerSpeed.intValue() / (double)(height - scrollerHeight));
        this.smoothValues = smoothValues;
        this.background = background;
        this.scroller = scroller;
    }

    public void setActive(boolean active) {
        this.active = active;
    }

    public void setScrollable(boolean scrollable) {
        this.scrollable = scrollable;
    }

    private boolean canUserMoveScroller() {
        return this.scrollable && this.maxValue.getAsDouble() > this.minValue.getAsDouble();
    }

    @Override
    public class_2561 getNarrationMessage() {
        return TextComponents.translation("supermartijn642corelib.widgets.scrollbar.narration").get();
    }

    @Override
    public void renderBackground(WidgetRenderContext context, GuiGraphicsHelper graphics, int mouseX, int mouseY) {
        if (this.dragging) {
            if (!this.canUserMoveScroller()) {
                this.dragging = false;
            } else {
                this.updateDrag(mouseY);
                graphics.requestCursor(CursorTypes.resizeVertical());
            }
        }
        super.renderBackground(context, graphics, mouseX, mouseY);
        if (this.background != null) {
            graphics.submitSprite(this.background, (float)(this.x - 1), (float)(this.y - 1), (float)(this.width + 2), (float)(this.height + 2));
        }
    }

    @Override
    public void render(WidgetRenderContext context, GuiGraphicsHelper graphics, int mouseX, int mouseY) {
        double min = this.minValue.getAsDouble();
        double max = this.maxValue.getAsDouble();
        double range = max - min;
        if (range <= 0.0 || !this.active) {
            graphics.submitSprite(this.scroller, (float)this.x, (float)this.y, (float)this.width, (float)this.scrollerHeight, p -> p.uv(0.0f, 0.6666667f, 1.0f, 0.33333334f));
            return;
        }
        double value = Math.clamp(this.value.getAsDouble() - min, 0.0, range);
        if (this.stepSize != null) {
            value = (double)Math.round(value / this.stepSize) * this.stepSize;
        }
        float targetPosition = (float)(value / range);
        if (this.invertScrolling) {
            targetPosition = 1.0f - targetPosition;
        }
        this.scrollerPosition = this.scrollerSpeed != null ? (float)Math.clamp((double)targetPosition, (double)this.scrollerPosition - this.scrollerSpeed, (double)this.scrollerPosition + this.scrollerSpeed) : targetPosition;
        float offset = (float)(this.height - this.scrollerHeight) * this.scrollerPosition;
        graphics.submitSprite(this.scroller, (float)this.x, (float)this.y + offset, (float)this.width, (float)this.scrollerHeight, p -> p.uv(0.0f, this.scrollable && this.isFocused() ? 0.33333334f : 0.0f, 1.0f, 0.33333334f));
    }

    private void tryScrollTo(double targetPosition, boolean fromScrollWheel) {
        targetPosition = Math.clamp(targetPosition, 0.0, 1.0);
        if (this.smoothValues && !fromScrollWheel) {
            targetPosition = Math.clamp(targetPosition, (double)this.scrollerPosition - this.scrollerSpeed, (double)this.scrollerPosition + this.scrollerSpeed);
        }
        double min = this.minValue.getAsDouble();
        double max = this.maxValue.getAsDouble();
        double range = max - min;
        if (range <= 0.0) {
            return;
        }
        if (this.invertScrolling) {
            targetPosition = 1.0 - targetPosition;
        }
        double value = targetPosition * range + min;
        if (this.stepSize != null) {
            value = min + (double)Math.round((value - min) / this.stepSize) * this.stepSize;
        }
        double oldValue = Math.clamp(this.value.getAsDouble(), min, max);
        this.onChange.onChange(oldValue, value);
    }

    private void updateDrag(int mouseY) {
        this.tryScrollTo(((float)(mouseY - this.y) - (float)this.scrollerHeight / 2.0f) / (float)(this.height - this.scrollerHeight), false);
    }

    @Override
    public class_11875 curser(int mouseX, int mouseY) {
        if (!this.active || !this.canUserMoveScroller()) {
            return null;
        }
        return this.dragging ? CursorTypes.resizeVertical() : CursorTypes.pointingHand();
    }

    @Override
    public boolean mousePressed(int mouseX, int mouseY, class_11910 info, boolean isDoubleClick, boolean hasBeenHandled) {
        if (this.active && this.canUserMoveScroller() && !hasBeenHandled && info.comp_4801() == 0 && this.isFocused()) {
            this.dragging = true;
            this.updateDrag(mouseY);
            hasBeenHandled = true;
        }
        return super.mousePressed(mouseX, mouseY, info, isDoubleClick, hasBeenHandled);
    }

    @Override
    public boolean mouseReleased(int mouseX, int mouseY, class_11910 info, boolean hasBeenHandled) {
        this.dragging = false;
        return super.mouseReleased(mouseX, mouseY, info, hasBeenHandled);
    }

    @Override
    public boolean mouseScrolled(int mouseX, int mouseY, double scrollAmount, boolean hasBeenHandled) {
        if (this.active && this.canUserMoveScroller() && !hasBeenHandled) {
            if (this.scrollWheelStep == null) {
                this.tryScrollTo((double)this.scrollerPosition - scrollAmount / 5.0, true);
            } else if (this.scrollWheelStep != 0.0) {
                double min = this.minValue.getAsDouble();
                double max = this.maxValue.getAsDouble();
                double range = max - min;
                if (range > 0.0) {
                    double value = Math.clamp(this.value.getAsDouble(), min, max);
                    if (this.invertScrolling) {
                        scrollAmount = -scrollAmount;
                    }
                    this.tryScrollTo(((value += scrollAmount * this.scrollWheelStep) - min) / range, true);
                }
            }
        }
        return super.mouseScrolled(mouseX, mouseY, scrollAmount, hasBeenHandled);
    }

    public static class Builder {
        private int x;
        private int y;
        private int width = 12;
        private int height;
        private int scrollerHeight = 15;
        private DoubleSupplier value;
        private DoubleSupplier minValue;
        private DoubleSupplier maxValue;
        private boolean invertScrolling;
        private Double stepSize;
        private ScrollListener onChange;
        private Integer scrollerSpeed;
        private boolean smoothValues;
        private class_2960 background = BACKGROUND;
        private class_2960 scroller = SCROLLER;
        private Double scrollWheelStep;

        private Builder(int height) {
            this.height = height;
            this.scrollRange(0.0, 0.0, 1.0);
        }

        public Builder position(int x, int y) {
            this.x = x;
            this.y = y;
            return this;
        }

        public Builder width(int width) {
            this.width = width;
            return this;
        }

        public Builder height(int height) {
            this.height = height;
            return this;
        }

        public Builder size(int width, int height) {
            this.width = width;
            this.height = height;
            return this;
        }

        public Builder scrollerHeight(int height) {
            this.scrollerHeight = height;
            return this;
        }

        public Builder scrollValue(DoubleSupplier value, DoubleSupplier min, DoubleSupplier max) {
            this.value = value;
            this.minValue = min;
            this.maxValue = max;
            return this;
        }

        public Builder scrollValue(DoubleSupplier value, double min, double max) {
            if (min > max) {
                throw new IllegalArgumentException("Minimum value must be smaller than maximum value!");
            }
            return this.scrollValue(value, () -> min, () -> max);
        }

        public Builder scrollRange(double initialValue, double min, double max) {
            if (initialValue < min || initialValue > max) {
                throw new IllegalArgumentException("Initial value must be between min and max value!");
            }
            Holder<Double> value = new Holder<Double>(initialValue);
            return this.scrollValue(value::get, min, max).onChange((double oldValue, double newValue) -> value.set(newValue));
        }

        public Builder scrollStepSize(double step) {
            this.stepSize = step;
            return this;
        }

        public Builder scrollerSpeed(int speed, boolean smoothValues) {
            this.scrollerSpeed = speed;
            this.smoothValues = smoothValues;
            return this;
        }

        public Builder smoothScrolling() {
            return this.scrollerSpeed(8, true);
        }

        public Builder onChange(ScrollListener onChange) {
            this.onChange = onChange;
            return this;
        }

        public Builder onChange(DoubleConsumer onChange) {
            return this.onChange((double oldValue, double newValue) -> onChange.accept(newValue));
        }

        public Builder background(class_2960 texture) {
            this.background = texture;
            return this;
        }

        public Builder noBackground() {
            return this.background(null);
        }

        public Builder scroller(class_2960 texture) {
            this.scroller = texture;
            return this;
        }

        public Builder scrollWheelValueChange(double step) {
            this.scrollWheelStep = step;
            return this;
        }

        public Builder invertScrolling() {
            this.invertScrolling = true;
            return this;
        }

        public ScrollbarWidget build() {
            if (this.scrollerHeight >= this.height) {
                throw new IllegalStateException("Scroller height must be smaller than the height of the scrollbar!");
            }
            return new ScrollbarWidget(this.x, this.y, this.width, this.height, this.scrollerHeight, this.value, this.minValue, this.maxValue, this.invertScrolling, this.stepSize, this.onChange, this.scrollerSpeed, this.smoothValues, this.background, this.scroller, this.scrollWheelStep);
        }
    }

    public static interface ScrollListener {
        public void onChange(double var1, double var3);
    }
}

