/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.core.gui;

import com.supermartijn642.core.ClientUtils;
import com.supermartijn642.core.TextComponents;
import com.supermartijn642.core.gui.GuiGraphicsHelper;
import com.supermartijn642.core.gui.widget.MutableWidgetRenderContext;
import com.supermartijn642.core.gui.widget.Widget;
import net.minecraft.class_11905;
import net.minecraft.class_11908;
import net.minecraft.class_11909;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import net.minecraft.class_437;

public class WidgetScreen<T extends Widget>
extends class_437 {
    private final MutableWidgetRenderContext widgetRenderContext = MutableWidgetRenderContext.create();
    protected final T widget;
    private boolean initialized = false;
    private boolean isPauseScreen = false;
    private boolean dragging = false;

    public static <T extends Widget> WidgetScreen<T> of(T widget) {
        return new WidgetScreen<T>(widget);
    }

    public static <T extends Widget> WidgetScreen<T> of(T widget, boolean isPauseScreen) {
        return new WidgetScreen<T>(widget, isPauseScreen);
    }

    public WidgetScreen(T widget, boolean isPauseScreen) {
        super((class_2561)TextComponents.empty().get());
        this.widget = widget;
        this.isPauseScreen = isPauseScreen;
    }

    public WidgetScreen(T widget) {
        this(widget, false);
    }

    protected void method_25426() {
        if (!this.initialized) {
            this.widget.initialize();
            this.initialized = true;
        }
    }

    public void method_25419() {
        this.widget.discard();
        super.method_25419();
    }

    public void method_25393() {
        this.widget.update();
    }

    public void method_25394(class_332 guiGraphics, int mouseX, int mouseY, float partialTicks) {
        this.widgetRenderContext.update(guiGraphics, partialTicks, this.field_22793, this.field_22787);
        int offsetX = (this.field_22789 - this.widget.width()) / 2;
        int offsetY = (this.field_22790 - this.widget.height()) / 2;
        mouseX -= offsetX;
        mouseY -= offsetY;
        guiGraphics.method_51448().pushMatrix();
        guiGraphics.method_51448().translate((float)offsetX, (float)offsetY);
        if (!this.dragging) {
            this.widget.setFocused(mouseX >= 0 && mouseX < this.widget.width() && mouseY >= 0 && mouseY < this.widget.height());
        }
        GuiGraphicsHelper helper = GuiGraphicsHelper.of(guiGraphics);
        this.widget.renderBackground(this.widgetRenderContext, helper, mouseX, mouseY);
        this.widget.render(this.widgetRenderContext, helper, mouseX, mouseY);
        this.widget.renderForeground(this.widgetRenderContext, helper, mouseX, mouseY);
        this.widget.renderOverlay(this.widgetRenderContext, helper, mouseX, mouseY);
        this.widget.renderTooltips(this.widgetRenderContext, helper, mouseX, mouseY);
        guiGraphics.method_51448().popMatrix();
    }

    public boolean method_25402(class_11909 event, boolean isDoubleClick) {
        int mouseY;
        this.dragging = true;
        int offsetX = (this.field_22789 - this.widget.width()) / 2;
        int offsetY = (this.field_22790 - this.widget.height()) / 2;
        int mouseX = (int)event.comp_4798() - offsetX;
        return this.widget.mousePressed(mouseX, mouseY = (int)event.comp_4799() - offsetY, event.comp_4800(), isDoubleClick, false) || super.method_25402(event, isDoubleClick);
    }

    public boolean method_25406(class_11909 event) {
        int mouseY;
        this.dragging = false;
        int offsetX = (this.field_22789 - this.widget.width()) / 2;
        int offsetY = (this.field_22790 - this.widget.height()) / 2;
        int mouseX = (int)event.comp_4798() - offsetX;
        return this.widget.mouseReleased(mouseX, mouseY = (int)event.comp_4799() - offsetY, event.comp_4800(), false) || super.method_25406(event);
    }

    public boolean method_25403(class_11909 event, double deltaX, double deltaY) {
        int mouseY;
        int offsetX = (this.field_22789 - this.widget.width()) / 2;
        int offsetY = (this.field_22790 - this.widget.height()) / 2;
        int mouseX = (int)event.comp_4798() - offsetX;
        return this.widget.mouseDragged(mouseX, mouseY = (int)event.comp_4799() - offsetY, event.comp_4800(), deltaX, deltaY, false) || super.method_25403(event, deltaX, deltaY);
    }

    public boolean method_25401(double mouseX, double mouseY, double horizontalAmount, double verticalAmount) {
        int offsetY;
        int offsetX = (this.field_22789 - this.widget.width()) / 2;
        return this.widget.mouseScrolled((int)(mouseX -= (double)offsetX), (int)(mouseY -= (double)(offsetY = (this.field_22790 - this.widget.height()) / 2)), verticalAmount, false) || super.method_25401(mouseX, mouseY, horizontalAmount, verticalAmount);
    }

    public boolean method_25404(class_11908 event) {
        if (this.widget.keyPressed(event, false)) {
            return true;
        }
        if (ClientUtils.getMinecraft().field_1690.field_1822.method_1417(event)) {
            this.method_25419();
            return true;
        }
        return super.method_25404(event);
    }

    public boolean method_16803(class_11908 event) {
        return this.widget.keyReleased(event, false) || super.method_16803(event);
    }

    public boolean method_25400(class_11905 event) {
        return this.widget.charTyped((char)event.comp_4793(), false) || super.method_25400(event);
    }

    public boolean method_25421() {
        return this.isPauseScreen;
    }

    public class_2561 method_25435() {
        class_2561 message = this.widget.getNarrationMessage();
        return message == null ? TextComponents.empty().get() : message;
    }
}

