/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.core.gui;

import com.supermartijn642.core.gui.CustomSlot;
import java.util.Iterator;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.function.ToIntFunction;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.SlottedStorage;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.fabricmc.fabric.api.transfer.v1.storage.StorageView;
import net.fabricmc.fabric.api.transfer.v1.storage.base.SingleSlotStorage;
import net.fabricmc.fabric.api.transfer.v1.transaction.Transaction;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.minecraft.class_1263;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1735;
import net.minecraft.class_1799;

public class CustomSlotImpl
extends class_1735
implements CustomSlot {
    private static final class_1263 EMPTY_CONTAINER = new class_1263(){

        public int method_5439() {
            return 0;
        }

        public boolean method_5442() {
            return true;
        }

        public class_1799 method_5438(int i) {
            return class_1799.field_8037;
        }

        public class_1799 method_5434(int i, int j) {
            return class_1799.field_8037;
        }

        public class_1799 method_5441(int i) {
            return class_1799.field_8037;
        }

        public void method_5447(int i, class_1799 itemStack) {
        }

        public void method_5431() {
        }

        public boolean method_5443(class_1657 player) {
            return false;
        }

        public void method_5448() {
        }
    };
    private final int width;
    private final int height;
    private final Supplier<class_1799> getter;
    private final Consumer<class_1799> setter;
    private final ToIntFunction<class_1799> inserter;
    private final Function<Integer, class_1799> extractor;
    private final ToIntFunction<class_1799> capacity;
    private final Predicate<class_1799> filter;
    private final CustomSlot.SlotChangeListener onInsert;
    private final CustomSlot.SlotChangeListener onExtract;
    private final boolean canInsert;
    private final boolean canExtract;
    private final boolean scaleItemToSize;
    private final boolean showBackground;
    private final boolean showItem;
    private final boolean showHighlight;
    private boolean active = true;

    static CustomSlot.Builder builder() {
        return new BuilderImpl();
    }

    private CustomSlotImpl(class_1263 vanillaContainer, int vanillaSlot, int x, int y, int width, int height, Supplier<class_1799> getter, Consumer<class_1799> setter, ToIntFunction<class_1799> inserter, Function<Integer, class_1799> extractor, ToIntFunction<class_1799> capacity, Predicate<class_1799> filter, CustomSlot.SlotChangeListener onInsert, CustomSlot.SlotChangeListener onExtract, boolean canInsert, boolean canExtract, boolean scaleItemToSize, boolean showBackground, boolean showItem, boolean showHighlight) {
        super(vanillaContainer == null ? EMPTY_CONTAINER : vanillaContainer, vanillaSlot, x, y);
        this.width = width;
        this.height = height;
        this.getter = getter == null ? () -> class_1799.field_8037 : getter;
        Consumer<class_1799> consumer = this.setter = setter == null ? stack -> {} : setter;
        ToIntFunction<class_1799> toIntFunction = inserter == null ? (setter == null ? stack -> 0 : stack -> {
            if (stack.method_7960()) {
                return 0;
            }
            class_1799 currentStack = this.getter.get();
            if (!currentStack.method_7960() && !class_1799.method_31577((class_1799)stack, (class_1799)currentStack)) {
                return 0;
            }
            int inserted = Math.min(stack.method_7947(), stack.method_7914() - currentStack.method_7947());
            if (capacity != null) {
                inserted = Math.min(inserted, capacity.applyAsInt((class_1799)stack));
            }
            setter.accept(stack.method_46651(currentStack.method_7947() + inserted));
            return inserted;
        }) : (this.inserter = inserter);
        this.extractor = extractor == null ? (setter == null ? amount -> class_1799.field_8037 : amount -> {
            if (amount <= 0) {
                return class_1799.field_8037;
            }
            class_1799 currentStack = this.getter.get();
            if (currentStack.method_7960()) {
                return class_1799.field_8037;
            }
            int extracted = Math.min(amount, currentStack.method_7947());
            class_1799 extractedStack = currentStack.method_46651(extracted);
            setter.accept(currentStack.method_46651(currentStack.method_7947() - extracted));
            return extractedStack;
        }) : extractor;
        this.capacity = capacity == null ? stack -> stack.method_7960() ? 64 : stack.method_7914() : capacity;
        this.filter = filter == null ? stack -> true : filter;
        this.onInsert = onInsert == null ? (oldStack, newStack) -> {} : onInsert;
        this.onExtract = onExtract == null ? (oldStack, newStack) -> {} : onExtract;
        this.canInsert = canInsert;
        this.canExtract = canExtract;
        this.scaleItemToSize = scaleItemToSize;
        this.showBackground = showBackground;
        this.showItem = showItem;
        this.showHighlight = showHighlight;
    }

    @Override
    public class_1735 getVanillaSlot() {
        return this;
    }

    @Override
    public void move(int x, int y) {
        this.field_7873 = x;
        this.field_7872 = y;
    }

    @Override
    public void setActive(boolean active) {
        this.active = active;
    }

    @Override
    public int getX() {
        return this.field_7873;
    }

    @Override
    public int getY() {
        return this.field_7872;
    }

    @Override
    public int getWidth() {
        return this.width;
    }

    @Override
    public int getHeight() {
        return this.height;
    }

    @Override
    public boolean scaleItemToSize() {
        return this.scaleItemToSize;
    }

    @Override
    public boolean showBackground() {
        return this.showBackground;
    }

    @Override
    public boolean showItem() {
        return this.showItem;
    }

    @Override
    public boolean showHighlight() {
        return this.showHighlight;
    }

    public boolean method_7680(class_1799 stack) {
        return this.canInsert && this.filter.test(stack);
    }

    @Override
    public class_1799 method_7677() {
        return this.getter.get();
    }

    public void method_7673(class_1799 stack) {
        class_1799 original = this.getter.get();
        this.setter.accept(stack);
        class_1799 newStack = this.getter.get();
        if (!class_1799.method_7973((class_1799)original, (class_1799)newStack)) {
            if (newStack.method_7960()) {
                this.onExtract.onChange(original, newStack);
            } else {
                this.onInsert.onChange(original, newStack);
            }
        }
    }

    public int method_7675() {
        return this.capacity.applyAsInt(class_1799.field_8037);
    }

    public int method_7676(class_1799 stack) {
        return this.capacity.applyAsInt(stack);
    }

    public class_1799 method_7671(int amount) {
        return this.extractor.apply(amount);
    }

    public boolean method_7674(class_1657 player) {
        return this.canExtract;
    }

    @Override
    public boolean method_7682() {
        return this.active;
    }

    public Optional<class_1799> method_34264(int amount, int ignored, class_1657 player) {
        if (!this.method_7674(player)) {
            return Optional.empty();
        }
        class_1799 original = this.getter.get();
        class_1799 extracted = this.extractor.apply(amount);
        class_1799 newStack = this.getter.get();
        if (!class_1799.method_7973((class_1799)original, (class_1799)newStack)) {
            this.onInsert.onChange(original, newStack);
        }
        return extracted.method_7960() ? Optional.empty() : Optional.of(extracted);
    }

    public class_1799 method_32755(class_1799 stack, int amount) {
        if (stack.method_7960() || !this.method_7680(stack)) {
            return stack;
        }
        class_1799 original = this.getter.get();
        int inserted = this.inserter.applyAsInt(stack.method_46651(amount));
        stack.method_7934(inserted);
        class_1799 newStack = this.getter.get();
        if (!class_1799.method_7973((class_1799)original, (class_1799)newStack)) {
            this.onExtract.onChange(original, newStack);
        }
        return stack;
    }

    public boolean method_51306() {
        return this.showBackground;
    }

    private static class BuilderImpl
    implements CustomSlot.Builder {
        private int x;
        private int y;
        private int width = 18;
        private int height = 18;
        private Supplier<class_1799> getter;
        private Consumer<class_1799> setter;
        private ToIntFunction<class_1799> inserter;
        private Function<Integer, class_1799> extractor;
        private ToIntFunction<class_1799> capacity;
        private Predicate<class_1799> filter;
        private CustomSlot.SlotChangeListener onInsert;
        private CustomSlot.SlotChangeListener onExtract;
        private boolean canInsert = true;
        private boolean canExtract = true;
        private boolean scaleItemToSize = false;
        private boolean showBackground = true;
        private boolean showItem = true;
        private boolean showHighlight = true;
        private class_1263 vanillaContainer;
        private int vanillaSlot;

        private BuilderImpl() {
        }

        @Override
        public CustomSlot.Builder position(int x, int y) {
            this.x = x;
            this.y = y;
            return this;
        }

        @Override
        public CustomSlot.Builder size(int width, int height) {
            this.width = width;
            this.height = height;
            return this;
        }

        @Override
        public CustomSlot.Builder size(int size) {
            return this.size(size, size);
        }

        @Override
        public CustomSlot.Builder getter(Supplier<class_1799> getter) {
            this.getter = getter;
            return this;
        }

        @Override
        public CustomSlot.Builder setter(Consumer<class_1799> getter) {
            this.setter = getter;
            return this;
        }

        @Override
        public CustomSlot.Builder inserter(ToIntFunction<class_1799> inserter) {
            this.inserter = inserter;
            return this;
        }

        @Override
        public CustomSlot.Builder extractor(Function<Integer, class_1799> extractor) {
            this.extractor = extractor;
            return this;
        }

        @Override
        public CustomSlot.Builder capacity(ToIntFunction<class_1799> capacity) {
            this.capacity = capacity;
            return this;
        }

        @Override
        public CustomSlot.Builder filter(Predicate<class_1799> filter) {
            this.filter = filter;
            return this;
        }

        @Override
        public CustomSlot.Builder onInsert(CustomSlot.SlotChangeListener onInsert) {
            this.onInsert = onInsert;
            return this;
        }

        @Override
        public CustomSlot.Builder onExtract(CustomSlot.SlotChangeListener onExtract) {
            this.onExtract = onExtract;
            return this;
        }

        @Override
        public CustomSlot.Builder onChange(CustomSlot.SlotChangeListener onChange) {
            return this.onInsert(onChange).onExtract(onChange);
        }

        @Override
        public CustomSlot.Builder vanillaContainer(int index, class_1263 container) {
            this.getter(() -> container.method_5438(index));
            this.setter(stack -> {
                container.method_5447(index, stack);
                container.method_5431();
            });
            this.inserter(stack -> {
                if (stack.method_7960()) {
                    return 0;
                }
                class_1799 currentStack = container.method_5438(index);
                int amount = Math.min(stack.method_7947(), container.method_58350(stack) - currentStack.method_7947());
                if (amount <= 0 || !currentStack.method_7960() && !class_1799.method_31577((class_1799)stack, (class_1799)currentStack)) {
                    return 0;
                }
                container.method_5447(index, stack.method_46651(currentStack.method_7947() + amount));
                container.method_5431();
                return amount;
            });
            this.extractor(amount -> {
                class_1799 extracted = container.method_5434(index, amount.intValue());
                if (!extracted.method_7960()) {
                    if (container.method_5438(index).method_7960()) {
                        container.method_5447(index, class_1799.field_8037);
                    }
                    container.method_5431();
                }
                return extracted;
            });
            this.capacity(stack -> stack.method_7960() ? container.method_5444() : container.method_58350(stack));
            this.vanillaContainer = container;
            this.vanillaSlot = index;
            return this;
        }

        @Override
        public CustomSlot.Builder playerInventory(int index, class_1661 inventory) {
            return this.vanillaContainer(index, (class_1263)inventory);
        }

        @Override
        public CustomSlot.Builder itemStorage(Supplier<Storage<ItemVariant>> storageSupplier) {
            this.getter(() -> {
                Storage storage = (Storage)storageSupplier.get();
                Iterator iterator = storage.nonEmptyViews().iterator();
                if (iterator.hasNext()) {
                    StorageView view = (StorageView)iterator.next();
                    return ((ItemVariant)view.getResource()).toStack((int)Math.min(Integer.MAX_VALUE, view.getAmount()));
                }
                return class_1799.field_8037;
            });
            this.inserter(stack -> {
                Transaction transaction;
                Storage storage = (Storage)storageSupplier.get();
                try (Transaction transaction2 = transaction = Transaction.isOpen() ? Transaction.getCurrentUnsafe().getOpenTransaction(Transaction.getCurrentUnsafe().nestingDepth()).openNested() : Transaction.openOuter();){
                    int inserted = (int)storage.insert((Object)ItemVariant.of((class_1799)stack), (long)stack.method_7947(), (TransactionContext)transaction);
                    if (inserted < 0) {
                        throw new IllegalStateException("Item storage of class '" + storage.getClass().getName() + "' returned negative amount for #insert!");
                    }
                    transaction.commit();
                    int n = inserted;
                    return n;
                }
            });
            this.extractor(amount -> {
                Storage storage = (Storage)storageSupplier.get();
                Iterator iterator = storage.nonEmptyViews().iterator();
                if (iterator.hasNext()) {
                    Transaction transaction;
                    StorageView view = (StorageView)iterator.next();
                    try (Transaction transaction2 = transaction = Transaction.isOpen() ? Transaction.getCurrentUnsafe().getOpenTransaction(Transaction.getCurrentUnsafe().nestingDepth()).openNested() : Transaction.openOuter();){
                        ItemVariant resource = (ItemVariant)view.getResource();
                        int extracted = (int)view.extract((Object)resource, (long)amount.intValue(), (TransactionContext)transaction);
                        if (extracted < 0) {
                            throw new IllegalStateException("Item storage of class '" + storage.getClass().getName() + "' returned negative amount for #extract from storage view!");
                        }
                        transaction.commit();
                        class_1799 class_17992 = resource.toStack(extracted);
                        return class_17992;
                    }
                }
                return class_1799.field_8037;
            });
            this.capacity(stack -> {
                Storage storage = (Storage)storageSupplier.get();
                Iterator iterator = storage.iterator();
                if (iterator.hasNext()) {
                    StorageView view = (StorageView)iterator.next();
                    long capacity = view.getCapacity();
                    if (capacity < 0L) {
                        throw new IllegalStateException("Item storage of class '" + storage.getClass().getName() + "' returned negative amount for #capacity from storage view!");
                    }
                    return (int)Math.min(Integer.MAX_VALUE, capacity);
                }
                return stack.method_7960() ? 99 : stack.method_7914();
            });
            return this;
        }

        @Override
        public CustomSlot.Builder itemStorage(int index, Supplier<SlottedStorage<ItemVariant>> storageSupplier) {
            this.getter(() -> {
                SlottedStorage storage = (SlottedStorage)storageSupplier.get();
                if (index >= storage.getSlotCount()) {
                    return class_1799.field_8037;
                }
                SingleSlotStorage slot = storage.getSlot(index);
                long amount = slot.getAmount();
                if (amount < 0L) {
                    throw new IllegalStateException("Item storage of class '" + ((SlottedStorage)storageSupplier.get()).getClass().getName() + "' returned negative amount from storage view!");
                }
                return ((ItemVariant)slot.getResource()).toStack((int)Math.min(Integer.MAX_VALUE, amount));
            });
            this.inserter(stack -> {
                Transaction transaction;
                SlottedStorage storage = (SlottedStorage)storageSupplier.get();
                if (index >= storage.getSlotCount()) {
                    return 0;
                }
                SingleSlotStorage slot = storage.getSlot(index);
                try (Transaction transaction2 = transaction = Transaction.isOpen() ? Transaction.getCurrentUnsafe().getOpenTransaction(Transaction.getCurrentUnsafe().nestingDepth()).openNested() : Transaction.openOuter();){
                    int inserted = (int)slot.insert((Object)ItemVariant.of((class_1799)stack), (long)stack.method_7947(), (TransactionContext)transaction);
                    if (inserted < 0) {
                        throw new IllegalStateException("Item storage of class '" + storage.getClass().getName() + "' returned negative amount for #insert for slot at index '" + index + "'!");
                    }
                    transaction.commit();
                    int n = inserted;
                    return n;
                }
            });
            this.extractor(amount -> {
                Transaction transaction;
                SlottedStorage storage = (SlottedStorage)storageSupplier.get();
                if (index >= storage.getSlotCount()) {
                    return class_1799.field_8037;
                }
                SingleSlotStorage slot = storage.getSlot(index);
                try (Transaction transaction2 = transaction = Transaction.isOpen() ? Transaction.getCurrentUnsafe().getOpenTransaction(Transaction.getCurrentUnsafe().nestingDepth()).openNested() : Transaction.openOuter();){
                    ItemVariant resource = (ItemVariant)slot.getResource();
                    int extracted = (int)slot.extract((Object)resource, (long)amount.intValue(), (TransactionContext)transaction);
                    if (extracted < 0) {
                        throw new IllegalStateException("Item storage of class '" + storage.getClass().getName() + "' returned negative amount for #insert for slot at index '" + index + "'!");
                    }
                    transaction.commit();
                    class_1799 class_17992 = resource.toStack(extracted);
                    return class_17992;
                }
            });
            this.capacity(stack -> {
                SlottedStorage storage = (SlottedStorage)storageSupplier.get();
                if (index >= storage.getSlotCount()) {
                    return 0;
                }
                long capacity = storage.getSlot(index).getCapacity();
                if (capacity < 0L) {
                    throw new IllegalStateException("Item storage of class '" + storage.getClass().getName() + "' returned negative amount for #capacity for slot at index '" + index + "'!");
                }
                return (int)Math.min(Integer.MAX_VALUE, capacity);
            });
            return this;
        }

        @Override
        public CustomSlot.Builder canInsert(boolean canInsert) {
            this.canInsert = canInsert;
            return this;
        }

        @Override
        public CustomSlot.Builder canExtract(boolean canExtract) {
            this.canExtract = canExtract;
            return this;
        }

        @Override
        public CustomSlot.Builder canInsertExtract(boolean mutable) {
            return this.canExtract(mutable).canInsert(mutable);
        }

        @Override
        public CustomSlot.Builder scaleItemToSize(boolean scaleItemToSize) {
            this.scaleItemToSize = scaleItemToSize;
            return this;
        }

        @Override
        public CustomSlot.Builder scaleItemToSize() {
            return this.scaleItemToSize(true);
        }

        @Override
        public CustomSlot.Builder showBackground(boolean showBackground) {
            this.showBackground = showBackground;
            return this;
        }

        @Override
        public CustomSlot.Builder noBackground() {
            this.showBackground = false;
            return this;
        }

        @Override
        public CustomSlot.Builder showItem(boolean showItem) {
            this.showItem = showItem;
            return this;
        }

        @Override
        public CustomSlot.Builder showHighlight(boolean showHighlight) {
            this.showHighlight = showHighlight;
            return this;
        }

        @Override
        public CustomSlot build() {
            return new CustomSlotImpl(this.vanillaContainer, this.vanillaSlot, this.x, this.y, this.width, this.height, this.getter, this.setter, this.inserter, this.extractor, this.capacity, this.filter, this.onInsert, this.onExtract, this.canInsert, this.canExtract, this.scaleItemToSize, this.showBackground, this.showItem, this.showHighlight);
        }
    }
}

