/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.core.generator;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.supermartijn642.core.generator.ResourceCache;
import com.supermartijn642.core.generator.ResourceGenerator;
import com.supermartijn642.core.generator.ResourceType;
import com.supermartijn642.core.registry.Registries;
import com.supermartijn642.core.util.Pair;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import net.minecraft.class_2248;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import org.jetbrains.annotations.NotNull;

public abstract class BlockStateGenerator
extends ResourceGenerator {
    private final Map<class_2248, BlockStateBuilder> blockStates = new HashMap<class_2248, BlockStateBuilder>();

    public BlockStateGenerator(String modid, ResourceCache cache) {
        super(modid, cache);
    }

    @Override
    public void save() {
        for (BlockStateBuilder blockStateBuilder : this.blockStates.values()) {
            class_2960 block = Registries.BLOCKS.getIdentifier(blockStateBuilder.block);
            JsonObject json = new JsonObject();
            JsonObject variantsJson = new JsonObject();
            ArrayList<Map.Entry<PartialBlockState, VariantBuilder>> variants = new ArrayList<Map.Entry<PartialBlockState, VariantBuilder>>(blockStateBuilder.variants.entrySet());
            variants.sort(Map.Entry.comparingByKey());
            for (Map.Entry<PartialBlockState, VariantBuilder> variantEntry : variants) {
                if (variantEntry.getValue().models.isEmpty()) continue;
                String name = BlockStateGenerator.formatVariantName(variantEntry.getKey());
                variantsJson.add(name, this.serializeVariant(variantEntry.getValue(), block));
            }
            if (variantsJson.size() > 0) {
                json.add("variants", (JsonElement)variantsJson);
            }
            JsonArray multipartsJson = new JsonArray();
            for (Pair<MultipartConditionBuilder, VariantBuilder> multipartEntry : blockStateBuilder.multipartVariants) {
                if (multipartEntry.right().models.isEmpty()) continue;
                JsonObject multipartJson = new JsonObject();
                multipartJson.add("apply", this.serializeVariant(multipartEntry.right(), block));
                multipartEntry.left().flatten();
                JsonArray whenJson = new JsonArray();
                for (MultipartConditionBuilder condition : multipartEntry.left().or) {
                    if (condition.properties.isEmpty()) continue;
                    JsonObject conditionJson = new JsonObject();
                    condition.properties.forEach((property, values) -> conditionJson.addProperty(property.method_11899(), Arrays.stream(values).map(arg_0 -> ((class_2769)property).method_11901(arg_0)).collect(Collectors.joining("|"))));
                    whenJson.add((JsonElement)conditionJson);
                }
                if (whenJson.size() == 1) {
                    multipartJson.add("when", whenJson.get(0));
                } else if (!whenJson.isEmpty()) {
                    JsonObject newWhenJson = new JsonObject();
                    newWhenJson.add("OR", (JsonElement)whenJson);
                    multipartJson.add("when", (JsonElement)newWhenJson);
                }
                multipartsJson.add((JsonElement)multipartJson);
            }
            if (!multipartsJson.isEmpty()) {
                json.add("multipart", (JsonElement)multipartsJson);
            }
            if (variantsJson.size() == 0 && multipartsJson.isEmpty()) {
                throw new RuntimeException("Block state for block '" + String.valueOf(block) + "' is empty!");
            }
            this.cache.saveJsonResource(ResourceType.ASSET, json, block.method_12836(), "blockstates", block.method_12832());
        }
    }

    private JsonElement serializeVariant(VariantBuilder builder, class_2960 block) {
        JsonObject[] models = new JsonObject[builder.models.size()];
        for (int i = 0; i < models.length; ++i) {
            VariantModel model = builder.models.get(i);
            JsonObject modelJson = new JsonObject();
            if (!this.cache.doesResourceExist(ResourceType.ASSET, model.modelLocation.method_12836(), "models", model.modelLocation.method_12832(), ".json")) {
                throw new RuntimeException("Could not find model '" + String.valueOf(model.modelLocation) + "' in block state for block '" + String.valueOf(block) + "'!");
            }
            modelJson.addProperty("model", model.modelLocation.toString());
            if (model.xRotation != 0) {
                modelJson.addProperty("x", (Number)model.xRotation);
            }
            if (model.yRotation != 0) {
                modelJson.addProperty("y", (Number)model.yRotation);
            }
            if (model.uvLock) {
                modelJson.addProperty("uvlock", Boolean.valueOf(true));
            }
            if (model.weight != 1 && models.length > 1) {
                modelJson.addProperty("weight", (Number)model.weight);
            }
            models[i] = modelJson;
        }
        return models.length > 1 ? BlockStateGenerator.createJsonArray((JsonElement[])models) : models[0];
    }

    private static JsonArray createJsonArray(JsonElement ... elements) {
        JsonArray array = new JsonArray(elements.length);
        for (JsonElement element : elements) {
            array.add(element);
        }
        return array;
    }

    private static String formatVariantName(PartialBlockState state) {
        return state.properties.entrySet().stream().map(entry -> ((class_2769)entry.getKey()).method_11899() + "=" + ((class_2769)entry.getKey()).method_11901((Comparable)entry.getValue())).collect(Collectors.joining(","));
    }

    protected PartialBlockStateBuilder createPartialStateBuilder(class_2248 block) {
        return new PartialBlockStateBuilder(block);
    }

    protected PartialBlockState createEmptyPartialState(class_2248 block) {
        return this.createPartialStateBuilder(block).build();
    }

    protected PartialBlockState createPartialState(class_2680 state) {
        return this.createPartialStateBuilder(state.method_26204()).copy(state).build();
    }

    protected BlockStateBuilder blockState(class_2248 block) {
        class_2960 identifier = Registries.BLOCKS.getIdentifier(block);
        this.cache.trackToBeGeneratedResource(ResourceType.ASSET, identifier.method_12836(), "blockstates", identifier.method_12832(), ".json");
        return this.blockStates.computeIfAbsent(block, o -> new BlockStateBuilder(this.modid, (class_2248)o));
    }

    @Override
    public String getName() {
        return this.modName + " Block State Generator";
    }

    private static int compareProperties(Map<class_2769<?>, Comparable<?>> properties1, Map<class_2769<?>, Comparable<?>> properties2) {
        if (properties1.size() != properties2.size()) {
            return properties1.size() - properties2.size();
        }
        Iterator<Map.Entry<class_2769<?>, Comparable<?>>> iterator1 = properties1.entrySet().iterator();
        Iterator<Map.Entry<class_2769<?>, Comparable<?>>> iterator2 = properties2.entrySet().iterator();
        while (iterator1.hasNext() && iterator2.hasNext()) {
            Comparable<?> value2;
            class_2769<?> property2;
            Map.Entry<class_2769<?>, Comparable<?>> entry1 = iterator1.next();
            Map.Entry<class_2769<?>, Comparable<?>> entry2 = iterator2.next();
            class_2769<?> property1 = entry1.getKey();
            if (property1 != (property2 = entry2.getKey())) {
                return property1.method_11899().compareTo(property2.method_11899());
            }
            Comparable<?> value1 = entry1.getValue();
            if (value1.equals(value2 = entry2.getValue())) continue;
            return property1.method_11901(value1).compareTo(property2.method_11901(value2));
        }
        if (iterator1.hasNext() || iterator2.hasNext()) {
            throw new AssertionError();
        }
        return 0;
    }

    private static int compareMultiProperties(Map<class_2769<?>, Comparable<?>[]> properties1, Map<class_2769<?>, Comparable<?>[]> properties2) {
        if (properties1.size() != properties2.size()) {
            return properties1.size() - properties2.size();
        }
        Iterator<Map.Entry<class_2769<?>, Comparable<?>[]>> iterator1 = properties1.entrySet().iterator();
        Iterator<Map.Entry<class_2769<?>, Comparable<?>[]>> iterator2 = properties2.entrySet().iterator();
        while (iterator1.hasNext() && iterator2.hasNext()) {
            Comparable<?>[] values2;
            class_2769<?> property2;
            Map.Entry<class_2769<?>, Comparable<?>[]> entry1 = iterator1.next();
            Map.Entry<class_2769<?>, Comparable<?>[]> entry2 = iterator2.next();
            class_2769<?> property1 = entry1.getKey();
            if (property1 != (property2 = entry2.getKey())) {
                return property1.method_11899().compareTo(property2.method_11899());
            }
            Comparable<?>[] values1 = entry1.getValue();
            int compare = Arrays.compare(values1, values2 = entry2.getValue(), Comparator.comparing(v -> property1.method_11901(v)));
            if (compare == 0) continue;
            return compare;
        }
        if (iterator1.hasNext() || iterator2.hasNext()) {
            throw new AssertionError();
        }
        return 0;
    }

    protected class BlockStateBuilder {
        private final String modid;
        private final class_2248 block;
        private final Map<PartialBlockState, VariantBuilder> variants = new LinkedHashMap<PartialBlockState, VariantBuilder>();
        private final List<Pair<MultipartConditionBuilder, VariantBuilder>> multipartVariants = new ArrayList<Pair<MultipartConditionBuilder, VariantBuilder>>();

        public BlockStateBuilder(String modid, class_2248 block) {
            this.modid = modid;
            this.block = block;
        }

        public BlockStateBuilder variant(PartialBlockState state, Consumer<VariantBuilder> variantBuilderConsumer) {
            if (state.block != this.block) {
                throw new IllegalArgumentException("Cannot use state from block '" + String.valueOf(state.block) + "' in block state builder for block '" + String.valueOf(this.block) + "'!");
            }
            variantBuilderConsumer.accept(this.variants.computeIfAbsent(state, o -> new VariantBuilder(this.modid)));
            return this;
        }

        public BlockStateBuilder variant(class_2680 state, Consumer<VariantBuilder> variantBuilderConsumer) {
            return this.variant(BlockStateGenerator.this.createPartialState(state), variantBuilderConsumer);
        }

        public BlockStateBuilder emptyVariant(Consumer<VariantBuilder> variantBuilderConsumer) {
            return this.variant(BlockStateGenerator.this.createEmptyPartialState(this.block), variantBuilderConsumer);
        }

        public BlockStateBuilder variantsForProperty(class_2769<?> property, BiConsumer<PartialBlockState, VariantBuilder> variantBuilderConsumer) {
            if (!this.block.method_9595().method_11659().contains(property)) {
                throw new IllegalArgumentException("Property '" + String.valueOf(property) + "' is not a property of block '" + String.valueOf(Registries.BLOCKS.getIdentifier(this.block)) + "'!");
            }
            PartialBlockStateBuilder builder = BlockStateGenerator.this.createPartialStateBuilder(this.block);
            for (Comparable value : property.method_11898()) {
                PartialBlockState state = builder.set(property, value).build();
                variantBuilderConsumer.accept(state, this.variants.computeIfAbsent(state, o -> new VariantBuilder(this.modid)));
            }
            return this;
        }

        public BlockStateBuilder variantsForAllExcept(BiConsumer<PartialBlockState, VariantBuilder> variantBuilderConsumer, class_2769<?> ... excluded) {
            PartialBlockStateBuilder builder = BlockStateGenerator.this.createPartialStateBuilder(this.block);
            List<class_2769<?>> properties = this.block.method_9595().method_11659().stream().filter(property -> Arrays.stream(excluded).noneMatch(p -> p == property)).collect(Collectors.toList());
            this.loopThroughAll(builder, properties, 0, variantBuilderConsumer);
            return this;
        }

        private void loopThroughAll(PartialBlockStateBuilder builder, List<class_2769<?>> properties, int index, BiConsumer<PartialBlockState, VariantBuilder> variantBuilderConsumer) {
            if (index == properties.size()) {
                PartialBlockState state = builder.build();
                variantBuilderConsumer.accept(state, this.variants.computeIfAbsent(state, o -> new VariantBuilder(this.modid)));
                return;
            }
            class_2769<?> property = properties.get(index);
            for (Comparable value : property.method_11898()) {
                builder.set(property, value);
                this.loopThroughAll(builder, properties, index + 1, variantBuilderConsumer);
            }
        }

        public BlockStateBuilder variantsForAll(BiConsumer<PartialBlockState, VariantBuilder> variantBuilderConsumer) {
            return this.variantsForAllExcept(variantBuilderConsumer, new class_2769[0]);
        }

        public BlockStateBuilder multipart(Consumer<MultipartConditionBuilder> conditionBuilderConsumer, Consumer<VariantBuilder> variantBuilderConsumer) {
            MultipartConditionBuilder condition = new MultipartConditionBuilder(this.block);
            conditionBuilderConsumer.accept(condition);
            VariantBuilder variant = new VariantBuilder(this.modid);
            variantBuilderConsumer.accept(variant);
            this.multipartVariants.add(Pair.of(condition, variant));
            return this;
        }

        public BlockStateBuilder multipart(PartialBlockState state, Consumer<VariantBuilder> variantBuilderConsumer) {
            if (state.block != this.block) {
                throw new IllegalArgumentException("Cannot use state from block '" + String.valueOf(state.block) + "' in block state builder for block '" + String.valueOf(this.block) + "'!");
            }
            return this.multipart((MultipartConditionBuilder condition) -> state.properties.forEach((property, value) -> condition.requireProperty((class_2769)property, new Comparable[]{value})), variantBuilderConsumer);
        }

        public BlockStateBuilder multipart(class_2680 state, Consumer<VariantBuilder> variantBuilderConsumer) {
            return this.multipart(BlockStateGenerator.this.createPartialState(state), variantBuilderConsumer);
        }

        public BlockStateBuilder unconditionalMultipart(Consumer<VariantBuilder> variantBuilderConsumer) {
            return this.multipart(BlockStateGenerator.this.createEmptyPartialState(this.block), variantBuilderConsumer);
        }
    }

    protected static class VariantBuilder {
        private final String modid;
        private final List<VariantModel> models = new ArrayList<VariantModel>();

        protected VariantBuilder(String modid) {
            this.modid = modid;
        }

        public VariantBuilder model(class_2960 modelLocation, int xRotation, int yRotation, boolean uvLock, int weight) {
            this.models.add(new VariantModel(modelLocation, xRotation, yRotation, uvLock, weight));
            return this;
        }

        public VariantBuilder model(String namespace, String identifier, int xRotation, int yRotation, boolean uvLock, int weight) {
            return this.model(class_2960.method_60655((String)namespace, (String)identifier), xRotation, yRotation, uvLock, weight);
        }

        public VariantBuilder model(String identifier, int xRotation, int yRotation, boolean uvLock, int weight) {
            return this.model(this.modid, identifier, xRotation, yRotation, uvLock, weight);
        }

        public VariantBuilder model(class_2960 modelLocation, int xRotation, int yRotation, boolean uvLock) {
            return this.model(modelLocation, xRotation, yRotation, uvLock, 1);
        }

        public VariantBuilder model(String namespace, String identifier, int xRotation, int yRotation, boolean uvLock) {
            return this.model(class_2960.method_60655((String)namespace, (String)identifier), xRotation, yRotation, uvLock);
        }

        public VariantBuilder model(String identifier, int xRotation, int yRotation, boolean uvLock) {
            return this.model(this.modid, identifier, xRotation, yRotation, uvLock);
        }

        public VariantBuilder model(class_2960 modelLocation, int xRotation, int yRotation) {
            return this.model(modelLocation, xRotation, yRotation, false, 1);
        }

        public VariantBuilder model(String namespace, String identifier, int xRotation, int yRotation) {
            return this.model(class_2960.method_60655((String)namespace, (String)identifier), xRotation, yRotation);
        }

        public VariantBuilder model(String identifier, int xRotation, int yRotation) {
            return this.model(this.modid, identifier, xRotation, yRotation);
        }

        public VariantBuilder model(class_2960 modelLocation) {
            return this.model(modelLocation, 0, 0, false, 1);
        }

        public VariantBuilder model(String namespace, String identifier) {
            return this.model(class_2960.method_60655((String)namespace, (String)identifier));
        }

        public VariantBuilder model(String identifier) {
            return this.model(this.modid, identifier);
        }
    }

    protected static class PartialBlockState
    implements Comparable<PartialBlockState> {
        private final class_2248 block;
        private final Map<class_2769<?>, Comparable<?>> properties;

        protected PartialBlockState(class_2248 block, Map<class_2769<?>, Comparable<?>> properties) {
            this.block = block;
            this.properties = Collections.unmodifiableMap(properties.entrySet().stream().sorted(Comparator.comparing(e -> ((class_2769)e.getKey()).method_11899())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (p1, p2) -> p1, LinkedHashMap::new)));
        }

        public class_2248 getBlock() {
            return this.block;
        }

        public boolean has(class_2769<?> property) {
            return this.properties.containsKey(property);
        }

        public <T extends Comparable<T>> T get(class_2769<T> property) {
            if (!this.block.method_9595().method_11659().contains(property)) {
                throw new IllegalArgumentException("Property '" + String.valueOf(property) + "' is not a property of block '" + String.valueOf(Registries.BLOCKS.getIdentifier(this.block)) + "'!");
            }
            return (T)this.properties.get(property);
        }

        @Override
        public int compareTo(@NotNull PartialBlockState o) {
            if (this.block != o.block) {
                class_2960 identifier = Registries.BLOCKS.getIdentifier(this.block);
                class_2960 otherIdentifier = Registries.BLOCKS.getIdentifier(o.block);
                return identifier.method_12833(otherIdentifier);
            }
            return BlockStateGenerator.compareProperties(this.properties, o.properties);
        }
    }

    protected static class MultipartConditionBuilder {
        private final class_2248 block;
        private Map<class_2769<?>, Comparable<?>[]> properties = new HashMap();
        private final List<MultipartConditionBuilder> or = new ArrayList<MultipartConditionBuilder>();

        private MultipartConditionBuilder(class_2248 block) {
            this.block = block;
        }

        public <T extends Comparable<T>> MultipartConditionBuilder requireProperty(class_2769<T> property, T ... acceptedValues) {
            if (acceptedValues.length == 0) {
                throw new RuntimeException("Accepted values cannot be empty for multipart condition property!");
            }
            if (this.properties.containsKey(property)) {
                throw new RuntimeException("Duplicate requirements for property '" + String.valueOf(property) + "' for multipart condition for block '" + String.valueOf(Registries.BLOCKS.getIdentifier(this.block)) + "'!");
            }
            if (!this.block.method_9595().method_11659().contains(property)) {
                throw new IllegalArgumentException("Property '" + String.valueOf(property) + "' is not a property of block '" + String.valueOf(Registries.BLOCKS.getIdentifier(this.block)) + "'!");
            }
            for (T value : acceptedValues) {
                if (property.method_11898().contains(value)) continue;
                throw new IllegalArgumentException("Value '" + String.valueOf(value) + "' does not belong to property '" + String.valueOf(property) + "'!");
            }
            this.properties.put(property, (Comparable<?>[])acceptedValues);
            return this;
        }

        public MultipartConditionBuilder or(Consumer<MultipartConditionBuilder> alternativeBuilderConsumer) {
            MultipartConditionBuilder builder = new MultipartConditionBuilder(this.block);
            alternativeBuilderConsumer.accept(builder);
            if (builder.properties.isEmpty()) {
                throw new IllegalArgumentException("Alternative condition cannot be empty!");
            }
            this.or.add(builder);
            return this;
        }

        public MultipartConditionBuilder or() {
            MultipartConditionBuilder builder = new MultipartConditionBuilder(this.block);
            this.or.add(builder);
            return builder;
        }

        private void flatten() {
            this.or.add(0, this);
            for (int i = 1; i < this.or.size(); ++i) {
                this.or.addAll(this.or.get((int)i).or);
            }
            for (MultipartConditionBuilder b : this.or) {
                b.properties = Collections.unmodifiableMap(this.properties.entrySet().stream().sorted(Comparator.comparing(e -> ((class_2769)e.getKey()).method_11899())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (p1, p2) -> p1, LinkedHashMap::new)));
            }
            this.or.sort(Comparator.comparing(c -> c.properties, BlockStateGenerator::compareMultiProperties));
        }
    }

    protected static class VariantModel {
        public final class_2960 modelLocation;
        public final int xRotation;
        public final int yRotation;
        public final boolean uvLock;
        public final int weight;

        public VariantModel(class_2960 modelLocation, int xRotation, int yRotation, boolean uvLock, int weight) {
            this.modelLocation = modelLocation;
            this.xRotation = xRotation;
            this.yRotation = yRotation;
            this.uvLock = uvLock;
            this.weight = weight;
        }
    }

    protected static class PartialBlockStateBuilder {
        private final class_2248 block;
        private final Map<class_2769<?>, Comparable<?>> properties = new HashMap();

        protected PartialBlockStateBuilder(class_2248 block) {
            this.block = block;
        }

        public class_2248 getBlock() {
            return this.block;
        }

        public <T extends Comparable<T>> PartialBlockStateBuilder set(class_2769<T> property, T value) {
            if (!this.block.method_9595().method_11659().contains(property)) {
                throw new IllegalArgumentException("Property '" + String.valueOf(property) + "' is not a property of block '" + String.valueOf(Registries.BLOCKS.getIdentifier(this.block)) + "'!");
            }
            if (!property.method_11898().contains(value)) {
                throw new IllegalArgumentException("Value '" + String.valueOf(value) + "' does not belong to property '" + String.valueOf(property) + "'!");
            }
            this.properties.put(property, value);
            return this;
        }

        public PartialBlockStateBuilder copy(class_2680 state) {
            if (this.block != state.method_26204()) {
                throw new IllegalArgumentException("Cannot copy properties of state for block '" + String.valueOf(Registries.BLOCKS.getIdentifier(state.method_26204())) + "' to block '" + String.valueOf(Registries.BLOCKS.getIdentifier(this.block)) + "'!");
            }
            this.properties.putAll(state.method_11656());
            return this;
        }

        public boolean has(class_2769<?> property) {
            return this.properties.containsKey(property);
        }

        public <T extends Comparable<T>> T get(class_2769<T> property) {
            if (!this.block.method_9595().method_11659().contains(property)) {
                throw new IllegalArgumentException("Property '" + String.valueOf(property) + "' is not a property of block '" + String.valueOf(Registries.BLOCKS.getIdentifier(this.block)) + "'!");
            }
            return (T)this.properties.get(property);
        }

        public PartialBlockState build() {
            return new PartialBlockState(this.block, this.properties);
        }
    }
}

