/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.core.data.condition;

import com.google.gson.JsonObject;
import com.supermartijn642.core.data.condition.ResourceCondition;
import com.supermartijn642.core.data.condition.ResourceConditionContext;
import com.supermartijn642.core.data.condition.ResourceConditionSerializer;
import com.supermartijn642.core.registry.Registries;
import com.supermartijn642.core.registry.RegistryUtil;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_6862;

public class TagPopulatedResourceCondition
implements ResourceCondition {
    public static final Serializer SERIALIZER = new Serializer();
    private final Registries.Registry<?> registry;
    private final class_2960 tag;

    public TagPopulatedResourceCondition(Registries.Registry<?> registry, class_2960 tag) {
        if (!registry.hasVanillaRegistry()) {
            throw new IllegalArgumentException("Registry '" + String.valueOf(registry.getRegistryIdentifier()) + "' is not supported!");
        }
        this.registry = registry;
        this.tag = tag;
    }

    @Override
    public boolean test(ResourceConditionContext context) {
        class_2378<?> vanillaRegistry = this.registry.getVanillaRegistry();
        return vanillaRegistry.method_46733(class_6862.method_40092((class_5321)vanillaRegistry.method_46765(), (class_2960)this.tag)).isPresent();
    }

    @Override
    public ResourceConditionSerializer<?> getSerializer() {
        return SERIALIZER;
    }

    private static class Serializer
    implements ResourceConditionSerializer<TagPopulatedResourceCondition> {
        private Serializer() {
        }

        @Override
        public void serialize(JsonObject json, TagPopulatedResourceCondition condition) {
            json.addProperty("registry", condition.registry.getRegistryIdentifier().toString());
            json.addProperty("tag", condition.tag.toString());
        }

        @Override
        public TagPopulatedResourceCondition deserialize(JsonObject json) {
            if (!(json.has("registry") && json.get("registry").isJsonPrimitive() && json.getAsJsonPrimitive("registry").isString())) {
                throw new RuntimeException("Condition must have key 'registry' of type string!");
            }
            if (!(json.has("tag") && json.get("tag").isJsonPrimitive() && json.getAsJsonPrimitive("tag").isString())) {
                throw new RuntimeException("Condition must have key 'tag' of type string!");
            }
            if (!RegistryUtil.isValidIdentifier(json.get("registry").getAsString())) {
                throw new RuntimeException("Value for 'registry' must be a valid identifier!");
            }
            if (!RegistryUtil.isValidIdentifier(json.get("tag").getAsString())) {
                throw new RuntimeException("Value for 'tag' must be a valid identifier!");
            }
            Registries.Registry<?> registry = Registries.getRegistry(class_2960.method_60654((String)json.get("registry").getAsString()));
            if (registry == null) {
                throw new RuntimeException("Could not find a registry with identifier '" + json.get("registry").getAsString() + "'!");
            }
            class_2960 tag = class_2960.method_60654((String)json.get("tag").getAsString());
            return new TagPopulatedResourceCondition(registry, tag);
        }
    }
}

